/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class InitializedEvent
extends Event {
    InitializedEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializedEvent other = (InitializedEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.getEvent());
        hash = 47 * hash + Objects.hashCode(this.getType());
        if (this.getBody() != null) {
            hash = 47 * hash + Objects.hashCode(this.getBody());
        }
        hash = 47 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static InitializedEvent create(Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "initialized");
        json.put("type", "event");
        json.put("seq", seq);
        return new InitializedEvent(json);
    }
}

