/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.ValueFormat;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class EvaluateArguments
extends JSONBase {
    EvaluateArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public String getExpression() {
        return this.jsonData.getString("expression");
    }

    public EvaluateArguments setExpression(String expression) {
        this.jsonData.put("expression", expression);
        return this;
    }

    public Integer getFrameId() {
        return this.jsonData.has("frameId") ? Integer.valueOf(this.jsonData.getInt("frameId")) : null;
    }

    public EvaluateArguments setFrameId(Integer frameId) {
        this.jsonData.putOpt("frameId", frameId);
        return this;
    }

    public String getContext() {
        return this.jsonData.optString("context", null);
    }

    public EvaluateArguments setContext(String context) {
        this.jsonData.putOpt("context", context);
        return this;
    }

    public ValueFormat getFormat() {
        return this.jsonData.has("format") ? new ValueFormat(this.jsonData.optJSONObject("format")) : null;
    }

    public EvaluateArguments setFormat(ValueFormat format) {
        this.jsonData.putOpt("format", format != null ? format.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluateArguments other = (EvaluateArguments)obj;
        if (!Objects.equals(this.getExpression(), other.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.getFrameId(), other.getFrameId())) {
            return false;
        }
        if (!Objects.equals(this.getContext(), other.getContext())) {
            return false;
        }
        return Objects.equals(this.getFormat(), other.getFormat());
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.getExpression());
        if (this.getFrameId() != null) {
            hash = 41 * hash + Integer.hashCode(this.getFrameId());
        }
        if (this.getContext() != null) {
            hash = 41 * hash + Objects.hashCode(this.getContext());
        }
        if (this.getFormat() != null) {
            hash = 41 * hash + Objects.hashCode(this.getFormat());
        }
        return hash;
    }

    public static EvaluateArguments create(String expression) {
        JSONObject json = new JSONObject();
        json.put("expression", expression);
        return new EvaluateArguments(json);
    }
}

