/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.server.VariablesHandler;
import com.oracle.truffle.tools.dap.types.ContinuedEvent;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.StoppedEvent;
import com.oracle.truffle.tools.dap.types.Thread;
import com.oracle.truffle.tools.dap.types.ThreadEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ThreadsHandler
implements ThreadsListener {
    private static final Pattern LOGMESSAGE_VARIABLE_REGEXP = Pattern.compile("\\{(.*?)\\}");
    private final ExecutionContext context;
    private final DebuggerSession debuggerSession;
    private final Map<java.lang.Thread, Integer> thread2Ids = new LinkedHashMap<java.lang.Thread, Integer>();
    private final Map<Integer, java.lang.Thread> id2threads = new HashMap<Integer, java.lang.Thread>();
    private final Map<Integer, SuspendedThreadInfo> suspendedThreads = new HashMap<Integer, SuspendedThreadInfo>();
    private int lastThreadId = 0;
    private int lastRefId = 0;

    public ThreadsHandler(ExecutionContext context, DebuggerSession debuggerSession) {
        this.context = context;
        this.debuggerSession = debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onThreadInitialized(TruffleContext ctx, java.lang.Thread thread) {
        Integer id;
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            id = ++this.lastThreadId;
            this.thread2Ids.put(thread, id);
            this.id2threads.put(id, thread);
        }
        DebugProtocolClient client = this.context.getClient();
        if (client != null) {
            client.thread(ThreadEvent.EventBody.create("started", id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onThreadDisposed(TruffleContext ctx, java.lang.Thread thread) {
        DebugProtocolClient client;
        Integer id;
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            id = this.thread2Ids.remove(thread);
            this.id2threads.remove(id);
        }
        if (id != null && (client = this.context.getClient()) != null) {
            client.thread(ThreadEvent.EventBody.create("exited", id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getThreads() {
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            ArrayList<Thread> ret = new ArrayList<Thread>(this.thread2Ids.size());
            for (Map.Entry<java.lang.Thread, Integer> entry : this.thread2Ids.entrySet()) {
                ret.add(Thread.create(entry.getValue(), entry.getKey().getName()));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadSuspended(java.lang.Thread thread, SuspendedEvent event) {
        SuspendedThreadInfo info = null;
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            Integer id = this.thread2Ids.get(thread);
            if (id != null) {
                info = new SuspendedThreadInfo(id, event);
                this.suspendedThreads.put(id, info);
            }
        }
        if (info != null) {
            String reason = null;
            String description = null;
            ArrayList<String> logMessages = new ArrayList<String>();
            boolean stop = true;
            for (Breakpoint bp : event.getBreakpoints()) {
                String logMessage = this.context.getBreakpointsHandler().getLogMessage(bp);
                if (logMessage != null) {
                    logMessages.add(logMessage);
                }
                stop &= this.context.getBreakpointsHandler().checkConditions(bp, event.getTopStackFrame());
                switch (bp.getKind()) {
                    case EXCEPTION: {
                        reason = "exception";
                        description = "Paused on exception";
                        break;
                    }
                    case HALT_INSTRUCTION: {
                        reason = "debugger_statement";
                        description = "Paused on debugger statement";
                        break;
                    }
                    case SOURCE_LOCATION: {
                        reason = "breakpoint";
                        description = "Paused on breakpoint";
                    }
                }
            }
            if (stop) {
                if (logMessages.isEmpty()) {
                    DebugProtocolClient client;
                    DebugException exception = event.getException();
                    if (exception != null) {
                        boolean uncaught = exception.getCatchLocation() == null;
                        String string = description = uncaught ? "Paused on uncaught exception" : "Paused on caught exception";
                    }
                    if (reason == null) {
                        reason = "debugger_statement";
                        description = "Paused on debugger statement";
                    }
                    if ((client = this.context.getClient()) != null) {
                        client.stopped(StoppedEvent.EventBody.create(reason).setThreadId(info.getThreadId()).setDescription(description));
                    }
                } else {
                    info.executables.add(i -> {
                        for (String logMessage : logMessages) {
                            Matcher matcher = LOGMESSAGE_VARIABLE_REGEXP.matcher(logMessage);
                            StringBuilder sb = new StringBuilder();
                            int idx = 0;
                            while (matcher.find()) {
                                sb.append(logMessage.substring(idx, matcher.start()));
                                String expression = matcher.group(1);
                                try {
                                    DebugValue value = VariablesHandler.getDebugValue(event.getTopStackFrame(), expression);
                                    sb.append(value.toDisplayString());
                                }
                                catch (DebugException ex) {
                                    sb.append("Error: " + ex.getLocalizedMessage());
                                }
                                idx = matcher.end();
                            }
                            sb.append(logMessage.substring(idx));
                            this.context.getInfo().println(sb.toString());
                        }
                        return true;
                    });
                }
                info.runExecutables();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInSuspendedThread(int id, Function<SuspendedThreadInfo, Boolean> task) {
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            SuspendedThreadInfo info = this.suspendedThreads.get(id);
            if (info == null) {
                for (SuspendedThreadInfo sti : this.suspendedThreads.values()) {
                    if (!sti.id2Refs.containsKey(id)) continue;
                    info = sti;
                    break;
                }
            }
            if (info != null) {
                info.executables.add(task);
                return;
            }
        }
        task.apply(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadResumed(int threadId) {
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            this.suspendedThreads.remove(threadId);
            if (this.suspendedThreads.isEmpty()) {
                this.lastRefId = 0;
            }
        }
        DebugProtocolClient client = this.context.getClient();
        if (client != null) {
            client.continued(ContinuedEvent.EventBody.create(threadId).setAllThreadsContinued(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause(int threadId) {
        java.lang.Thread t;
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            t = this.id2threads.get(threadId);
        }
        if (t != null) {
            this.debuggerSession.suspend(t);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Map<java.lang.Thread, Integer> map = this.thread2Ids;
        synchronized (map) {
            for (SuspendedThreadInfo info : this.suspendedThreads.values()) {
                info.resume();
            }
        }
    }

    public final class SuspendedThreadInfo {
        private final int threadId;
        private final SuspendedEvent event;
        private final Map<Object, Integer> ref2Ids = new HashMap<Object, Integer>(100);
        private final Map<Integer, Object> id2Refs = new HashMap<Integer, Object>(100);
        private final BlockingQueue<Function<SuspendedThreadInfo, Boolean>> executables = new LinkedBlockingQueue<Function<SuspendedThreadInfo, Boolean>>();

        private SuspendedThreadInfo(int threadId, SuspendedEvent event) {
            this.threadId = threadId;
            this.event = event;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public SuspendedEvent getSuspendedEvent() {
            return this.event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getId(Object ref) {
            Integer id;
            Map<java.lang.Thread, Integer> map = ThreadsHandler.this.thread2Ids;
            synchronized (map) {
                id = this.ref2Ids.get(ref);
                if (id == null) {
                    id = ++ThreadsHandler.this.lastRefId;
                    this.ref2Ids.put(ref, id);
                    this.id2Refs.put(id, ref);
                }
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getById(Class<T> cls, int id) {
            Object ref;
            Map<java.lang.Thread, Integer> map = ThreadsHandler.this.thread2Ids;
            synchronized (map) {
                ref = this.id2Refs.get(id);
            }
            return cls.isInstance(ref) ? (T)cls.cast(ref) : null;
        }

        private void resume() {
            this.executables.add(info -> true);
        }

        private void runExecutables() {
            Function task;
            boolean resume = false;
            while (!resume) {
                try {
                    task = this.executables.take();
                    resume = task.apply((SuspendedThreadInfo)this);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            ThreadsHandler.this.threadResumed(this.threadId);
            while ((task = (Function)this.executables.poll()) != null) {
                task.apply(null);
            }
        }
    }
}

