/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.instrument;

import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.dap.instrument.Enabler;
import com.oracle.truffle.tools.dap.server.OutputHandler;
import java.io.OutputStream;

@TruffleInstrument.Registration(id="DAPOutputProviderInstrument", services={Enabler.class, OutputHandler.Provider.class}, internal=true)
public final class OutputConsumerInstrument
extends TruffleInstrument
implements Enabler,
OutputHandler.Provider {
    public static final String ID = "DAPOutputProviderInstrument";
    private TruffleInstrument.Env env;
    private OutputHandler oh;
    private EventBinding<OutputStream> bindingOut;
    private EventBinding<OutputStream> bindingErr;

    protected void onCreate(TruffleInstrument.Env e) {
        this.env = e;
        e.registerService((Object)this);
    }

    protected void onDispose(TruffleInstrument.Env e) {
        this.disable();
        super.onDispose(e);
    }

    @Override
    public void enable() {
        this.oh = new OutputHandler();
        this.bindingOut = this.env.getInstrumenter().attachOutConsumer(this.oh.getOut());
        this.bindingErr = this.env.getInstrumenter().attachErrConsumer(this.oh.getErr());
    }

    @Override
    public void disable() {
        this.bindingOut.dispose();
        this.bindingErr.dispose();
        this.oh = null;
    }

    @Override
    public OutputHandler getOutputHandler() {
        return this.oh;
    }
}

