/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.chromeinspector.LanguageChecks;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import java.io.PrintWriter;

public final class TypeInfo {
    final TYPE type;
    final SUBTYPE subtype;
    final String className;
    final String descriptionType;
    final boolean isObject;
    final boolean isFunction;
    final boolean isNull;
    final boolean isJS;

    TypeInfo(TYPE type, SUBTYPE subtype, String className, String descriptionType, boolean isObject, boolean isFunction, boolean isNull, boolean isJS) {
        this.type = type;
        this.subtype = subtype;
        this.className = className;
        this.descriptionType = descriptionType;
        this.isObject = isObject;
        this.isFunction = isFunction;
        this.isNull = isNull;
        this.isJS = isJS;
    }

    static TypeInfo fromValue(DebugValue debugValue, RemoteObject.TypeMark typeMark, LanguageInfo originalLanguage, PrintWriter err) {
        TYPE type;
        String metaType;
        String descriptionType;
        boolean isJS;
        String className;
        SUBTYPE subtype;
        boolean isObject;
        block21: {
            block20: {
                DebugValue metaObject = RemoteObject.getMetaObject(debugValue, originalLanguage, err);
                isObject = TypeInfo.isObject(debugValue, err);
                subtype = null;
                className = null;
                isJS = LanguageChecks.isJS(originalLanguage);
                descriptionType = null;
                metaType = null;
                if (metaObject != null) {
                    metaType = RemoteObject.toMetaName(metaObject, err);
                }
                type = TypeInfo.getType(debugValue, typeMark, metaType, isObject);
                if (typeMark == null) break block20;
                switch (typeMark) {
                    case MAP_ENTRIES: {
                        subtype = SUBTYPE.ARRAY;
                        break block21;
                    }
                    case MAP_ENTRY: {
                        subtype = SUBTYPE.INTERNAL_ENTRY;
                        break block21;
                    }
                    default: {
                        throw new UnsupportedOperationException(typeMark.name());
                    }
                }
            }
            if (debugValue.isArray()) {
                subtype = SUBTYPE.ARRAY;
            } else if (debugValue.hasHashEntries()) {
                subtype = SUBTYPE.MAP;
            } else if (debugValue.isIterator()) {
                subtype = SUBTYPE.ITERATOR;
            }
        }
        boolean isFunction = debugValue.canExecute();
        boolean isNull = false;
        if (isFunction) {
            type = TYPE.FUNCTION;
            className = metaType;
        } else if (isObject || TYPE.OBJECT.equals((Object)type)) {
            className = metaType;
            isNull = debugValue.isNull();
            if (isNull) {
                subtype = SUBTYPE.NULL;
                className = null;
            } else if (debugValue.isDate()) {
                subtype = SUBTYPE.DATE;
            }
        } else {
            className = null;
            if (TYPE.OBJECT.equals((Object)type)) {
                descriptionType = metaType;
            }
        }
        if (subtype != null) {
            type = TYPE.OBJECT;
        }
        if (descriptionType == null) {
            descriptionType = className;
        }
        return new TypeInfo(type, subtype, className, descriptionType, isObject, isFunction, isNull, isJS);
    }

    static boolean isObject(DebugValue debugValue, PrintWriter err) {
        boolean isObject;
        try {
            isObject = debugValue.getProperties() != null || debugValue.canExecute() || debugValue.isArray() || debugValue.hasHashEntries() || debugValue.isIterator();
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println("getProperties(" + debugValue.getName() + ") has caused: " + String.valueOf((Object)ex));
                ex.printStackTrace(err);
            }
            throw ex;
        }
        return isObject;
    }

    private static TYPE getType(DebugValue value, RemoteObject.TypeMark typeMark, String metaObject, boolean isObject) {
        if (typeMark != null) {
            switch (typeMark) {
                case MAP_ENTRIES: 
                case MAP_ENTRY: {
                    return TYPE.OBJECT;
                }
            }
            throw new UnsupportedOperationException(typeMark.name());
        }
        if (metaObject != null) {
            for (TYPE type : TYPE.values()) {
                if (TYPE.OBJECT.equals((Object)type) || !metaObject.equalsIgnoreCase(type.getId())) continue;
                return type;
            }
        }
        if (value.isString()) {
            return TYPE.STRING;
        }
        if (!isObject && value.isNumber()) {
            return TYPE.NUMBER;
        }
        if (!isObject && value.isBoolean()) {
            return TYPE.BOOLEAN;
        }
        return TYPE.OBJECT;
    }

    static Number toNumber(DebugValue value) {
        if (value.fitsInLong()) {
            return value.asLong();
        }
        if (value.fitsInDouble()) {
            return value.asDouble();
        }
        if (value.fitsInBigInteger()) {
            return value.asBigInteger();
        }
        throw new IllegalArgumentException("Not a number: " + value.toDisplayString(false));
    }

    public static enum TYPE {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol");

        private final String id;

        private TYPE(String id) {
            this.id = id;
        }

        String getId() {
            return this.id;
        }
    }

    public static enum SUBTYPE {
        ARRAY("array"),
        NULL("null"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        ITERATOR("iterator"),
        INTERNAL_ENTRY("internal#entry");

        private final String id;

        private SUBTYPE(String id) {
            this.id = id;
        }

        String getId() {
            return this.id;
        }
    }
}

