/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

import com.oracle.truffle.tools.chromeinspector.instrument.InspectorWSConnection;
import com.oracle.truffle.tools.chromeinspector.instrument.Token;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.graalvm.polyglot.io.MessageEndpoint;

public final class WSInterceptorServer
implements InspectorWSConnection,
MessageEndpoint {
    private final int port;
    private final Token token;
    private final ConnectionWatcher connectionWatcher;
    private InspectServerSession iss;
    private MessageEndpoint inspectEndpoint;

    public WSInterceptorServer(int port, Token token, InspectServerSession iss, ConnectionWatcher connectionWatcher) {
        this.port = port;
        this.token = token;
        this.connectionWatcher = connectionWatcher;
        this.iss = iss;
        iss.open(this);
    }

    public void resetSessionEndpoint() {
        this.iss.clearMessageEndpoint();
    }

    public void newSession(InspectServerSession newIss) {
        assert (this.iss.isClosed());
        this.iss = newIss;
        this.iss.open(this);
    }

    public void opened(MessageEndpoint endpoint) {
        this.inspectEndpoint = endpoint;
        this.iss.open(endpoint);
        this.connectionWatcher.notifyOpen();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void closing(Token tokenToClose) {
        this.iss.notifyClosing();
    }

    @Override
    public void close(Token tokenToClose) throws IOException {
        this.iss.dispose();
        if (this.inspectEndpoint != null && tokenToClose.equals(this.token)) {
            this.inspectEndpoint.sendClose();
        }
    }

    @Override
    public void dispose() {
        this.iss.dispose();
    }

    @Override
    public void consoleAPICall(Token tokenToCall, String type, Object text) {
        this.iss.consoleAPICall(type, text);
    }

    public void sendText(String message) throws IOException {
        this.connectionWatcher.waitForOpen();
        this.inspectEndpoint.sendText(message);
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendBinary(data);
    }

    public void sendPing(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendPing(data);
    }

    public void sendPong(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendPong(data);
    }

    public void sendClose() throws IOException {
        if (this.inspectEndpoint != null) {
            this.inspectEndpoint.sendClose();
        }
    }
}

