/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

final class SuspendableLocationFinder {
    private static final Set<Class<? extends Tag>> SUSPENDABLE_TAGS_SET = Collections.singleton(StandardTags.StatementTag.class);
    private static final Class<?>[] SUSPENDABLE_TAGS = SUSPENDABLE_TAGS_SET.toArray(new Class[SUSPENDABLE_TAGS_SET.size()]);

    private SuspendableLocationFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterable<SourceSection> findSuspendableLocations(SourceSection range, boolean restrictToSingleFunction, DebuggerSession session, TruffleInstrument.Env env) {
        int endIndex;
        int startIndex;
        Source source = range.getSource();
        SectionsCollector sectionsCollector = SuspendableLocationFinder.collectSuspendableLocations(source, startIndex = range.getCharIndex(), endIndex = range.getCharEndIndex(), restrictToSingleFunction, env);
        List<SourceSection> sections = sectionsCollector.getSections();
        if (sections.isEmpty()) {
            final AtomicReference nearestSection = new AtomicReference();
            Breakpoint breakpoint = Breakpoint.newBuilder((Source)source).ignoreCount(Integer.MAX_VALUE).lineIs(range.getStartLine()).columnIs(range.getStartColumn()).resolveListener(new Breakpoint.ResolveListener(){

                public void breakpointResolved(Breakpoint b, SourceSection section) {
                    nearestSection.set(section);
                }
            }).build();
            try {
                session.install(breakpoint);
            }
            finally {
                breakpoint.dispose();
            }
            SourceSection suspendableSection = (SourceSection)nearestSection.get();
            if (suspendableSection != null) {
                startIndex = suspendableSection.getCharIndex();
                endIndex = suspendableSection.getCharEndIndex();
                sectionsCollector = SuspendableLocationFinder.collectSuspendableLocations(source, startIndex, endIndex, restrictToSingleFunction, env);
                sections = sectionsCollector.getSections();
            }
        }
        return sections;
    }

    private static SectionsCollector collectSuspendableLocations(Source source, int startIndex, int endIndex, boolean restrictToSingleFunction, TruffleInstrument.Env env) {
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source}).indexIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)startIndex, (int)endIndex)}).tagIs((Class[])SUSPENDABLE_TAGS).build();
        SectionsCollector sectionsCollector = restrictToSingleFunction ? new FunctionSectionsCollector(startIndex, env.getInstrumenter()) : new SectionsCollector(startIndex);
        env.getInstrumenter().visitLoadedSourceSections(filter, (LoadSourceSectionListener)sectionsCollector);
        return sectionsCollector;
    }

    private static class SectionsCollector
    implements LoadSourceSectionListener {
        protected final int startIndex;
        private final List<SourceSection> sections = new ArrayList<SourceSection>();

        SectionsCollector(int startIndex) {
            this.startIndex = startIndex;
        }

        public void onLoad(LoadSourceSectionEvent event) {
            SourceSection section = event.getSourceSection();
            if (section.getCharIndex() >= this.startIndex) {
                this.sections.add(section);
            }
        }

        List<SourceSection> getSections() {
            return this.sections;
        }
    }

    private static final class FunctionSectionsCollector
    extends SectionsCollector {
        private final Instrumenter instrumenter;
        private Node rangeNode;
        private final Map<Node, List<SourceSection>> sectionsMap = new HashMap<Node, List<SourceSection>>();

        FunctionSectionsCollector(int startIndex, Instrumenter instrumenter) {
            super(startIndex);
            this.instrumenter = instrumenter;
        }

        @Override
        public void onLoad(LoadSourceSectionEvent event) {
            SourceSection section;
            Node node = event.getNode();
            Node root = this.findRoot(node);
            if (root != null && (section = event.getSourceSection()).getCharIndex() >= this.startIndex) {
                List<SourceSection> list = this.sectionsMap.get(root);
                if (list == null) {
                    list = new ArrayList<SourceSection>();
                    this.sectionsMap.put(root, list);
                }
                list.add(section);
                if (this.rangeNode == null || section.getCharIndex() - this.startIndex < this.rangeNode.getSourceSection().getCharIndex() - this.startIndex) {
                    this.rangeNode = node;
                }
            }
        }

        @Override
        List<SourceSection> getSections() {
            if (this.rangeNode == null) {
                return Collections.emptyList();
            }
            Node root = this.findRoot(this.rangeNode);
            return this.sectionsMap.get(root);
        }

        private Node findRoot(Node node) {
            if (this.instrumenter.queryTags(node).contains(StandardTags.RootTag.class)) {
                return node;
            }
            Node parent = node.getParent();
            if (parent == null) {
                return null;
            }
            return this.findRoot(parent);
        }
    }
}

