/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public final class WeakIdentityHashMap<K, V> {
    private final Map<ObjectReference, V> map = new HashMap<ObjectReference, V>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public V get(Object key) {
        assert (key != null);
        this.removeCollectedEntries();
        return this.map.get(new ObjectReference(key, null));
    }

    public V put(K key, V value) {
        assert (key != null);
        assert (value != null);
        this.removeCollectedEntries();
        return this.map.put(new ObjectReference(key, this.queue), value);
    }

    private void removeCollectedEntries() {
        ObjectReference r;
        while ((r = (ObjectReference)this.queue.poll()) != null) {
            this.map.remove(r);
        }
    }

    private static final class ObjectReference
    extends WeakReference<Object> {
        private final int hash;

        ObjectReference(Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hash = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ObjectReference) {
                ObjectReference other = (ObjectReference)obj;
                if (this.hash != other.hash) {
                    return false;
                }
                return this.get() == other.get();
            }
            return false;
        }
    }
}

