/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graalvm.tools.insight.Insight;
import org.graalvm.tools.insight.heap.HeapDump;
import org.graalvm.tools.insight.heap.instrument.CacheReplacement;
import org.graalvm.tools.insight.heap.instrument.HeapException;
import org.graalvm.tools.insight.heap.instrument.HeapGenerator;
import org.graalvm.tools.insight.heap.instrument.MemoryDump;

@ExportLibrary(value=InteropLibrary.class)
final class HeapObject
implements TruffleObject,
Insight.SymbolProvider,
Consumer<OutputStream> {
    private final TruffleInstrument.Env env;
    private final String path;
    private OutputStream sink;
    private HeapDump.Builder generator;
    private final MemoryDump memoryDump;
    private final boolean exposeCache;
    private static final String CACHE_CLEAR = "cacheClear";
    private static final String CACHE = "cache";
    private static final String DUMP = "dump";
    private static final String FLUSH = "flush";

    HeapObject(TruffleInstrument.Env env, String path, int cacheSize, CacheReplacement cacheReplacement, boolean exposeCache) {
        this.env = env;
        this.path = path;
        this.memoryDump = cacheSize != 0 ? new MemoryDump(cacheSize, cacheReplacement, new Supplier<HeapDump.Builder>(){

            @Override
            public HeapDump.Builder get() {
                try {
                    return HeapObject.this.getGenerator();
                }
                catch (IOException ex) {
                    throw new HeapException(ex);
                }
            }
        }) : null;
        this.exposeCache = exposeCache;
    }

    public synchronized Map<String, ? extends Object> symbolsWithValues() throws Exception {
        if (this.path == null && this.getSink() == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("heap", this);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object invokeMember(String name, Object[] args) throws UnknownIdentifierException, UnsupportedTypeException, ArityException, UnsupportedMessageException {
        switch (name) {
            case "dump": {
                this.dump(args);
                return this;
            }
            case "flush": {
                this.checkArity(0, args);
                this.flush();
                return this;
            }
            case "cacheClear": {
                if (!this.exposeCache) break;
                this.checkArity(0, args);
                if (this.memoryDump != null) {
                    this.memoryDump.clear();
                }
                return this;
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    private void checkArity(int arity, Object[] args) throws ArityException {
        if (args.length != arity) {
            throw ArityException.create((int)arity, (int)arity, (int)args.length);
        }
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        switch (member) {
            case "dump": 
            case "flush": {
                return true;
            }
            case "cacheClear": {
                return this.exposeCache;
            }
        }
        return false;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        switch (member) {
            case "cache": {
                return this.exposeCache;
            }
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object readMember(String name) throws UnknownIdentifierException {
        switch (name) {
            case "cache": {
                if (!this.exposeCache) break;
                if (this.memoryDump != null) {
                    return this.memoryDump;
                }
                return NullObject.INSTANCE;
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    synchronized void close() {
        try {
            HeapDump.Builder g = this.getGeneratorOrNull();
            if (g != null) {
                g.close();
            }
            this.setGenerator(null);
            this.setSink(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public synchronized void accept(OutputStream t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.path != null) {
            throw new IllegalStateException("Cannot use path (" + this.path + ") and stream (" + String.valueOf(t) + ") at once");
        }
        this.close();
        this.setSink(t);
    }

    void flush() throws UnsupportedTypeException, UnsupportedMessageException {
        if (this.memoryDump != null) {
            this.memoryDump.flush();
        }
    }

    private void dump(Object[] args) throws UnsupportedTypeException, UnsupportedMessageException {
        if (args != null) {
            if (this.memoryDump != null) {
                this.memoryDump.addDump(args);
            } else {
                this.generateDump(args);
            }
        }
    }

    private void generateDump(Object[] args) throws UnsupportedTypeException, UnsupportedMessageException {
        try {
            HeapGenerator heap = new HeapGenerator(this.getGenerator());
            heap.dump(args);
        }
        catch (IOException ex) {
            throw new HeapException(ex);
        }
    }

    synchronized HeapDump.Builder getGenerator() throws IOException {
        HeapDump.Builder g = this.getGeneratorOrNull();
        if (g == null) {
            if (this.getSink() == null) {
                TruffleFile file = this.env.getTruffleFile(null, this.path);
                OutputStream rawStream = file.newOutputStream(new OpenOption[0]);
                this.setSink(new BufferedOutputStream(rawStream));
            }
            g = HeapDump.newHeapBuilder(this.getSink());
            this.setGenerator(g);
        }
        return g;
    }

    private HeapDump.Builder getGeneratorOrNull() throws IOException {
        assert (Thread.holdsLock(this));
        return this.generator;
    }

    private void setGenerator(HeapDump.Builder generator) {
        assert (Thread.holdsLock(this));
        this.generator = generator;
    }

    private void setSink(OutputStream sink) {
        assert (Thread.holdsLock(this));
        this.sink = sink;
    }

    private OutputStream getSink() {
        assert (Thread.holdsLock(this));
        return this.sink;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class NullObject
    implements TruffleObject {
        static final NullObject INSTANCE = new NullObject();

        NullObject() {
        }

        @ExportMessage
        boolean isNull() {
            return true;
        }
    }
}

