/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graalvm.launcher.Launcher;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.shadowed.org.jline.keymap.KeyMap;
import org.graalvm.shadowed.org.jline.reader.Binding;
import org.graalvm.shadowed.org.jline.reader.EndOfFileException;
import org.graalvm.shadowed.org.jline.reader.History;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.LineReaderBuilder;
import org.graalvm.shadowed.org.jline.reader.Reference;
import org.graalvm.shadowed.org.jline.reader.UserInterruptException;
import org.graalvm.shadowed.org.jline.reader.impl.history.DefaultHistory;
import org.graalvm.shadowed.org.jline.terminal.Terminal;

class MultiLanguageShell
implements Closeable {
    private static final String WIDGET_NAME = "CHANGE_LANGUAGE_WIDGET";
    private final Map<Language, History> histories = new HashMap<Language, History>();
    private final Context context;
    private final String startLanguage;
    private final List<Language> languages;
    private final Map<String, Language> prompts;
    private final StringBuilder promptsString = new StringBuilder();
    private final Terminal terminal;
    private LineReader reader;
    private Language currentLanguage;
    private boolean verboseErrors = false;
    private String input = "";

    MultiLanguageShell(Context context, String defaultStartLanguage, Terminal terminal) {
        this.context = context;
        this.languages = this.languages();
        this.prompts = this.prompts();
        this.terminal = terminal;
        this.startLanguage = defaultStartLanguage == null ? this.languages.get(0).getId() : defaultStartLanguage;
        this.currentLanguage = (Language)context.getEngine().getLanguages().get(this.startLanguage);
        if (this.currentLanguage == null) {
            throw new Launcher.AbortException("Error: could not find language '" + this.startLanguage + "'", 1);
        }
        this.resetLineReader();
    }

    private static String createBufferPrompt(String prompt) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < prompt.length() - 2; ++i) {
            b.append(" ");
        }
        return b.append("+ ").toString();
    }

    private static String createPrompt(Language currentLanguage) {
        return String.format("%s> ", currentLanguage.getId());
    }

    public int runRepl() {
        this.printHeader();
        while (true) {
            try {
                while (true) {
                    this.input = this.input + this.reader.readLine(this.prompt()) + "\n";
                    if (!this.handleBuiltins() && !this.eval()) continue;
                    this.reader.getHistory().add(this.input);
                    this.input = "";
                }
            }
            catch (ChangeLanguageException e) {
                this.handle(e);
                continue;
            }
            catch (PolyglotException e) {
                this.handle(e);
                if (!e.isExit()) continue;
                return e.getExitStatus();
            }
            catch (EndOfFileException | UserInterruptException e) {
            }
            catch (Throwable e) {
                this.handleInternal(e);
                continue;
            }
            break;
        }
        return 0;
    }

    private String prompt() {
        String prompt = MultiLanguageShell.createPrompt(this.currentLanguage);
        return this.input.equals("") ? prompt : MultiLanguageShell.createBufferPrompt(prompt);
    }

    private boolean eval() throws IOException {
        Source source = Source.newBuilder((String)this.currentLanguage.getId(), (CharSequence)this.input, (String)"<shell>").interactive(true).build();
        this.context.eval(source);
        return true;
    }

    private void handle(ChangeLanguageException e) {
        this.histories.put(this.currentLanguage, this.reader.getHistory());
        this.currentLanguage = e.getLanguage() == null ? this.languages.get((this.languages.indexOf(this.currentLanguage) + 1) % this.languages.size()) : e.getLanguage();
        this.resetLineReader();
        this.input = "";
    }

    private void handleInternal(Throwable e) {
        this.println("Internal error occurred: " + e.toString());
        if (this.verboseErrors) {
            e.printStackTrace(this.terminal.writer());
        } else {
            this.println("Run with --verbose to see the full stack trace.");
        }
    }

    private void handle(PolyglotException e) {
        if (e.isIncompleteSource()) {
            return;
        }
        this.input = "";
        if (e.isInternalError()) {
            this.handleInternal(e);
        } else if (e.isCancelled()) {
            this.println("Execution got cancelled.");
        } else if (e.isSyntaxError()) {
            this.println(e.getMessage());
        } else {
            ArrayList<PolyglotException.StackFrame> trace = new ArrayList<PolyglotException.StackFrame>();
            for (PolyglotException.StackFrame stackFrame : e.getPolyglotStackTrace()) {
                trace.add(stackFrame);
            }
            for (int i = trace.size() - 1; i >= 0 && ((PolyglotException.StackFrame)trace.get(i)).isHostFrame(); --i) {
                trace.remove(i);
            }
            if (e.isHostException()) {
                this.println(e.asHostException().toString());
            } else {
                this.println(String.valueOf(e.getMessage()));
            }
            if (trace.size() > 1) {
                for (PolyglotException.StackFrame stackFrame : trace) {
                    this.print("        at ");
                    this.println(stackFrame.toString());
                }
            }
        }
    }

    private boolean handleBuiltins() {
        String trimmedInput = this.input.trim();
        if (trimmedInput.equals("")) {
            return true;
        }
        if (trimmedInput.equals("-usage")) {
            this.printUsage(true);
            return true;
        }
        if (trimmedInput.equals("-verboseErrors")) {
            boolean bl = this.verboseErrors = !this.verboseErrors;
            if (this.verboseErrors) {
                this.println("Verbose errors is now on.");
            } else {
                this.println("Verbose errors is now off.");
            }
            return true;
        }
        if (this.prompts.containsKey(trimmedInput)) {
            throw new ChangeLanguageException(this.prompts.get(trimmedInput));
        }
        return false;
    }

    private void printHeader() {
        this.println("GraalVM MultiLanguage Shell " + this.context.getEngine().getVersion());
        this.println("Copyright (c) 2013-2021, Oracle and/or its affiliates");
        for (Language language : this.languages) {
            this.println("  " + language.getName() + " version " + language.getVersion());
        }
        this.printUsage(false);
    }

    private void println(String s) {
        this.terminal.writer().println(s);
    }

    private void print(String s) {
        this.terminal.writer().print(s);
    }

    private void resetLineReader() {
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).appName("GraalVM MultiLanguage Shell " + this.context.getEngine().getVersion()).history(this.histories.computeIfAbsent(this.currentLanguage, language -> new DefaultHistory())).build();
        for (String s : this.reader.getKeyMaps().keySet()) {
            this.reader.getKeyMaps().get(s).bind((Binding)new Reference(WIDGET_NAME), (CharSequence)KeyMap.ctrl('n'));
            this.reader.getWidgets().put(WIDGET_NAME, () -> {
                throw new ChangeLanguageException(null);
            });
        }
    }

    private Map<String, Language> prompts() {
        HashMap<String, Language> p = new HashMap<String, Language>();
        for (Language language : this.languages) {
            String prompt = MultiLanguageShell.createPrompt(language).trim();
            this.promptsString.append(prompt).append(" ");
            p.put(prompt, language);
        }
        return p;
    }

    private List<Language> languages() {
        ArrayList<Language> langs = new ArrayList<Language>();
        HashSet<Language> uniqueValues = new HashSet<Language>();
        for (Language language : this.context.getEngine().getLanguages().values()) {
            if (!language.isInteractive() || !uniqueValues.add(language)) continue;
            langs.add(language);
        }
        if (langs.isEmpty()) {
            throw new Launcher.AbortException("Error: No Graal languages installed. Exiting shell.", 1);
        }
        langs.sort(Comparator.comparing(Language::getName));
        return langs;
    }

    private void printUsage(boolean showCommands) {
        if (showCommands) {
            this.println("Commands:");
            this.println("  -usage           to show this list.");
            this.println("  -verboseErrors   to toggle verbose error messages (default off).");
            this.println("  " + String.valueOf(this.promptsString) + "    to switch to a language.");
        } else {
            this.println("Usage: ");
            this.println("  Use Ctrl+n to switch language and Ctrl+d to exit.");
            this.println("  Enter -usage to get a list of available commands.");
        }
    }

    @Override
    public void close() throws IOException {
        this.terminal.close();
    }

    private static class ChangeLanguageException
    extends RuntimeException {
        private final Language language;

        ChangeLanguageException(Language language) {
            this.language = language;
        }

        public Language getLanguage() {
            return this.language;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

