/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.uln;

import com.oracle.graalvm.component.installer.uln.ULNChannel;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.persist.AbstractCatalogStorage;

public class ULNStorageImpl
extends AbstractCatalogStorage {
    private final ULNChannel channel;
    private final Set<String> componentIds;
    private final Map<String, Set<ComponentInfo>> componentInfos = new HashMap<String, Set<ComponentInfo>>();

    public ULNStorageImpl(ULNChannel channel, Set<String> ids, ComponentRegistry localRegistry, Feedback feedback, URL baseURL) {
        super(localRegistry, feedback, baseURL);
        this.channel = channel;
        this.componentIds = ids;
    }

    public Set<String> listComponentIDs() throws IOException {
        return Collections.unmodifiableSet(this.componentIds);
    }

    public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
        return ci;
    }

    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        Set<ComponentInfo> infos = this.componentInfos.get(id);
        if (infos == null) {
            infos = this.channel.getComponentDetails(id);
            this.componentInfos.put(id, infos);
        }
        return infos;
    }

    public Map<String, String> loadGraalVersionInfo() {
        return this.localRegistry.getGraalCapabilities();
    }
}

