/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.uln;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RpcUtils {
    public static Node findPath(Document doc, String pathSpec) {
        return RpcUtils.findPath(doc.getDocumentElement(), pathSpec);
    }

    public static Node findPath(Node root, String path) {
        return RpcUtils.findPath(root, 0, Arrays.asList(path.split("/")));
    }

    public static Node findPath(Node root, Node startFrom, int pos, List<String> path) {
        Node[] nodeArray;
        if (startFrom == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = startFrom;
        }
        return RpcUtils.doFindPath(root, nodeArray, pos, path);
    }

    static Node findPath(Node root, int pos, List<String> path) {
        return RpcUtils.doFindPath(root, null, pos, path);
    }

    public static Node findPath(Node root, Node startFrom, String path) {
        return RpcUtils.findPath(root, startFrom, 0, Arrays.asList(path.split("/")));
    }

    private static Node doFindPath(Node root, Node[] startFrom, int pos, List<String> path) {
        Node current = root;
        for (int index = pos; index < path.size(); ++index) {
            Object p = path.get(index);
            if (!"..".equals(p)) {
                int bracket;
                String content = null;
                int counter = 1;
                String attName = null;
                String attValue = null;
                int attQuery = ((String)p).indexOf("[@");
                if (attQuery > 0) {
                    int eq = ((String)p).indexOf("=\"");
                    if (eq > 0) {
                        attName = ((String)p).substring(attQuery + 2, eq);
                        int quot = ((String)p).indexOf(34, eq + 2);
                        if (quot == -1) {
                            throw new IllegalArgumentException();
                        }
                        attValue = ((String)p).substring(eq + 2, quot);
                        if (((String)p).length() <= quot + 1 || ((String)p).charAt(quot + 1) != ']') {
                            throw new IllegalArgumentException();
                        }
                        p = ((String)p).substring(0, attQuery) + ((String)p).substring(quot + 2);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if ((bracket = ((String)p).indexOf(91)) > 0) {
                    int end = ((String)p).lastIndexOf(93);
                    if (end == -1) {
                        throw new IllegalArgumentException();
                    }
                    content = ((String)p).substring(bracket + 1, end);
                    p = ((String)p).substring(0, bracket);
                    if (!content.isEmpty() && Character.isDigit(content.charAt(0))) {
                        counter = Integer.parseUnsignedInt(content);
                        content = null;
                    }
                }
                Node next = current.getFirstChild();
                if (startFrom != null && startFrom[0] != null && startFrom[0].getParentNode() == current) {
                    next = startFrom[0];
                }
                while (next != null) {
                    Node a;
                    Node n = next;
                    next = n.getNextSibling();
                    if (n.getNodeType() != 1 || !n.getNodeName().equals(p) || attName != null && ((a = n.getAttributes().getNamedItem(attName)) == null || !attValue.equals(a.getTextContent()))) continue;
                    if (startFrom == null || startFrom[0] == null) {
                        if (--counter > 0 || content != null && !content.equalsIgnoreCase(n.getTextContent())) {
                            continue;
                        }
                    } else {
                        if (startFrom[0] != n) continue;
                        startFrom[0] = null;
                        continue;
                    }
                    Node result = RpcUtils.doFindPath(n, startFrom, index + 1, path);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
            current = current.getParentNode();
        }
        return current;
    }

    public static String formatMessage(Class<?> c, String messageResource, Map<String, ?> replaces) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStream is = c.getResourceAsStream(messageResource);
             BufferedReader r = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = r.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        String msg = sb.toString();
        for (String k : replaces.keySet()) {
            msg = RpcUtils.replaceToken(msg, k, replaces::get);
        }
        return msg.trim();
    }

    static String replaceToken(String msg, String k, Function<String, ?> provider) {
        String token = "${" + k + "}";
        if (msg.indexOf(token) < -1) {
            return msg;
        }
        Object v = provider.apply(k);
        if (v instanceof Function) {
            return msg.replace(token, (CharSequence)((Function)v).apply(k));
        }
        if (v instanceof Supplier) {
            return msg.replace(token, (CharSequence)((Supplier)v).get());
        }
        if (v == null) {
            return msg.replace(token, "");
        }
        return msg.replace(token, v.toString());
    }
}

