/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.uln;

import com.oracle.graalvm.component.installer.uln.RpcAgent;
import com.oracle.graalvm.component.installer.uln.ULNChannel;
import com.oracle.graalvm.component.installer.uln.UnauthorizedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class Authenticator {
    static final String CACHE_DIRECTORY_PATH = "lib/installer/cache";
    static final String CACHE_TOKEN_NAME = "uln-auth-cache";
    private static final int TOKEN_EXPIRY_SECONDS = 14400;
    private static final String PASSWORD_TOKEN = "${password}";
    private final CommandInput input;
    private final Feedback feedback;
    private final String ulnChannel;
    private final Path tokenPath;
    private RpcAgent agent;
    private boolean nonInteractive;
    private String authToken;
    private String interactiveUserName;
    private char[] interactivePassword;
    private boolean cacheToken = true;
    private static final String TOKEN_POSIX_PERMISSIONS = "rw-------";

    Authenticator(CommandInput input, Feedback feedback, String ulnChannel) {
        this.input = input;
        this.feedback = feedback.withBundle(Authenticator.class);
        this.ulnChannel = ulnChannel;
        this.tokenPath = SystemUtils.fromCommonRelative((Path)input.getGraalHomePath().resolve("bin"), (String)CACHE_DIRECTORY_PATH).resolve(Paths.get(CACHE_TOKEN_NAME, new String[0]));
    }

    public String getAccessToken() {
        if (this.authToken == null) {
            throw new IllegalStateException();
        }
        return this.authToken;
    }

    public boolean isNonInteractive() {
        return this.nonInteractive;
    }

    public Authenticator setAgent(RpcAgent agent) {
        this.agent = agent;
        return this;
    }

    public boolean isCacheToken() {
        return this.cacheToken;
    }

    public Authenticator setCacheToken(boolean cacheToken) {
        this.cacheToken = cacheToken;
        return this;
    }

    public Authenticator setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
        return this;
    }

    void discardAuthToken() {
        this.authToken = null;
        if (!this.isCacheToken()) {
            return;
        }
        try {
            Files.deleteIfExists(this.tokenPath);
        }
        catch (IOException ex) {
            this.feedback.error("ULN_CountNotDeleteAccessToken", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
        }
    }

    void setFilePermissions(Path file) throws IOException {
        PosixFileAttributeView posixView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
        AclFileAttributeView aclView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
        if (posixView != null) {
            posixView.setPermissions(PosixFilePermissions.fromString(TOKEN_POSIX_PERMISSIONS));
        }
        if (aclView != null) {
            UserPrincipalLookupService srv = file.getFileSystem().getUserPrincipalLookupService();
            UserPrincipal user = srv.lookupPrincipalByName(System.getProperty("user.name"));
            AclEntry.Builder bld = AclEntry.newBuilder().setPrincipal(user).setType(AclEntryType.ALLOW).setPermissions(EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.DELETE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.APPEND_DATA, AclEntryPermission.SYNCHRONIZE}));
            AclEntry en = bld.build();
            aclView.setAcl(Collections.singletonList(en));
        }
    }

    void cacheAccessToken(String token, boolean store) {
        block10: {
            this.authToken = token;
            if (this.agent != null) {
                this.agent.setAuthToken(token);
            }
            if (!this.isCacheToken()) {
                return;
            }
            Path toDelete = null;
            try {
                if (store) {
                    Path parentPath = this.tokenPath.getParent();
                    assert (parentPath != null);
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                    toDelete = Files.write(this.tokenPath, Collections.singletonList(token), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);
                    this.setFilePermissions(toDelete);
                } else {
                    if (!Files.isReadable(this.tokenPath)) {
                        return;
                    }
                    Files.setLastModifiedTime(this.tokenPath, FileTime.from(Instant.now()));
                }
            }
            catch (IOException ex) {
                this.feedback.error("ULN_CannotCacheAccessToken", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
                if (toDelete == null) break block10;
                try {
                    Files.deleteIfExists(this.tokenPath);
                }
                catch (IOException ex2) {
                    this.feedback.error("ULN_CountNotDeleteAccessToken", (Throwable)ex2, new Object[]{ex2.getLocalizedMessage()});
                }
            }
        }
    }

    boolean attemptCachedLogin() {
        String token = this.readAccessToken();
        if (token == null) {
            return false;
        }
        HashMap<String, String> replaces = new HashMap<String, String>();
        replaces.put("auth", token);
        replaces.put("channel", this.ulnChannel);
        try {
            this.agent.makeRequest(this.feedback.l10n("ULN_VerifyAuthToken", new Object[0]), "channelContents.xml", replaces, d -> null);
            this.cacheAccessToken(token, false);
            return true;
        }
        catch (UnauthorizedException ex) {
            this.feedback.output("ULN_AccesstTokenExpired", new Object[0]);
            this.discardAuthToken();
        }
        catch (IOException ex) {
            this.feedback.error("ULN_CannotVerifyAccessToken", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
        }
        return false;
    }

    String readAccessToken() {
        List<String> tokenLines;
        Path resolvedDir = this.tokenPath.getParent();
        if (resolvedDir == null || !Files.exists(resolvedDir, new LinkOption[0]) || !Files.isDirectory(resolvedDir, new LinkOption[0])) {
            return null;
        }
        if (!Files.isReadable(this.tokenPath)) {
            return null;
        }
        try {
            FileTime time = Files.getLastModifiedTime(this.tokenPath, new LinkOption[0]);
            if (time.toInstant().plusSeconds(14400L).compareTo(Instant.now()) < 0) {
                this.feedback.output("ULN_AccesstTokenExpired", new Object[0]);
                this.discardAuthToken();
                return null;
            }
            tokenLines = Files.readAllLines(this.tokenPath);
            if (tokenLines.isEmpty()) {
                this.discardAuthToken();
                return null;
            }
        }
        catch (IOException ex) {
            this.feedback.error("ULN_CannotReadAccessToken", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
            return null;
        }
        String t = tokenLines.get(0).trim();
        if (t.isEmpty()) {
            this.discardAuthToken();
            return null;
        }
        return t;
    }

    public void login() throws IOException {
        if (this.attemptCachedLogin()) {
            return;
        }
        String userName = this.getUserName(true);
        if (userName == null) {
            return;
        }
        this.login(userName, this.getPassword());
        this.cacheAccessToken(this.authToken, true);
    }

    String readPasswordFile(String pathSpec) {
        String secret;
        Path p = Paths.get(pathSpec, new String[0]);
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);
             InputStreamReader rdr = new InputStreamReader(is, "UTF-8");
             BufferedReader br = new BufferedReader(rdr);){
            secret = br.readLine();
        }
        catch (IOException ex) {
            throw this.feedback.failure("ULN_FailedToReadPassword", (Throwable)ex, new Object[]{pathSpec, ex.getLocalizedMessage()});
        }
        boolean repeated = false;
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);
             InputStreamReader rdr = new InputStreamReader(is, "UTF-8");
             BufferedReader br = new BufferedReader(rdr);){
            if (br.ready()) {
                String secret2 = br.readLine();
                repeated = Objects.equals(secret2, secret);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (secret != null) {
            if (secret.isEmpty()) {
                return null;
            }
            secret = secret.trim();
        }
        if (!repeated) {
            this.interactivePassword = secret.toCharArray();
        }
        return secret;
    }

    String getUserName() {
        return this.getUserName(false);
    }

    String getUserName(boolean onlyCached) {
        if (this.interactiveUserName != null) {
            return this.interactiveUserName;
        }
        String userName = this.input.optValue("U");
        if (userName != null) {
            return userName;
        }
        userName = System.getProperty("uln.username");
        if (userName == null) {
            userName = System.getenv("ULN_USERNAME");
        }
        if (userName == null) {
            if (onlyCached) {
                return null;
            }
            if (this.isNonInteractive()) {
                throw this.feedback.failure("ULN_MustProvideUsername", null, new Object[0]);
            }
        }
        this.feedback.outputPart("ULN_EnterUserName", new Object[0]);
        userName = this.feedback.acceptLine(false);
        if (userName != null) {
            userName = userName.trim();
        }
        if (userName == null || userName.isEmpty()) {
            throw this.feedback.failure("ULN_MustProvideUsername", null, new Object[0]);
        }
        this.interactiveUserName = userName;
        return userName;
    }

    char[] getPassword() {
        if (this.interactivePassword != null) {
            return this.interactivePassword;
        }
        String passwd = null;
        if (ULNChannel.ULN_OPTIONS.containsKey("P")) {
            String passwordFile = this.input.optValue("P");
            if (passwordFile != null) {
                passwd = this.readPasswordFile(passwordFile);
            }
            if (passwd == null) {
                passwd = System.getProperty("uln.password");
            }
            if (passwd == null) {
                passwd = System.getenv("ULN_PASSWORD");
            }
        }
        if (passwd != null) {
            passwd = passwd.trim();
        }
        if (passwd == null) {
            if (this.isNonInteractive()) {
                throw this.feedback.failure("ULN_MustProvidePassword", null, new Object[0]);
            }
        } else {
            return passwd.toCharArray();
        }
        this.feedback.outputPart("ULN_EnterPassword", new Object[0]);
        this.interactivePassword = this.feedback.acceptPassword();
        if (this.interactivePassword == null || this.interactivePassword.length == 0) {
            throw this.feedback.failure("ULN_MustProvidePassword", null, new Object[0]);
        }
        return this.interactivePassword;
    }

    String extractAuthToken(Document doc) {
        Node tokenNode = this.agent.findPath(doc.getDocumentElement(), "params/param/value/string", true);
        this.authToken = tokenNode.getTextContent();
        return this.authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String userName, char[] password) throws IOException {
        if (this.agent == null) {
            throw new IllegalStateException();
        }
        char[] out = null;
        try {
            HashMap<String, String> replaces = new HashMap<String, String>();
            replaces.put("username", userName);
            String replaced = this.agent.formatMessage("authentication.xml", replaces);
            int idx = replaced.indexOf(PASSWORD_TOKEN);
            int l = PASSWORD_TOKEN.length();
            if (idx < 0) {
                throw new IllegalStateException();
            }
            char[] in = replaced.toCharArray();
            out = new char[replaced.length() - l + password.length];
            System.arraycopy(in, 0, out, 0, idx);
            System.arraycopy(password, 0, out, idx, password.length);
            System.arraycopy(in, idx + l, out, idx + password.length, in.length - idx - l);
            Arrays.fill(password, ' ');
            this.cacheAccessToken(this.agent.makeRequest(this.feedback.l10n("ULN_RequestLogin", new Object[0]), out, this::extractAuthToken), true);
        }
        catch (Throwable throwable) {
            Arrays.fill(password, ' ');
            if (out != null) {
                Arrays.fill(out, ' ');
            }
            throw throwable;
        }
        Arrays.fill(password, ' ');
        if (out != null) {
            Arrays.fill(out, ' ');
        }
    }
}

