/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.profiles;

import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.h;
import com.oracle.svm.enterprise.profiling.data.i;
import com.oracle.svm.enterprise.profiling.f;
import com.oracle.svm.enterprise.profiling.k;
import com.oracle.svm.enterprise.profiling.kinds.c;
import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingLoader;
import com.oracle.svm.enterprise.profiling.metadata.a;
import com.oracle.svm.enterprise.profiling.metadata.b;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graalvm.collections.Pair;

public abstract class ProfilingBaseProfile {
    protected h profilingData;
    protected a profilingMetadata;

    protected ProfilingBaseProfile() {
    }

    protected ProfilingBaseProfile(a a2, h h2) {
        this.profilingMetadata = a2;
        this.profilingData = h2;
    }

    public ProfilingBaseProfile normalize(long l2) {
        List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodesWithStringContext();
        long l3 = this.findSums(list.get(d.Nd.iB()));
        double d2 = (double)l2 / (double)l3;
        for (Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            map.forEach((string, c2) -> c2.a(this.profilingData, d2));
        }
        return this;
    }

    public ProfilingBaseProfile merge(ProfilingBaseProfile profilingBaseProfile) {
        i i2 = new i();
        b b2 = new b();
        this.merge0(b2, i2);
        profilingBaseProfile.merge0(b2, i2);
        return this.newInstance(b2.iJ(), i2);
    }

    public void dump(OutputStream outputStream) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
            outputStreamWriter.append("{\"version\":\"").append("0.4.0").append("\"");
            outputStreamWriter.append(",\"types\":[");
            this.profilingMetadata.iF().a(outputStreamWriter);
            outputStreamWriter.append("],\"methods\":[");
            this.profilingMetadata.iG().a(outputStreamWriter);
            List<List<com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findLeafNodes();
            for (d d2 : d.values()) {
                outputStreamWriter.append("],\"").append(d2.getName()).append("\":[");
                if (d2.iB() == d.Nf.iB() && list.get(d2.iB()).isEmpty()) {
                    ProfilingBaseProfile.dumpSamples(k.ik(), outputStreamWriter);
                    continue;
                }
                this.dump(list.get(d2.iB()), outputStreamWriter);
            }
            outputStreamWriter.append("]}");
            outputStreamWriter.flush();
        }
    }

    protected <T, M> a buildMetadata(ProfilingLoader<T, M> profilingLoader, e e2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2) {
        b b3 = new b();
        b3.a(profilingLoader.getGlobalTypes());
        b3.b(profilingLoader.getGlobalMethods());
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.iw().in().entrySet()) {
            profilingLoader.loadNodes(b3, this.profilingData, entry.getValue(), entry.getKey(), b2);
        }
        return b3.iJ();
    }

    protected static <T, M> void assimilate(ProfilingLoader<T, M> profilingLoader, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, e e2) {
        com.oracle.svm.enterprise.profiling.collect.c c3 = e2.iv();
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map = c3.ir().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::jb, d2 -> d2));
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map2 = c3.fZ().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::jb, c2 -> c2));
        Map<Integer, T> map3 = profilingLoader.loadTypes(map);
        Map<Integer, M> map4 = profilingLoader.loadMethods(map, map2);
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.iw().in().entrySet()) {
            List<com.oracle.svm.enterprise.profiling.collect.d> list = ProfilingBaseProfile.assimilate0(entry.getValue(), b2, map3, map4, entry.getKey());
            entry.setValue(list);
        }
    }

    protected abstract ProfilingBaseProfile newInstance(a var1, i var2);

    private void dump(List<com.oracle.svm.enterprise.profiling.metadata.cctree.c> list, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "";
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : list) {
            long[] lArray;
            String string2 = ProfilingBaseProfile.makeContext(c2);
            c c3 = c2.iM();
            if (c3.i(lArray = c2.a(this.profilingData)) <= 0L) continue;
            outputStreamWriter.append(string);
            outputStreamWriter.append("{\"ctx\":\"").append(string2).append("\",");
            ProfilingBaseProfile.dump(outputStreamWriter, lArray);
            outputStreamWriter.append("}");
            string = ",";
        }
        outputStreamWriter.flush();
    }

    private static String makeContext(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
        StringBuilder stringBuilder = new StringBuilder();
        com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = c2;
        do {
            com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?> a2 = d2.iO();
            stringBuilder.insert(0, a2.iU()).insert(0, ":").insert(0, a2.iV());
            if (d2.iQ() == null) continue;
            stringBuilder.insert(0, "<");
        } while ((d2 = d2.iQ()) != null);
        return stringBuilder.toString();
    }

    private static void dumpSamples(Map<String, long[]> map, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "";
        c c2 = d.Nf.iC();
        for (Map.Entry<String, long[]> entry : map.entrySet()) {
            String string2 = entry.getKey();
            long[] lArray = entry.getValue();
            if (c2.i(lArray) <= 0L) continue;
            outputStreamWriter.append(string);
            outputStreamWriter.append("{\"ctx\":\"").append(string2).append("\",");
            ProfilingBaseProfile.dump(outputStreamWriter, lArray);
            outputStreamWriter.append("}");
            string = ",";
        }
        outputStreamWriter.flush();
    }

    private static void dump(OutputStreamWriter outputStreamWriter, long[] lArray) throws IOException {
        outputStreamWriter.append("\"records\":[");
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            outputStreamWriter.append(Long.toString(lArray[i2]));
            if (i2 >= lArray.length - 1) continue;
            outputStreamWriter.append(",");
        }
        outputStreamWriter.append("]");
        outputStreamWriter.flush();
    }

    private long findSums(Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map) {
        long l2 = 0L;
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : map.values()) {
            l2 += c2.b(this.profilingData);
        }
        return l2;
    }

    private void merge0(b b2, h h2) {
        this.mergeTypes(b2);
        this.mergeNodes(b2, h2);
    }

    private void mergeTypes(b b2) {
        b2.a(this.profilingMetadata.iF());
        b2.b(this.profilingMetadata.iG());
    }

    private void mergeNodes(b b2, h h2) {
        List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodes();
        for (Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            for (Map.Entry<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> entry : map.entrySet()) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = entry.getValue();
                long[] lArray = c2.a(this.profilingData);
                List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>> list2 = entry.getKey();
                byte by2 = d.a(c2.iM());
                com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.s(list2);
                com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = e2.iS();
                if (e2.iT() && d2 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                    com.oracle.svm.enterprise.profiling.metadata.cctree.c c3 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d2;
                    c3.a(h2, lArray);
                    continue;
                }
                int n2 = h2.az(lArray.length);
                h2.a(n2, lArray);
                b2.a(list2, by2, n2);
            }
        }
    }

    private static <T, M> List<com.oracle.svm.enterprise.profiling.collect.d> assimilate0(List<com.oracle.svm.enterprise.profiling.collect.d> list, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, T> map, Map<Integer, M> map2, byte by2) {
        ArrayList<com.oracle.svm.enterprise.profiling.collect.d> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.collect.d>();
        c c2 = d.j(by2);
        for (com.oracle.svm.enterprise.profiling.collect.d d2 : list) {
            d2.c(c2.a(d2.is(), b2, map));
            if (c2.i(d2.is()) <= 0L || !ProfilingBaseProfile.checkCallingContext(d2, b2, map2)) continue;
            arrayList.add(d2);
        }
        return arrayList;
    }

    private static <T, M> boolean checkCallingContext(com.oracle.svm.enterprise.profiling.collect.d d2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, M> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : f.af(d2.it())) {
            Pair<Integer, Integer> pair = f.ae(string);
            int n2 = 0;
            if ((Integer)pair.getLeft() != 0) {
                M m2 = map.get(pair.getLeft());
                if (m2 == null) {
                    return false;
                }
                n2 = b2.s(m2);
            }
            arrayList.add(f.b(n2, (Integer)pair.getRight()));
        }
        d2.ag(String.join((CharSequence)"<", arrayList));
        return true;
    }

    private List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodes() {
        return this.profilingMetadata.a((list, a2) -> {
            ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>((Collection<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>)list);
            arrayList.add((com.oracle.svm.enterprise.profiling.metadata.codepositions.a)a2);
            return arrayList;
        }, ArrayList::new);
    }

    private List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodesWithStringContext() {
        return this.profilingMetadata.a((string, a2) -> {
            Object object = f.b(a2.iV(), a2.iU());
            if (!string.isEmpty()) {
                object = string + "<" + (String)object;
            }
            return object;
        }, () -> "");
    }

    private List<List<com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findLeafNodes() {
        return this.profilingMetadata.findLeafNodes();
    }
}

