/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

@AutomaticallyRegisteredFeature
public class j
extends ProgressReporterFeature {
    protected void appendGraalSuffix(ProgressReporter.DirectPrinter directPrinter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (com.oracle.svm.enterprise.hosted.profiling.features.a.ie()) {
            arrayList.add("instrument");
        }
        if (PGOFeature.isPGOEnabled()) {
            arrayList.add("user-provided");
        }
        if (com.oracle.svm.enterprise.hosted.ml.features.provider.a.gq()) {
            arrayList.add("ML-inferred");
        }
        if (!arrayList.isEmpty()) {
            this.reporter.recordJsonMetric((ProgressReporterJsonHelper.JsonMetric)ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_PGO, arrayList);
        }
        String string = arrayList.isEmpty() ? "off" : String.join((CharSequence)"+", arrayList);
        ((ProgressReporter.DirectPrinter)directPrinter.a(", ").doclink("PGO", "#recommendation-pgo")).a(": ").a(string);
    }

    public void createAdditionalArtifacts(BuildArtifacts buildArtifacts) {
        if (ImageSingletons.contains(a.class)) {
            ((a)ImageSingletons.lookup(a.class)).a(buildArtifacts);
        }
    }

    protected List<ProgressReporterFeature.UserRecommendation> getRecommendations() {
        ArrayList<ProgressReporterFeature.UserRecommendation> arrayList = new ArrayList<ProgressReporterFeature.UserRecommendation>();
        arrayList.add(new ProgressReporterFeature.UserRecommendation("G1GC", "Use the G1 GC ('--gc=G1') for improved latency and throughput.", j::fi));
        arrayList.add(new ProgressReporterFeature.UserRecommendation("PGO", "Use Profile-Guided Optimizations ('--pgo') for improved throughput.", () -> !PGOFeature.isPGOEnabled()));
        arrayList.addAll(super.getRecommendations());
        arrayList.add(new ProgressReporterFeature.UserRecommendation("QBM", "Use the quick build mode ('-Ob') to speed up builds during development.", () -> !SubstrateOptions.useEconomyCompilerConfig()));
        arrayList.add(new ProgressReporterFeature.UserRecommendation("BRPT", "Try out the new build reports with '-H:+BuildReport'.", () -> !ImageSingletons.contains(a.class)));
        return arrayList;
    }

    private static boolean fi() {
        return !SubstrateOptions.UseSerialGC.hasBeenSet() && Platform.includedIn(Platform.LINUX_AMD64.class);
    }

    public static interface a {
        public void a(BuildArtifacts var1);
    }
}

