/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.code.layout.a;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaMethodProfile;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class CalculateCallerCalleeCountPhase
extends BasePhase<CoreProviders> {
    final PGOProfilesLookup Fn;
    final a Fo;

    public CalculateCallerCalleeCountPhase(PGOProfilesLookup pGOProfilesLookup, a a2) {
        this.Fn = pGOProfilesLookup;
        this.Fo = a2;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        ConcurrentMap<HostedMethod, Map<HostedMethod, Long>> concurrentMap = this.Fo.fG();
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        assert (concurrentMap.get(hostedMethod) == null) : "Caller-callee count should not be overwritten: double entry for " + String.valueOf(hostedMethod);
        if (!this.Fn.isProfiled(hostedMethod)) {
            return;
        }
        ControlFlowGraph controlFlowGraph = ControlFlowGraph.compute((StructuredGraph)structuredGraph, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        Function<HIRBlock, Iterable<? extends Node>> function = CalculateCallerCalleeCountPhase.a(controlFlowGraph);
        IdentityHashMap<HostedMethod, Long> identityHashMap = new IdentityHashMap<HostedMethod, Long>();
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            double d2 = hIRBlock.getRelativeFrequency();
            for (Node node : function.apply(hIRBlock)) {
                if (!(node instanceof Invoke)) continue;
                long l2 = this.Fn.getCallCountProfile(hostedMethod).map(PGOProfilesLookup.a::hk).orElse(0L);
                this.a((Invoke)node, identityHashMap, l2, d2);
            }
        }
        concurrentMap.put(hostedMethod, identityHashMap);
    }

    private static Function<HIRBlock, Iterable<? extends Node>> a(ControlFlowGraph controlFlowGraph) {
        BlockMap blockMap = new BlockMap((AbstractControlFlowGraph)controlFlowGraph);
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            ArrayList<FixedNode> arrayList = new ArrayList<FixedNode>();
            for (FixedNode fixedNode : hIRBlock.getNodes()) {
                arrayList.add(fixedNode);
            }
            blockMap.put((BasicBlock)hIRBlock, arrayList);
        }
        return arg_0 -> ((BlockMap)blockMap).get(arg_0);
    }

    private void a(Invoke invoke, Map<HostedMethod, Long> map, long l2, double d2) {
        if (invoke.callTarget() == null) {
            return;
        }
        if (invoke.getInvokeKind().isDirect()) {
            this.b(invoke, map, l2, d2);
        } else {
            this.c(invoke, map, l2, d2);
        }
    }

    private void b(Invoke invoke, Map<HostedMethod, Long> map, long l2, double d2) {
        if (invoke.getTargetMethod() == null) {
            return;
        }
        HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
        this.a(hostedMethod, map, l2, d2, 1.0);
    }

    private void c(Invoke invoke, Map<HostedMethod, Long> map, long l2, double d2) {
        if (invoke.callTarget() instanceof SubstrateMethodCallTargetNode) {
            SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)invoke.callTarget();
            if (substrateMethodCallTargetNode.getMethodProfile() == null) {
                return;
            }
            for (JavaMethodProfile.ProfiledMethod profiledMethod : substrateMethodCallTargetNode.getMethodProfile().getMethods()) {
                HostedMethod hostedMethod = (HostedMethod)profiledMethod.getMethod();
                this.a(hostedMethod, map, l2, d2, profiledMethod.getProbability());
            }
        }
    }

    private void a(HostedMethod hostedMethod, Map<HostedMethod, Long> map, long l2, double d2, double d3) {
        long l3 = this.Fn.getCallCountProfile(hostedMethod).map(PGOProfilesLookup.a::hk).orElse(0L);
        if (l3 == 0L) {
            return;
        }
        long l4 = Math.round((double)l2 * d2 * d3);
        if (l4 > 0L) {
            Long l5 = map.getOrDefault(hostedMethod, 0L);
            map.put(hostedMethod, l5 + l4);
        }
    }
}

