/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.al;
import com.oracle.svm.enterprise.gc.g1.b;
import com.oracle.svm.enterprise.gc.g1.e;
import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class i
extends ObjectHeader {
    private final int AR;
    private final int AS;
    private final int AT;
    private final UnsignedWord AU;
    private final UnsignedWord AV;
    private final int AW;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public i() {
        if (al.useCompressedReferences()) {
            this.AR = 5;
            this.AS = CodeUtil.log2((int)ConfigurationValues.getObjectLayout().getAlignment());
            this.AT = this.AR - this.AS;
            this.AU = WordFactory.unsigned((int)1);
            this.AV = WordFactory.unsigned((int)30);
            this.AW = NumUtil.safeToInt((long)this.AU.or(this.AV).rawValue());
            assert (b.eg() == Long.bitCount(this.AV.rawValue()));
        } else {
            this.AR = 0;
            this.AS = 0;
            this.AT = 0;
            this.AU = WordFactory.unsigned((int)0);
            this.AV = WordFactory.unsigned((int)0);
            this.AW = 0;
        }
    }

    @Fold
    public static i get() {
        return (i)e.get().getObjectHeader();
    }

    public int getReservedBitsMask() {
        return this.AW;
    }

    public Word encodeAsTLABObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Word a(DynamicHub dynamicHub) {
        Word word = Word.objectToUntrackedPointer((Object)dynamicHub).subtract((UnsignedWord)KnownIntrinsics.heapBase());
        i.a(this.h((UnsignedWord)word), "must be in hub-specific address space");
        Word word2 = word.shiftLeft(this.AT);
        i.a(word2.and(this.AW).isNull(), "all reserved bits must be zero");
        return word2;
    }

    public long encodeAsImageHeapObjectHeader(ImageHeapObject imageHeapObject, long l2) {
        assert (this.h(WordFactory.unsigned((long)l2)));
        long l3 = l2 << this.AT;
        assert ((l3 & (long)this.AW) == 0L) : "all reserved bits must be zero";
        return l3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(Word word) {
        Object object;
        if (al.useCompressedReferences()) {
            Word word2 = word.unsignedShiftRight(this.AR);
            object = ReferenceAccess.singleton().uncompressReference((UnsignedWord)word2);
        } else {
            assert (this.AR == 0);
            Word word3 = word.add((UnsignedWord)KnownIntrinsics.heapBase());
            object = word3.toObject();
        }
        return (DynamicHub)object;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer pointer) {
        Word word = this.readHeaderFromPointer(pointer);
        return this.dynamicHubFromObjectHeader(word);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer readPotentialDynamicHubFromPointer(Pointer pointer) {
        Word word = this.readHeaderFromPointer(pointer);
        if (al.useCompressedReferences()) {
            Word word2 = word.unsignedShiftRight(this.AR);
            return KnownIntrinsics.heapBase().add(word2.shiftLeft(ObjectHeader.getCompressionShift()));
        }
        return word.add((UnsignedWord)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromPointer(Pointer pointer) {
        if (al.useCompressedReferences()) {
            return (Word)WordFactory.unsigned((int)pointer.readInt(i.eu()));
        }
        return (Word)pointer.readWord(i.eu());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer pointer, Word word) {
        pointer.writeWord(i.eu(), (WordBase)word, LocationIdentity.INIT_LOCATION);
        if (al.useCompressedReferences()) {
            i.a(word.and((Word)WordFactory.unsigned((long)-4294967296L)).isNull(), "the whole 32-bit mark word must be 0");
        } else {
            pointer.writeWord(i.ev(), WordFactory.zero(), LocationIdentity.INIT_LOCATION);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOptionalIdentityHashField(Word word) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have a fixed identity hash code field");
            return false;
        }
        throw VMError.shouldNotReachHere();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasIdentityHashFromAddress(Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have a fixed identity hash code field");
        return false;
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public void setIdentityHashFromAddress(Pointer pointer, Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(boolean bl2, String string) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)bl2, (String)string);
        } else assert (bl2) : string;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int eu() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int ev() {
        return i.eu() + i.ew();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int ew() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean h(UnsignedWord unsignedWord) {
        UnsignedWord unsignedWord2 = this.ex();
        return unsignedWord2.aboveThan(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UnsignedWord ex() {
        if (!al.useCompressedReferences() && this.AT == 0) {
            return UnsignedUtils.MAX_VALUE;
        }
        int n2 = ConfigurationValues.getObjectLayout().getReferenceSize();
        return WordFactory.unsigned((long)(1L << n2 * 8 - this.AT));
    }
}

