/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.monitor;

import com.oracle.graal.virtual.enterprise.DeDuplicationPhase;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.monitor.MonitorSnippets;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.monitor.e;
import com.oracle.svm.enterprise.core.monitor.j;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Map;
import java.util.Objects;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.word.LocationIdentity;

public class d
extends MonitorSnippets {
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor uq = SnippetRuntime.findForeignCall(e.class, (String)"slowPathMonitorExit", (boolean)false, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor[] ur = new SnippetRuntime.SubstrateForeignCallDescriptor[]{uq};
    private final ResolvedJavaField us;
    private final SnippetReflectionProvider ut;
    private final SnippetTemplate.SnippetInfo uu;
    private final SnippetTemplate.SnippetInfo uv;

    @Snippet
    protected static void thinLockMonitorEnterSnippet(Object object, int n2) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (!e.b(object, n2, false) ? 1 : 0) != 0)) {
            d.callSlowPath((ForeignCallDescriptor)SLOW_PATH_MONITOR_ENTER, (Object)object);
        }
    }

    @Snippet
    protected static void thinLockMonitorExitSnippet(Object object, int n2) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        int n3 = -1;
        if (BranchProbabilityNode.probability((double)0.99, (n2 != 0 ? 1 : 0) != 0)) {
            Object object2 = BarrieredAccess.readObject((Object)object, (int)n2);
            n3 = BranchProbabilityNode.probability((double)0.99, (boolean)e.a(object, n2, object2)) ? 0 : e.n(object2);
        }
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (n3 != 0 ? 1 : 0) != 0)) {
            d.callSlowPathMonitorExit((ForeignCallDescriptor)uq, object, n3);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    protected static native void callSlowPathMonitorExit(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, int var2);

    protected d(OptionValues optionValues, Providers providers) {
        super(optionValues, providers);
        this.uu = this.snippet(providers, d.class, "thinLockMonitorEnterSnippet", new LocationIdentity[0]);
        this.uv = this.snippet(providers, d.class, "thinLockMonitorExitSnippet", new LocationIdentity[0]);
        this.ut = providers.getSnippetReflection();
        this.us = providers.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(DynamicHub.class, (String)"monitorOffset"));
    }

    protected void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
        a a2 = new a();
        map.put((Class<Node>)MonitorEnterNode.class, (NodeLoweringProvider<?>)a2);
        map.put((Class<Node>)MonitorExitNode.class, (NodeLoweringProvider<?>)a2);
    }

    protected PhaseSuite<CoreProviders> createMidTierPhases() {
        PhaseSuite phaseSuite = new PhaseSuite();
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        phaseSuite.appendPhase((BasePhase)new DeDuplicationPhase(CanonicalizerPhase.create()));
        return phaseSuite;
    }

    protected class a
    extends MonitorSnippets.MonitorLowering {
        protected a() {
            super((MonitorSnippets)d.this);
        }

        protected void lowerHighTier(AccessMonitorNode accessMonitorNode, LoweringTool loweringTool) {
            super.lowerHighTier(accessMonitorNode, loweringTool);
            if (accessMonitorNode.getObjectData() == null && this.a(accessMonitorNode)) {
                DynamicHubCompanion dynamicHubCompanion;
                ResolvedJavaType resolvedJavaType;
                if (accessMonitorNode.object().isJavaConstant() && (resolvedJavaType = loweringTool.getConstantReflection().asJavaType((Constant)accessMonitorNode.object().asJavaConstant())) != null) {
                    dynamicHubCompanion = ((SharedType)resolvedJavaType).getHub().getCompanion();
                    accessMonitorNode.setObject((ValueNode)ConstantNode.forConstant((JavaConstant)d.this.ut.forObject((Object)dynamicHubCompanion), (MetaAccessProvider)loweringTool.getMetaAccess(), (StructuredGraph)accessMonitorNode.graph()));
                }
                resolvedJavaType = (ValueNode)accessMonitorNode.graph().addOrUnique((Node)LoadHubNode.create((ValueNode)accessMonitorNode.object(), (StampProvider)loweringTool.getStampProvider(), (MetaAccessProvider)loweringTool.getMetaAccess(), (ConstantReflectionProvider)loweringTool.getConstantReflection()));
                dynamicHubCompanion = (LoadFieldNode)accessMonitorNode.graph().add((Node)LoadFieldNode.create((Assumptions)accessMonitorNode.graph().getAssumptions(), (ValueNode)resolvedJavaType, (ResolvedJavaField)d.this.us));
                accessMonitorNode.graph().addBeforeFixed((FixedNode)accessMonitorNode, (FixedWithNextNode)dynamicHubCompanion);
                accessMonitorNode.setObjectData((ValueNode)dynamicHubCompanion);
                dynamicHubCompanion.lower(loweringTool);
            }
        }

        protected void lowerLowTier(AccessMonitorNode accessMonitorNode, LoweringTool loweringTool) {
            if (this.a(accessMonitorNode)) {
                SnippetTemplate.SnippetInfo snippetInfo;
                if (accessMonitorNode instanceof MonitorEnterNode) {
                    snippetInfo = d.this.uu;
                } else if (accessMonitorNode instanceof MonitorExitNode) {
                    snippetInfo = d.this.uv;
                } else {
                    throw VMError.shouldNotReachHere();
                }
                SnippetTemplate.Arguments arguments = new SnippetTemplate.Arguments(snippetInfo, accessMonitorNode.graph().getGuardsStage(), loweringTool.getLoweringStage());
                arguments.add("obj", (Object)accessMonitorNode.object());
                arguments.add("monitorOffset", (Object)Objects.requireNonNull(accessMonitorNode.getObjectData()));
                d.this.template((CoreProviders)loweringTool, (ValueNode)accessMonitorNode, arguments).instantiate(loweringTool.getMetaAccess(), (FixedNode)accessMonitorNode, SnippetTemplate.DEFAULT_REPLACER, arguments);
            } else {
                super.lowerLowTier(accessMonitorNode, loweringTool);
            }
        }

        private boolean a(AccessMonitorNode accessMonitorNode) {
            return (Boolean)j.UseMonitorFastPath.getValue() != false && !MultiMethod.isDeoptTarget((ResolvedJavaMethod)accessMonitorNode.graph().method());
        }
    }
}

