/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.nativeimage.AnnotationAccess;

public class InlineBeforeAnalysisPolicyImpl
extends InlineBeforeAnalysisPolicy<CountersScope> {
    private final SVMHost hostVM;
    private final int allowedNodes = Options.InlineBeforeAnalysisAllowedNodes.getValue();
    private final int allowedInvokes = Options.InlineBeforeAnalysisAllowedInvokes.getValue();
    private final int allowedDepth = Options.InlineBeforeAnalysisAllowedDepth.getValue();

    public InlineBeforeAnalysisPolicyImpl(SVMHost hostVM) {
        super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
        this.hostVM = hostVM;
    }

    protected boolean alwaysInlineInvoke(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method) {
        return false;
    }

    protected boolean shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (this.alwaysInlineInvoke((AnalysisMetaAccess)b.getMetaAccess(), method)) {
            return true;
        }
        if (b.getDepth() > this.allowedDepth) {
            return false;
        }
        if (b.recursiveInliningDepth(method) > 0) {
            return false;
        }
        return InlineBeforeAnalysisPolicyImpl.inliningAllowed(this.hostVM, b, method);
    }

    protected boolean tryInvocationPlugins() {
        return true;
    }

    public static boolean inliningAllowed(SVMHost hostVM, GraphBuilderContext b, ResolvedJavaMethod method) {
        AnalysisMethod callee;
        AnalysisMethod caller = (AnalysisMethod)b.getMethod();
        if (hostVM.neverInlineTrivial(caller, callee = (AnalysisMethod)method)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Fold.class) || AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Node.NodeIntrinsic.class)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, RestrictHeapAccess.class)) {
            return false;
        }
        return Uninterruptible.Utils.inliningAllowed((AnnotatedElement)caller, (AnnotatedElement)callee);
    }

    protected CountersScope createRootScope() {
        return null;
    }

    protected CountersScope openCalleeScope(CountersScope outer) {
        CountersScope accumulated = outer == null ? new CountersScope(null) : outer.accumulated;
        return new CountersScope(accumulated);
    }

    protected void commitCalleeScope(CountersScope outer, CountersScope callee) {
        assert (outer.accumulated == callee.accumulated);
        outer.numNodes += callee.numNodes;
        outer.numInvokes += callee.numInvokes;
    }

    protected void abortCalleeScope(CountersScope outer, CountersScope callee) {
        assert (outer.accumulated == callee.accumulated);
        outer.accumulated.numNodes -= callee.numNodes;
        outer.accumulated.numInvokes -= callee.numInvokes;
    }

    protected boolean processNode(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, CountersScope scope, Node node) {
        if (node instanceof StartNode || node instanceof ParameterNode || node instanceof ReturnNode || node instanceof UnwindNode) {
            throw VMError.shouldNotReachHere("Node must not be visible to policy: " + node.getClass().getTypeName());
        }
        if (node instanceof FullInfopointNode || node instanceof ValueProxy || node instanceof ValueAnchorNode || node instanceof FrameState || node instanceof AbstractBeginNode || node instanceof AbstractEndNode) {
            return true;
        }
        if (node instanceof ConstantNode || node instanceof LogicConstantNode) {
            return true;
        }
        if (node instanceof ReachabilityRegistrationNode) {
            return true;
        }
        if (this.alwaysInlineInvoke(metaAccess, method)) {
            return true;
        }
        if (node instanceof AbstractNewObjectNode) {
            ValueNode newArrayLength;
            return node instanceof NewArrayNode && (newArrayLength = ((NewArrayNode)node).length()).isJavaConstant() && newArrayLength.asJavaConstant().asInt() == 0;
        }
        if (node instanceof VirtualObjectNode) {
            int newArrayLength;
            return node instanceof VirtualArrayNode && (newArrayLength = ((VirtualArrayNode)node).entryCount()) == 0;
        }
        if (node instanceof CommitAllocationNode || node instanceof AllocatedObjectNode) {
            return true;
        }
        if (node instanceof CallTargetNode) {
            throw VMError.shouldNotReachHere("Node must not be visible to policy: " + node.getClass().getTypeName());
        }
        if (node instanceof Invoke) {
            if (scope.accumulated.numInvokes >= this.allowedInvokes) {
                return false;
            }
            ++scope.numInvokes;
            ++scope.accumulated.numInvokes;
        }
        if (scope.accumulated.numNodes >= this.allowedNodes) {
            return false;
        }
        ++scope.numNodes;
        ++scope.accumulated.numNodes;
        return true;
    }

    public static class Options {
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedNodes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedInvokes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedDepth = new HostedOptionKey<Integer>(20);
    }

    protected static final class CountersScope
    implements InlineBeforeAnalysisPolicy.Scope {
        final CountersScope accumulated;
        int numNodes;
        int numInvokes;

        CountersScope(CountersScope accumulated) {
            this.accumulated = accumulated;
        }

        public String toString() {
            return this.numNodes + "/" + this.numInvokes + " (" + this.accumulated.numNodes + "/" + this.accumulated.numInvokes + ")";
        }
    }
}

