/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class StringInternFeature
implements InternalFeature {
    StringInternFeature() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ResolvedJavaField getInternedStringsField(MetaAccessProvider metaAccess) {
        try {
            return metaAccess.lookupJavaField(StringInternSupport.class.getDeclaredField("internedStrings"));
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(StringInternSupport.class, (Object)new StringInternSupport());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        StringInternFeature.getInternedStringsField((MetaAccessProvider)config.getMetaAccess());
    }
}

