/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.util;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;

public class FileUtils {
    public static void drainInputStream(InputStream source, OutputStream sink) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = source.read(buffer)) != -1) {
                sink.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static List<String> readAllLines(InputStream source) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(source));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static int executeCommand(String ... args) throws IOException, InterruptedException {
        return FileUtils.executeCommand(Arrays.asList(args));
    }

    public static int executeCommand(List<String> args) throws IOException, InterruptedException {
        ProcessBuilder command = FileUtils.prepareCommand(args, null).redirectErrorStream(true);
        FileUtils.traceCommand(command);
        Process process = command.start();
        try (Closeable ignored = process::destroy;){
            try (InputStream inputStream = process.getInputStream();){
                FileUtils.traceCommandOutput(FileUtils.readAllLines(inputStream));
            }
            int n = process.waitFor();
            return n;
        }
    }

    public static ProcessBuilder prepareCommand(List<String> args, Path commandDir) throws IOException {
        Path tempDir;
        ProcessBuilder command = new ProcessBuilder(new String[0]).command(args);
        if (commandDir != null) {
            tempDir = commandDir;
        } else {
            Path temp = ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory();
            tempDir = temp.resolve(Paths.get(args.get(0), new String[0]).getFileName());
        }
        Files.createDirectories(tempDir, new FileAttribute[0]);
        command.directory(tempDir.toFile());
        return command;
    }

    public static void traceCommand(ProcessBuilder command) {
        if (FileUtils.isTraceEnabled()) {
            String commandLine = SubstrateUtil.getShellCommandString(command.command(), false);
            FileUtils.trace(">> %s", commandLine);
        }
    }

    public static void traceCommandOutput(List<String> lines) {
        if (FileUtils.isTraceEnabled()) {
            for (String line : lines) {
                FileUtils.trace("># %s", line);
            }
        }
    }

    private static boolean isTraceEnabled() {
        return SubstrateOptions.TraceNativeToolUsage.getValue() != false || DebugContext.forCurrentThread().isLogEnabled(3);
    }

    private static void trace(String format, String arg) {
        assert (FileUtils.isTraceEnabled());
        DebugContext debug = DebugContext.forCurrentThread();
        if (debug.isLogEnabled(3)) {
            debug.log(format, (Object)arg);
        } else {
            System.out.printf(format + "%n", arg);
        }
    }
}

