/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.darwin.DarwinVMSemaphore;

final class DarwinVMSemaphoreSupport
extends PosixVMSemaphoreSupport {
    @UnknownObjectField(types={DarwinVMSemaphore[].class})
    DarwinVMSemaphore[] semaphores;

    DarwinVMSemaphoreSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public boolean initialize() {
        for (DarwinVMSemaphore semaphore : this.semaphores) {
            if (semaphore.init() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void destroy() {
        for (DarwinVMSemaphore semaphore : this.semaphores) {
            semaphore.destroy();
        }
    }

    public DarwinVMSemaphore[] getSemaphores() {
        return this.semaphores;
    }
}

