/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.JNIPlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_io_UnixFileSystem_JNI;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Resource;
import com.oracle.svm.core.posix.headers.darwin.DarwinSyslimits;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class PosixNativeLibrarySupport
extends JNIPlatformNativeLibrarySupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private PosixNativeLibrarySupport() {
    }

    static void initialize() {
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)new PosixNativeLibrarySupport());
    }

    @Override
    public boolean initializeBuiltinLibraries() {
        if (Isolates.isCurrentFirst()) {
            Resource.rlimit rlp = UnsafeStackValue.get(Resource.rlimit.class);
            if (Resource.getrlimit(Resource.RLIMIT_NOFILE(), rlp) == 0) {
                UnsignedWord newValue = rlp.rlim_max();
                if (Platform.includedIn(Platform.DARWIN.class)) {
                    newValue = WordFactory.unsigned((int)DarwinSyslimits.OPEN_MAX());
                }
                rlp.set_rlim_cur(newValue);
                if (Resource.setrlimit(Resource.RLIMIT_NOFILE(), rlp) != 0) {
                    Log.log().string("setrlimit to increase file descriptor limit failed, errno ").signed(LibC.errno()).newline();
                }
            } else {
                Log.log().string("getrlimit failed, errno ").signed(LibC.errno()).newline();
            }
        }
        if (Platform.includedIn(InternalPlatform.PLATFORM_JNI.class)) {
            try {
                this.loadJavaLibrary();
                PosixNativeLibrarySupport.loadNetLibrary();
                System.setProperty("jdk.lang.Process.launchMechanism", "FORK");
            }
            catch (UnsatisfiedLinkError e) {
                Log.log().string("System.loadLibrary failed, " + String.valueOf(e)).newline();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void loadJavaLibrary() {
        super.loadJavaLibrary();
        Target_java_io_UnixFileSystem_JNI.initIDs();
    }

    private static void loadNetLibrary() {
        if (Isolates.isCurrentFirst()) {
            System.loadLibrary("net");
        } else {
            NativeLibrarySupport.singleton().registerInitializedBuiltinLibrary("net");
        }
    }

    @Override
    public PosixNativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new PosixNativeLibrary(canonical, builtIn);
    }

    @Override
    public PointerBase findBuiltinSymbol(String name) {
        try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
            Object t = Dlfcn.dlsym(Dlfcn.RTLD_DEFAULT(), symbol.get());
            return t;
        }
    }

    class PosixNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private PointerBase dlhandle = WordFactory.nullPointer();
        private boolean loaded = false;

        PosixNativeLibrary(String canonicalIdentifier, boolean builtin) {
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
        }

        @Override
        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        @Override
        public boolean isBuiltin() {
            return this.builtin;
        }

        @Override
        public boolean load() {
            assert (!this.loaded);
            this.loaded = this.doLoad();
            return this.loaded;
        }

        private boolean doLoad() {
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                Jvm.initialize();
            }
            if (this.builtin) {
                return true;
            }
            assert (this.dlhandle.isNull());
            this.dlhandle = PosixUtils.dlopen(this.canonicalIdentifier, Dlfcn.RTLD_LAZY());
            return this.dlhandle.isNonNull();
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public PointerBase findSymbol(String name) {
            if (this.builtin) {
                return PosixNativeLibrarySupport.this.findBuiltinSymbol(name);
            }
            assert (this.dlhandle.isNonNull());
            return PosixUtils.dlsym(this.dlhandle, name);
        }
    }
}

