/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_VarHandle;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_VarHandle_AccessDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

@TargetClass(className="java.lang.invoke.Invokers")
final class Target_java_lang_invoke_Invokers {
    Target_java_lang_invoke_Invokers() {
    }

    @Substitute
    static void checkExactType(MethodHandle mh, MethodType expected) {
        if (!expected.equals((Object)mh.type())) {
            throw new WrongMethodTypeException("expected " + String.valueOf(expected) + " but found " + String.valueOf(mh.type()));
        }
    }

    @Substitute
    static MethodHandle checkVarHandleGenericType(Target_java_lang_invoke_VarHandle handle, Target_java_lang_invoke_VarHandle_AccessDescriptor ad) {
        MethodHandle mh = handle.getMethodHandle(ad.mode);
        if (mh.type().equals((Object)ad.symbolicMethodTypeInvoker)) {
            return mh;
        }
        return mh.asType(ad.symbolicMethodTypeInvoker);
    }

    @Substitute
    static MethodHandle checkVarHandleExactType(Target_java_lang_invoke_VarHandle handle, Target_java_lang_invoke_VarHandle_AccessDescriptor ad) {
        MethodHandle mh = handle.getMethodHandle(ad.mode);
        MethodType mt = mh.type();
        if (!mt.equals((Object)ad.symbolicMethodTypeInvoker)) {
            throw Target_java_lang_invoke_Invokers.newWrongMethodTypeException(mt, ad.symbolicMethodTypeInvoker);
        }
        return mh;
    }

    @Alias
    static native WrongMethodTypeException newWrongMethodTypeException(MethodType var0, MethodType var1);
}

