/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.UnsupportedFeatureError;
import com.oracle.svm.core.jdk.VMErrorSubstitutions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=VMError.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_com_oracle_svm_core_util_VMError {
    Target_com_oracle_svm_core_util_VMError() {
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere() {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), null, null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), msg, null);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), null, ex);
    }

    @NeverInline(value="Accessing instruction pointer of the caller frame")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        throw VMErrorSubstitutions.shouldNotReachHere(KnownIntrinsics.readReturnAddress(), msg, ex);
    }

    @Substitute
    private static RuntimeException unimplemented() {
        return Target_com_oracle_svm_core_util_VMError.unsupportedFeature("unimplemented");
    }

    @Substitute
    private static RuntimeException unsupportedFeature(String msg) {
        throw new UnsupportedFeatureError(msg);
    }
}

