/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.CPUSamplerData;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.impl.ProfilerCLI;
import com.oracle.truffle.tools.profiler.impl.SVGSamplerOutput;
import com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@Option.Group(value={"cpusampler"})
class CPUSamplerCLI
extends ProfilerCLI {
    public static final long MILLIS_TO_NANOS = 1000000L;
    public static final double MAX_OVERHEAD_WARNING_THRESHOLD = 0.2;
    public static final String DEFAULT_FLAMEGRAPH_FILE = "flamegraph.svg";
    static final OptionType<EnableOptionData> ENABLE_OPTION_TYPE = new OptionType("Enable", s -> {
        switch (s) {
            case "": 
            case "true": {
                return new EnableOptionData(true, null);
            }
            case "false": {
                return new EnableOptionData(false, null);
            }
        }
        try {
            Output output = Output.fromString(s);
            return new EnableOptionData(true, output);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("CPUSampler can be configured with the following values: true, false, " + Output.valueList() + ".");
        }
    });
    static final OptionType<Output> CLI_OUTPUT_TYPE = new OptionType("Output", Output::fromString);
    static final OptionType<int[]> SHOW_TIERS_OUTPUT_TYPE = new OptionType("ShowTiers", (Function)new Function<String, int[]>(){

        @Override
        public int[] apply(String s) {
            if ("false".equals(s)) {
                return null;
            }
            if ("true".equals(s)) {
                return new int[0];
            }
            try {
                String[] tierStrings = s.split(",");
                int[] tiers = new int[tierStrings.length];
                for (int i = 0; i < tierStrings.length; ++i) {
                    tiers[i] = Integer.parseInt(tierStrings[i]);
                }
                return tiers;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("ShowTiers can be: true, false or a comma separated list of integers");
            }
        }
    });
    @Option(name="", help="Enable/Disable the CPU sampler, or enable with specific Output - as specified by the Output option (default: false). Choosing an output with this options defaults to printing the output to std out, except for the flamegraph which is printed to a flamegraph.svg file.", usageSyntax="true|false|<Output>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<EnableOptionData> ENABLED = new OptionKey((Object)new EnableOptionData(false, null), ENABLE_OPTION_TYPE);
    @Option(name="Period", help="Period in milliseconds to sample the stack (default: 10)", usageSyntax="<ms>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Long> SAMPLE_PERIOD = new OptionKey((Object)10L);
    @Option(name="Delay", help="Delay the sampling for this many milliseconds (default: 0).", usageSyntax="<ms>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Long> DELAY_PERIOD = new OptionKey((Object)0L);
    @Option(name="StackLimit", help="Maximum number of maximum stack elements (default: 10000).", usageSyntax="[1, inf)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Integer> STACK_LIMIT = new OptionKey((Object)10000);
    @Option(name="Output", help="Specify the output format to one of: histogram, calltree, json or flamegraph (default: histogram).", usageSyntax="histogram|calltree|json|flamegraph", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Output> OUTPUT = new OptionKey((Object)Output.HISTOGRAM, CLI_OUTPUT_TYPE);
    @Option(help="Specify whether to show compilation information for entries. You can specify 'true' to show all compilation information, 'false' for none, or a comma separated list of compilation tiers. Note: Interpreter is considered Tier 0. (default: false)", usageSyntax="true|false|0,1,2", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    static final OptionKey<int[]> ShowTiers = new OptionKey(null, SHOW_TIERS_OUTPUT_TYPE);
    @Option(name="FilterRootName", help="Wildcard filter for program roots. (eg. Math.*) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<WildcardFilter> FILTER_ROOT = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterFile", help="Wildcard filter for source file paths. (eg. *program*.sl) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<WildcardFilter> FILTER_FILE = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterMimeType", help="Only profile the language with given mime-type. (eg. application/javascript) (default: profile all)", usageSyntax="<mime-type>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_MIME_TYPE = new OptionKey((Object)"");
    @Option(name="FilterLanguage", help="Only profile the language with given ID. (eg. js) (default: profile all).", usageSyntax="<languageId>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_LANGUAGE = new OptionKey((Object)"");
    @Option(name="SampleInternal", help="Capture internal elements.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> SAMPLE_INTERNAL = new OptionKey((Object)false);
    @Option(name="SummariseThreads", help="Print output as a summary of all 'per thread' profiles.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> SUMMARISE_THREADS = new OptionKey((Object)false);
    @Option(name="GatherHitTimes", help="Save a timestamp for each taken sample.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> GATHER_HIT_TIMES = new OptionKey((Object)false);
    @Option(name="OutputFile", help="Save output to the given file. Output is printed to output stream by default.", usageSyntax="<path>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> OUTPUT_FILE = new OptionKey((Object)"");
    @Option(name="MinSamples", help="Remove elements from output if they have less samples than this value (default: 0)", usageSyntax="[0, inf)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Integer> MIN_SAMPLES = new OptionKey((Object)0);
    @Option(name="SampleContextInitialization", help="Enables sampling of code executed during context initialization", category=OptionCategory.EXPERT, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> SAMPLE_CONTEXT_INITIALIZATION = new OptionKey((Object)false);

    CPUSamplerCLI() {
    }

    static void handleOutput(TruffleInstrument.Env env, CPUSampler sampler) {
        PrintStream out = CPUSamplerCLI.chooseOutputStream(env);
        Map<TruffleContext, CPUSamplerData> data = sampler.getData();
        OptionValues options = env.getOptions();
        switch (CPUSamplerCLI.chooseOutput(options)) {
            case HISTOGRAM: {
                CPUSamplerCLI.printWarnings(sampler, out);
                CPUSamplerCLI.printSamplingHistogram(out, options, data);
                break;
            }
            case CALLTREE: {
                CPUSamplerCLI.printWarnings(sampler, out);
                CPUSamplerCLI.printSamplingCallTree(out, options, data);
                break;
            }
            case JSON: {
                CPUSamplerCLI.printSamplingJson(out, options, data);
                break;
            }
            case FLAMEGRAPH: {
                SVGSamplerOutput.printSamplingFlameGraph(out, data);
            }
        }
    }

    private static PrintStream chooseOutputStream(TruffleInstrument.Env env) {
        OptionValues options = env.getOptions();
        String outputPath = CPUSamplerCLI.getOutputPath(env, options);
        if (outputPath != null) {
            try {
                File file = new File(outputPath);
                new PrintStream(env.out()).println("Printing output to " + file.getAbsolutePath());
                return new PrintStream(new FileOutputStream(file));
            }
            catch (FileNotFoundException e) {
                throw CPUSamplerCLI.handleFileNotFound();
            }
        }
        return new PrintStream(env.out());
    }

    private static String getOutputPath(TruffleInstrument.Env env, OptionValues options) {
        if (OUTPUT_FILE.hasBeenSet(options)) {
            return (String)OUTPUT_FILE.getValue(env.getOptions());
        }
        if (((EnableOptionData)CPUSamplerCLI.ENABLED.getValue((OptionValues)options)).output == Output.FLAMEGRAPH) {
            return DEFAULT_FLAMEGRAPH_FILE;
        }
        return null;
    }

    private static Output chooseOutput(OptionValues options) {
        if (OUTPUT.hasBeenSet(options)) {
            return (Output)((Object)options.get(OUTPUT));
        }
        EnableOptionData enabled = (EnableOptionData)ENABLED.getValue(options);
        if (enabled.output != null) {
            return enabled.output;
        }
        return (Output)((Object)OUTPUT.getDefaultValue());
    }

    private static void printSamplingCallTree(PrintStream out, OptionValues options, Map<TruffleContext, CPUSamplerData> data) {
        for (Map.Entry<TruffleContext, CPUSamplerData> entry : data.entrySet()) {
            new SamplingCallTree(entry.getValue(), options).print(out);
        }
    }

    private static void printSamplingHistogram(PrintStream out, OptionValues options, Map<TruffleContext, CPUSamplerData> data) {
        for (Map.Entry<TruffleContext, CPUSamplerData> entry : data.entrySet()) {
            new SamplingHistogram(entry.getValue(), options).print(out);
        }
    }

    private static void printWarnings(CPUSampler sampler, PrintStream out) {
        if (sampler.hasStackOverflowed()) {
            CPUSamplerCLI.printDiv(out);
            out.println("Warning: The stack has overflowed the sampled stack limit of " + sampler.getStackLimit() + " during execution!");
            out.println("         The printed data is incomplete or incorrect!");
            out.println("         Use --cpusampler.StackLimit=<" + STACK_LIMIT.getType().getName() + "> to set the sampled stack limit.");
            CPUSamplerCLI.printDiv(out);
        }
        if (CPUSamplerCLI.sampleDurationTooLong(sampler)) {
            CPUSamplerCLI.printDiv(out);
            out.println("Warning: Average sample duration took over 20% of the sampling period.");
            out.println("         An overhead above 20% can severely impact the reliability of the sampling data. Use one of these approaches to reduce the overhead:");
            out.println("         Use --cpusampler.StackLimit=<" + STACK_LIMIT.getType().getName() + "> to reduce the number of frames sampled,");
            out.println("         or use --cpusampler.Period=<" + SAMPLE_PERIOD.getType().getName() + "> to increase the sampling period.");
            CPUSamplerCLI.printDiv(out);
        }
    }

    private static boolean sampleDurationTooLong(CPUSampler sampler) {
        for (CPUSamplerData value : sampler.getData().values()) {
            if (!(value.getSampleDuration().getAverage() > 0.2 * (double)sampler.getPeriod() * 1000000.0)) continue;
            return true;
        }
        return false;
    }

    private static void printDiv(PrintStream out) {
        out.println("-------------------------------------------------------------------------------- ");
    }

    private static void printSamplingJson(PrintStream out, OptionValues options, Map<TruffleContext, CPUSamplerData> data) {
        boolean gatheredHitTimes = (Boolean)options.get(GATHER_HIT_TIMES);
        JSONObject output = new JSONObject();
        output.put("tool", "cpusampler");
        output.put("version", "0.5.0");
        JSONArray contexts = new JSONArray();
        for (CPUSamplerData samplerData : data.values()) {
            contexts.put(CPUSamplerCLI.perContextData(samplerData, gatheredHitTimes));
        }
        output.put("contexts", contexts);
        out.println(output);
    }

    private static JSONObject perContextData(CPUSamplerData samplerData, boolean gatheredHitTimes) {
        JSONObject output = new JSONObject();
        output.put("sample_count", samplerData.getSamples());
        output.put("period", samplerData.getSampleInterval());
        output.put("gathered_hit_times", gatheredHitTimes);
        JSONArray profile = new JSONArray();
        for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> entry : samplerData.getThreadData().entrySet()) {
            JSONObject perThreadProfile = new JSONObject();
            perThreadProfile.put("thread", entry.getKey().toString());
            perThreadProfile.put("samples", CPUSamplerCLI.getSamplesRec(entry.getValue()));
            profile.put(perThreadProfile);
        }
        output.put("profile", profile);
        return output;
    }

    private static JSONArray getSamplesRec(Collection<ProfilerNode<CPUSampler.Payload>> nodes) {
        JSONArray samples = new JSONArray();
        for (ProfilerNode<CPUSampler.Payload> node : nodes) {
            JSONObject sample = new JSONObject();
            sample.put("root_name", node.getRootName());
            sample.put("source_section", CPUSamplerCLI.sourceSectionToJSON(node.getSourceSection()));
            CPUSampler.Payload payload = node.getPayload();
            sample.put("hit_count", payload.getHitCount());
            sample.put("self_hit_count", payload.getSelfHitCount());
            sample.put("self_hit_times", payload.getSelfHitTimes());
            int[] selfTierCount = new int[payload.getNumberOfTiers()];
            for (int i = 0; i < selfTierCount.length; ++i) {
                selfTierCount[i] = payload.getTierSelfCount(i);
            }
            sample.put("self_tier_count", selfTierCount);
            int[] tierCount = new int[payload.getNumberOfTiers()];
            for (int i = 0; i < tierCount.length; ++i) {
                tierCount[i] = payload.getTierSelfCount(i);
            }
            sample.put("tier_count", tierCount);
            sample.put("children", CPUSamplerCLI.getSamplesRec(node.getChildren()));
            samples.put(sample);
        }
        return samples;
    }

    private static void printLegend(PrintStream out, String type, long samples, long period, long missed, int[] showTiers, Integer[] tiers) {
        out.printf("Sampling %s. Recorded %s samples with period %dms. Missed %s samples.%n", type, samples, period, missed);
        out.println("  Self Time: Time spent on the top of the stack.");
        out.println("  Total Time: Time spent somewhere on the stack.");
        if (showTiers == null) {
            return;
        }
        if (showTiers.length == 0) {
            Integer[] integerArray = tiers;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                out.println("  T" + i2 + ": Percent of time spent in " + (String)((i2 = integerArray[i].intValue()) == 0 ? "interpreter." : "code compiled by tier " + i2 + " compiler."));
            }
            return;
        }
        for (int tier : showTiers) {
            if (CPUSamplerCLI.contains(tiers, tier)) {
                out.println("  T" + tier + ": Percent of time spent in " + (String)(tier == 0 ? "interpreter." : "code compiled by tier " + tier + " compiler."));
                continue;
            }
            out.println("  T" + tier + ": No samples of tier " + tier + " found during execution. It is excluded from the report.");
        }
    }

    private static double percent(long samples, long totalSamples) {
        if (totalSamples == 0L) {
            return 0.0;
        }
        return (double)samples * 100.0 / (double)totalSamples;
    }

    private static String[] makeTitleAndFormat(int nameLength, int[] showTiers, Integer[] tiers) {
        StringBuilder titleBuilder = new StringBuilder(CPUSamplerCLI.format(" %-" + nameLength + "s ||             Total Time    ", "Name"));
        StringBuilder formatBuilder = new StringBuilder(" %-" + nameLength + "s ||       %10dms %5.1f%% ");
        CPUSamplerCLI.maybeAddTiers(titleBuilder, formatBuilder, showTiers, tiers);
        titleBuilder.append("||              Self Time    ");
        formatBuilder.append("||       %10dms %5.1f%% ");
        CPUSamplerCLI.maybeAddTiers(titleBuilder, formatBuilder, showTiers, tiers);
        titleBuilder.append("|| Location             ");
        formatBuilder.append("|| %s");
        String[] strings = new String[]{titleBuilder.toString(), formatBuilder.toString()};
        return strings;
    }

    private static void maybeAddTiers(StringBuilder titleBuilder, StringBuilder formatBuilder, int[] showTiers, Integer[] tiers) {
        if (showTiers == null) {
            return;
        }
        if (showTiers.length == 0) {
            for (Integer i : tiers) {
                titleBuilder.append("|   T").append(i).append("   ");
                formatBuilder.append("| %5.1f%% ");
            }
            return;
        }
        for (int i = 0; i < showTiers.length; ++i) {
            int selectedTier = showTiers[i];
            if (!CPUSamplerCLI.contains(tiers, selectedTier)) continue;
            titleBuilder.append("|   T").append(selectedTier).append("   ");
            formatBuilder.append("| %5.1f%% ");
        }
    }

    private static boolean contains(Integer[] tiers, int selectedTier) {
        for (Integer tier : tiers) {
            if (tier != selectedTier) continue;
            return true;
        }
        return false;
    }

    private static Integer[] sortedArray(Set<Integer> tiers) {
        Object[] sorted = tiers.toArray(new Integer[0]);
        Arrays.sort(sorted);
        return sorted;
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    static enum Output {
        HISTOGRAM,
        CALLTREE,
        JSON,
        FLAMEGRAPH;


        private static String valueList() {
            StringBuilder message = new StringBuilder();
            Output[] values = Output.values();
            for (int i = 0; i < values.length; ++i) {
                Output value = values[i];
                message.append(value.name().toLowerCase());
                message.append(i < values.length - 1 ? ", " : "");
            }
            return message.toString();
        }

        private static Output fromString(String s) {
            try {
                return Output.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Output can be: " + Output.valueList() + ".");
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static final class EnableOptionData {
        final boolean enabled;
        final Output output;

        private EnableOptionData(boolean enabled, Output output) {
            this.enabled = enabled;
            this.output = output;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnableOptionData that = (EnableOptionData)o;
            return this.enabled == that.enabled && this.output == that.output;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.enabled, this.output});
        }

        public String toString() {
            return this.enabled ? this.output.toString() : "false";
        }
    }

    private static class SamplingCallTree {
        private final boolean summariseThreads;
        private final int minSamples;
        private final int[] showTiers;
        private final long samplePeriod;
        private final long samplesTaken;
        private final long samplesMissed;
        private final String title;
        private final String format;
        private final Map<Thread, Collection<CallTreeOutputEntry>> entries = new HashMap<Thread, Collection<CallTreeOutputEntry>>();
        private int maxNameLength = 10;
        private final Set<Integer> tiers = new HashSet<Integer>();
        private final Integer[] sortedTiers;

        SamplingCallTree(CPUSamplerData data, OptionValues options) {
            this.summariseThreads = (Boolean)options.get(SUMMARISE_THREADS);
            this.minSamples = (Integer)options.get(MIN_SAMPLES);
            this.showTiers = (int[])options.get(ShowTiers);
            this.samplePeriod = (Long)options.get(SAMPLE_PERIOD);
            this.samplesTaken = data.getSamples();
            this.samplesMissed = data.missedSamples();
            Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData = data.getThreadData();
            this.makeEntries(threadData);
            this.calculateMaxValues(threadData);
            this.sortedTiers = CPUSamplerCLI.sortedArray(this.tiers);
            String[] titleAndFormat = CPUSamplerCLI.makeTitleAndFormat(this.maxNameLength, this.showTiers, this.sortedTiers);
            this.title = titleAndFormat[0];
            this.format = titleAndFormat[1];
        }

        private void calculateMaxValues(Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData) {
            for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> entry : threadData.entrySet()) {
                for (ProfilerNode<CPUSampler.Payload> node : entry.getValue()) {
                    this.calculateMaxValuesRec(node, 0);
                }
            }
        }

        private void calculateMaxValuesRec(ProfilerNode<CPUSampler.Payload> node, int depth) {
            this.maxNameLength = Math.max(this.maxNameLength, node.getRootName().length() + OutputEntry.computeIndentSize(depth));
            this.tiers.add(node.getPayload().getNumberOfTiers() - 1);
            for (ProfilerNode<CPUSampler.Payload> child : node.getChildren()) {
                this.calculateMaxValuesRec(child, depth + 1);
            }
        }

        private void makeEntries(Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData) {
            if (this.summariseThreads) {
                ArrayList<CallTreeOutputEntry> callTreeEntries = new ArrayList<CallTreeOutputEntry>();
                for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> entry : threadData.entrySet()) {
                    for (ProfilerNode<CPUSampler.Payload> node : entry.getValue()) {
                        this.mergeEntry(callTreeEntries, node, 0);
                    }
                }
                this.entries.put(new Thread("Summary"), callTreeEntries);
            } else {
                for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> entry : threadData.entrySet()) {
                    ArrayList<CallTreeOutputEntry> callTreeEntries = new ArrayList<CallTreeOutputEntry>();
                    for (ProfilerNode<CPUSampler.Payload> node : entry.getValue()) {
                        callTreeEntries.add(this.makeEntry(node, 0));
                    }
                    this.entries.put(entry.getKey(), callTreeEntries);
                }
            }
        }

        private void mergeEntry(List<CallTreeOutputEntry> callTreeEntries, ProfilerNode<CPUSampler.Payload> node, int depth) {
            for (CallTreeOutputEntry callTreeEntry : callTreeEntries) {
                if (!callTreeEntry.corresponds(node)) continue;
                callTreeEntry.merge(node.getPayload());
                for (ProfilerNode<CPUSampler.Payload> child : node.getChildren()) {
                    this.mergeEntry(callTreeEntry.children, child, depth + 1);
                }
                return;
            }
            callTreeEntries.add(this.makeEntry(node, depth));
        }

        private CallTreeOutputEntry makeEntry(ProfilerNode<CPUSampler.Payload> node, int depth) {
            this.maxNameLength = Math.max(this.maxNameLength, node.getRootName().length() + OutputEntry.computeIndentSize(depth));
            this.tiers.add(node.getPayload().getNumberOfTiers() - 1);
            CallTreeOutputEntry entry = new CallTreeOutputEntry(node);
            for (ProfilerNode<CPUSampler.Payload> child : node.getChildren()) {
                entry.children.add(this.makeEntry(child, depth + 1));
            }
            return entry;
        }

        void print(PrintStream out) {
            String sep = ProfilerCLI.repeat("-", this.title.length());
            out.println(sep);
            CPUSamplerCLI.printLegend(out, "Call Tree", this.samplesTaken, this.samplePeriod, this.samplesMissed, this.showTiers, this.sortedTiers);
            out.println(sep);
            out.println(this.title);
            out.println(sep);
            for (Map.Entry<Thread, Collection<CallTreeOutputEntry>> threadData : this.entries.entrySet()) {
                for (CallTreeOutputEntry entry : threadData.getValue()) {
                    this.recursivePrint(out, entry, 0);
                }
            }
            out.println(sep);
        }

        private void recursivePrint(PrintStream out, CallTreeOutputEntry entry, int depth) {
            if (this.minSamples > 0 && entry.totalSelfSamples < this.minSamples) {
                return;
            }
            out.println(entry.format(this.format, this.showTiers, this.samplePeriod, depth, this.samplesTaken, this.sortedTiers));
            ArrayList<CallTreeOutputEntry> sortedChildren = new ArrayList<CallTreeOutputEntry>(entry.children);
            sortedChildren.sort((o1, o2) -> Long.compare(o2.totalSamples, o1.totalSamples));
            for (CallTreeOutputEntry child : sortedChildren) {
                this.recursivePrint(out, child, depth + 1);
            }
        }

        private static class CallTreeOutputEntry
        extends OutputEntry {
            List<CallTreeOutputEntry> children = new ArrayList<CallTreeOutputEntry>();

            CallTreeOutputEntry(ProfilerNode<CPUSampler.Payload> node) {
                super(node);
            }

            boolean corresponds(ProfilerNode<CPUSampler.Payload> node) {
                return this.location.getSourceSection().equals((Object)node.getSourceSection()) && this.location.getRootName().equals(node.getRootName());
            }

            void merge(CPUSampler.Payload payload) {
                int i;
                this.totalSamples += payload.getHitCount();
                this.totalSelfSamples += payload.getSelfHitCount();
                if (payload.getNumberOfTiers() > this.tierToSamples.length) {
                    this.tierToSamples = Arrays.copyOf(this.tierToSamples, payload.getNumberOfTiers());
                }
                for (i = 0; i < payload.getNumberOfTiers(); ++i) {
                    int n = i;
                    this.tierToSamples[n] = this.tierToSamples[n] + payload.getTierTotalCount(i);
                }
                if (payload.getNumberOfTiers() > this.tierToSelfSamples.length) {
                    this.tierToSelfSamples = Arrays.copyOf(this.tierToSelfSamples, payload.getNumberOfTiers());
                }
                for (i = 0; i < payload.getNumberOfTiers(); ++i) {
                    int n = i;
                    this.tierToSamples[n] = this.tierToSamples[n] + payload.getTierTotalCount(i);
                }
            }
        }
    }

    private static final class SamplingHistogram {
        private final Map<Thread, List<OutputEntry>> histogram = new HashMap<Thread, List<OutputEntry>>();
        private final boolean summariseThreads;
        private final int minSamples;
        private final int[] showTiers;
        private final long samplePeriod;
        private final long samplesTaken;
        private final long samplesMissed;
        private Set<Integer> tiers = new HashSet<Integer>();
        private Integer[] sortedTiers;
        private int maxNameLength = 10;
        private final String title;
        private final String format;

        SamplingHistogram(CPUSamplerData data, OptionValues options) {
            this.summariseThreads = (Boolean)options.get(SUMMARISE_THREADS);
            this.minSamples = (Integer)options.get(MIN_SAMPLES);
            this.showTiers = (int[])options.get(ShowTiers);
            this.samplePeriod = (Long)options.get(SAMPLE_PERIOD);
            this.samplesTaken = data.getSamples();
            HashMap<Thread, SourceLocationNodes> perThreadSourceLocationPayloads = new HashMap<Thread, SourceLocationNodes>();
            this.samplesMissed = data.missedSamples();
            for (Thread thread : data.getThreadData().keySet()) {
                perThreadSourceLocationPayloads.put(thread, SamplingHistogram.computeSourceLocationPayloads(data.getThreadData().get(thread)));
            }
            this.maybeSummarizeThreads(perThreadSourceLocationPayloads);
            for (Map.Entry entry : perThreadSourceLocationPayloads.entrySet()) {
                this.histogram.put((Thread)entry.getKey(), this.histogramEntries(entry));
            }
            this.sortedTiers = CPUSamplerCLI.sortedArray(this.tiers);
            String[] titleAndFormat = CPUSamplerCLI.makeTitleAndFormat(this.maxNameLength, this.showTiers, this.sortedTiers);
            this.title = titleAndFormat[0];
            this.format = titleAndFormat[1];
        }

        private ArrayList<OutputEntry> histogramEntries(Map.Entry<Thread, SourceLocationNodes> threadEntry) {
            ArrayList<OutputEntry> histogramEntries = new ArrayList<OutputEntry>();
            for (Map.Entry<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> sourceLocationEntry : threadEntry.getValue().locations.entrySet()) {
                histogramEntries.add(this.histogramEntry(sourceLocationEntry));
            }
            histogramEntries.sort((o1, o2) -> Integer.compare(o2.totalSelfSamples, o1.totalSelfSamples));
            return histogramEntries;
        }

        private OutputEntry histogramEntry(Map.Entry<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> sourceLocationEntry) {
            ProfilerCLI.SourceLocation location = sourceLocationEntry.getKey();
            OutputEntry outputEntry = new OutputEntry(location);
            this.maxNameLength = Math.max(this.maxNameLength, location.getRootName().length());
            for (ProfilerNode<CPUSampler.Payload> node : sourceLocationEntry.getValue()) {
                CPUSampler.Payload payload = node.getPayload();
                int numberOfTiers = payload.getNumberOfTiers();
                if (outputEntry.tierToSelfSamples.length < numberOfTiers) {
                    outputEntry.tierToSelfSamples = Arrays.copyOf(outputEntry.tierToSelfSamples, numberOfTiers);
                }
                if (outputEntry.tierToSamples.length < numberOfTiers) {
                    outputEntry.tierToSamples = Arrays.copyOf(outputEntry.tierToSamples, numberOfTiers);
                }
                for (int i = 0; i < numberOfTiers; ++i) {
                    int selfHitCountsValue = payload.getTierSelfCount(i);
                    outputEntry.totalSelfSamples += selfHitCountsValue;
                    int n = i;
                    outputEntry.tierToSelfSamples[n] = outputEntry.tierToSelfSamples[n] + selfHitCountsValue;
                    this.tiers.add(i);
                    if (node.isRecursive()) continue;
                    int hitCountsValue = payload.getTierTotalCount(i);
                    outputEntry.totalSamples += hitCountsValue;
                    int n2 = i;
                    outputEntry.tierToSamples[n2] = outputEntry.tierToSamples[n2] + hitCountsValue;
                }
            }
            return outputEntry;
        }

        private void maybeSummarizeThreads(Map<Thread, SourceLocationNodes> perThreadSourceLocationPayloads) {
            if (this.summariseThreads) {
                SourceLocationNodes summary = new SourceLocationNodes(new HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>>());
                for (SourceLocationNodes sourceLocationNodes : perThreadSourceLocationPayloads.values()) {
                    for (Map.Entry<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> entry : sourceLocationNodes.locations.entrySet()) {
                        summary.locations.computeIfAbsent(entry.getKey(), s -> new ArrayList()).addAll((Collection)entry.getValue());
                    }
                }
                perThreadSourceLocationPayloads.clear();
                perThreadSourceLocationPayloads.put(new Thread("Summary"), summary);
            }
        }

        private static SourceLocationNodes computeSourceLocationPayloads(Collection<ProfilerNode<CPUSampler.Payload>> profilerNodes) {
            HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> histogram = new HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>>();
            SamplingHistogram.computeSourceLocationPayloadsImpl(profilerNodes, histogram);
            return new SourceLocationNodes(histogram);
        }

        private static void computeSourceLocationPayloadsImpl(Collection<ProfilerNode<CPUSampler.Payload>> children, Map<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> histogram) {
            for (ProfilerNode<CPUSampler.Payload> treeNode : children) {
                List nodes = histogram.computeIfAbsent(new ProfilerCLI.SourceLocation(treeNode.getSourceSection(), treeNode.getRootName()), s -> new ArrayList());
                nodes.add(treeNode);
                SamplingHistogram.computeSourceLocationPayloadsImpl(treeNode.getChildren(), histogram);
            }
        }

        void print(PrintStream out) {
            String sep = ProfilerCLI.repeat("-", this.title.length());
            out.println(sep);
            CPUSamplerCLI.printLegend(out, "Histogram", this.samplesTaken, this.samplePeriod, this.samplesMissed, this.showTiers, this.sortedTiers);
            out.println(sep);
            for (Map.Entry<Thread, List<OutputEntry>> threadListEntry : this.histogram.entrySet()) {
                out.println(threadListEntry.getKey());
                out.println(this.title);
                out.println(sep);
                for (OutputEntry entry : threadListEntry.getValue()) {
                    if (this.minSamples > 0 && entry.totalSelfSamples < this.minSamples) continue;
                    out.println(entry.format(this.format, this.showTiers, this.samplePeriod, 0, this.samplesTaken, this.sortedTiers));
                }
                out.println(sep);
            }
        }

        private static final class SourceLocationNodes {
            final Map<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> locations;

            SourceLocationNodes(Map<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> locations) {
                this.locations = locations;
            }
        }
    }

    private static class OutputEntry {
        private static final int DEPTH_BREAK = 128;
        final ProfilerCLI.SourceLocation location;
        int[] tierToSamples = new int[0];
        int[] tierToSelfSamples = new int[0];
        int totalSelfSamples = 0;
        int totalSamples = 0;

        OutputEntry(ProfilerCLI.SourceLocation location) {
            this.location = location;
        }

        OutputEntry(ProfilerNode<CPUSampler.Payload> node) {
            int i;
            this.location = new ProfilerCLI.SourceLocation(node.getSourceSection(), node.getRootName());
            CPUSampler.Payload payload = node.getPayload();
            this.totalSamples = payload.getHitCount();
            this.totalSelfSamples = payload.getSelfHitCount();
            this.tierToSamples = new int[payload.getNumberOfTiers()];
            for (i = 0; i < this.tierToSamples.length; ++i) {
                this.tierToSamples[i] = payload.getTierTotalCount(i);
            }
            this.tierToSelfSamples = new int[payload.getNumberOfTiers()];
            for (i = 0; i < this.tierToSamples.length; ++i) {
                this.tierToSelfSamples[i] = payload.getTierSelfCount(i);
            }
        }

        static int computeIndentSize(int depth) {
            int indent = depth % 128;
            if (indent != depth) {
                indent += OutputEntry.formatIndentBreakLabel(depth - indent).length();
            }
            return indent;
        }

        private static String formatIndentBreakLabel(int skippedDepth) {
            return CPUSamplerCLI.format("(\u21b3%s) ", skippedDepth);
        }

        String format(String format, int[] showTiers, long samplePeriod, int depth, long globalTotalSamples, Integer[] tiers) {
            ArrayList<Object> args = new ArrayList<Object>();
            int indent = depth % 128;
            if (indent != depth) {
                args.add(OutputEntry.formatIndentBreakLabel(depth - indent) + ProfilerCLI.repeat(" ", indent) + this.location.getRootName());
            } else {
                args.add(ProfilerCLI.repeat(" ", indent) + this.location.getRootName());
            }
            args.add((long)this.totalSamples * samplePeriod);
            args.add(CPUSamplerCLI.percent(this.totalSamples, globalTotalSamples));
            OutputEntry.maybeAddTiers(args, this.tierToSamples, this.totalSamples, showTiers, tiers);
            args.add((long)this.totalSelfSamples * samplePeriod);
            args.add(CPUSamplerCLI.percent(this.totalSelfSamples, globalTotalSamples));
            OutputEntry.maybeAddTiers(args, this.tierToSelfSamples, this.totalSelfSamples, showTiers, tiers);
            args.add(ProfilerCLI.getShortDescription(this.location.getSourceSection()));
            return CPUSamplerCLI.format(format, args.toArray());
        }

        private static void maybeAddTiers(List<Object> args, int[] samples, int total, int[] showTiers, Integer[] tiers) {
            if (showTiers == null) {
                return;
            }
            if (showTiers.length == 0) {
                Integer[] integerArray = tiers;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = integerArray[i];
                    if (i2 < samples.length) {
                        args.add(CPUSamplerCLI.percent(samples[i2], total));
                        continue;
                    }
                    args.add(0.0);
                }
                return;
            }
            for (int showTier : showTiers) {
                if (!CPUSamplerCLI.contains(tiers, showTier)) continue;
                if (showTier < samples.length) {
                    args.add(CPUSamplerCLI.percent(samples[showTier], total));
                    continue;
                }
                args.add(0.0);
            }
        }
    }
}

