/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.NodeFieldData;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.parser.TemplateMethodParser;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public abstract class NodeMethodParser<E extends TemplateMethod>
extends TemplateMethodParser<NodeData, E> {
    public NodeMethodParser(ProcessorContext context, NodeData node) {
        super(context, node);
    }

    public NodeData getNode() {
        return (NodeData)this.template;
    }

    protected ParameterSpec createValueParameterSpec(NodeExecutionData execution) {
        ParameterSpec spec = new ParameterSpec(execution.getName(), this.getPossibleParameterTypes(execution));
        spec.setExecution(execution);
        return spec;
    }

    protected Collection<TypeMirror> getPossibleParameterTypes(NodeExecutionData execution) {
        return this.getNode().getGenericTypes(execution);
    }

    protected ParameterSpec createReturnParameterSpec() {
        ParameterSpec returnValue = new ParameterSpec("returnValue", this.getPossibleReturnTypes());
        returnValue.setExecution(this.getNode().getThisExecution());
        return returnValue;
    }

    protected Collection<TypeMirror> getPossibleReturnTypes() {
        return Arrays.asList(this.getNode().getGenericType(this.getNode().getThisExecution()));
    }

    @Override
    public boolean isParsable(ExecutableElement method) {
        if (this.getAnnotationType() != null) {
            return ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.getAnnotationType()) != null;
        }
        return true;
    }

    protected final MethodSpec createDefaultMethodSpec(ExecutableElement method, AnnotationMirror mirror, boolean shortCircuitsEnabled, String shortCircuitName) {
        MethodSpec methodSpec = new MethodSpec(this.createReturnParameterSpec());
        this.addDefaultFrame(methodSpec);
        this.addDefaultFieldMethodSpec(methodSpec);
        this.addDefaultChildren(shortCircuitName, methodSpec);
        return methodSpec;
    }

    private void addDefaultChildren(String breakName, MethodSpec spec) {
        if (this.getNode().getChildren() == null) {
            return;
        }
        for (NodeExecutionData execution : this.getNode().getChildExecutions()) {
            if (breakName != null && execution.getIndexedName().equals(breakName)) break;
            ParameterSpec valueSpecification = this.createValueParameterSpec(execution);
            if (execution.getIndex() == 0 && this.getNode().isGenerateInline()) {
                spec.addOptional(valueSpecification);
                continue;
            }
            spec.addRequired(valueSpecification);
        }
    }

    protected void addDefaultFrame(MethodSpec methodSpec) {
        if (this.getNode().supportsFrame()) {
            methodSpec.addOptional(new ParameterSpec("frame", this.getNode().getFrameType()));
        }
    }

    protected void addDefaultFieldMethodSpec(MethodSpec methodSpec) {
        for (NodeFieldData field : this.getNode().getFields()) {
            if (field.getGetter() != null) continue;
            ParameterSpec spec = new ParameterSpec(field.getName(), field.getType());
            spec.setLocal(true);
            methodSpec.addOptional(spec);
        }
    }
}

