/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.SuppressFBWarnings;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.remote.FileDownloader;

public interface MetadataLoader
extends Closeable {
    public ComponentInfo getComponentInfo();

    public List<InstallerStopException> getErrors();

    public Archive getArchive() throws IOException;

    public String getLicenseType();

    public String getLicenseID();

    public String getLicensePath();

    public MetadataLoader infoOnly(boolean var1);

    public boolean isNoVerifySymlinks();

    public void loadPaths() throws IOException;

    public Map<String, String> loadPermissions() throws IOException;

    public Map<String, String> loadSymlinks() throws IOException;

    public void setNoVerifySymlinks(boolean var1);

    public ComponentInfo completeMetadata() throws IOException;

    default public FileDownloader configureRelatedDownloader(FileDownloader dn) {
        return dn;
    }

    default public Date isLicenseAccepted(ComponentInfo info, String licenseID) {
        return null;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="The return value is a tri-state, indicates a success, denial, or default.")
    default public Boolean recordLicenseAccepted(ComponentInfo info, String licenseID, String licenseText, Date d) throws IOException {
        return null;
    }
}

