/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.os;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.graalvm.component.installer.FileOperations;

public class WindowsFileOperations
extends FileOperations {
    private Path delayDeletedList;
    private Path copyContents;
    private Map<Path, Path> copiedPaths = new HashMap<Path, Path>();
    private NavigableSet<Path> delayDeletedPaths = new TreeSet<Path>();

    public void setDelayDeletedList(Path delayDeletedList) {
        this.delayDeletedList = delayDeletedList;
    }

    public void setCopyContents(Path copyContents) {
        this.copyContents = copyContents;
    }

    public Map<Path, Path> getCopiedPaths() {
        return this.copiedPaths;
    }

    public Set<Path> getDelayDeletedPaths() {
        return this.delayDeletedPaths;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean doWithPermissions(Path p, Callable<Void> action) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean flush() throws IOException {
        ArrayList<Object> lines;
        boolean r = false;
        if (this.copyContents != null) {
            lines = new ArrayList<Object>(this.copiedPaths.size());
            for (Map.Entry entry : this.copiedPaths.entrySet()) {
                Path orig = (Path)entry.getKey();
                if (!Files.exists(orig, new LinkOption[0])) continue;
                String s = orig.toAbsolutePath().toString() + "|" + ((Path)entry.getValue()).toAbsolutePath().toString();
                lines.add(s);
                this.delayDeletedPaths.remove(orig);
            }
            if (!lines.isEmpty()) {
                r = true;
            }
            Files.write(this.copyContents, lines, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.delayDeletedList != null) {
            lines = new ArrayList(this.delayDeletedPaths.size());
            for (Path path : this.delayDeletedPaths) {
                lines.add(path.toAbsolutePath().toString());
            }
            if (!lines.isEmpty()) {
                r = true;
            }
            Files.write(this.delayDeletedList, lines, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        return r;
    }

    @Override
    protected void handleUndeletableFile(IOException ex, Path p) throws IOException {
        if (this.delayDeletedList == null) {
            super.handleUndeletableFile(ex, p);
            return;
        }
        this.delayDeletedPaths.add(p);
        this.feedback().output("FILE_CannotDeleteFileTryDelayed", p, ex.getLocalizedMessage());
    }

    @Override
    protected Path handleUnmodifiableFile(IOException ex, Path p, InputStream content) throws IOException {
        if (this.copyContents == null) {
            return super.handleUnmodifiableFile(ex, p, content);
        }
        Path fn = p.getFileName();
        Path parentDir = p.getParent();
        assert (parentDir != null);
        assert (fn != null);
        Path pn = parentDir.getFileName();
        assert (pn != null);
        Path copy = parentDir.resolveSibling(pn.toString() + ".new");
        this.copiedPaths.put(parentDir, copy);
        this.feedback().output("FILE_CannotInstallFileTryDelayed", p, ex.getLocalizedMessage());
        Files.createDirectories(copy, new FileAttribute[0]);
        Path target = copy.resolve(fn);
        Files.copy(content, target, StandardCopyOption.REPLACE_EXISTING);
        return target;
    }

    @Override
    public Path materialize(Path p, boolean write) {
        if (this.copyContents == null || this.delayDeletedList == null) {
            return super.materialize(p, write);
        }
        Path parentDir = p.getParent();
        Path copy = this.copiedPaths.get(parentDir);
        Path fn = p.getFileName();
        assert (fn != null);
        assert (parentDir != null);
        if (copy != null) {
            Path r = copy.resolve(fn);
            return r;
        }
        if (this.delayDeletedPaths.contains(p)) {
            if (write) {
                Path pn = parentDir.getFileName();
                assert (pn != null);
                copy = parentDir.resolveSibling(pn.toString() + ".new");
                this.copiedPaths.put(parentDir, copy);
                return copy.resolve(fn);
            }
            return null;
        }
        return p;
    }

    @Override
    public void setPermissions(Path target, Set<PosixFilePermission> perms) throws IOException {
    }

    @Override
    protected void performDelete(Path p) throws IOException {
        Path next = this.delayDeletedPaths.ceiling(p);
        if (next != null && next.startsWith(p)) {
            this.feedback().output("FILE_CannotDeleteParentTryDelayed", p);
        } else {
            super.performDelete(p);
        }
    }
}

