/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.gds.MailStorage;
import org.graalvm.component.installer.gds.rest.GDSRESTConnector;

public class GDSTokenStorage {
    static final String GRAAL_EE_DOWNLOAD_TOKEN = "GRAAL_EE_DOWNLOAD_TOKEN";
    private final Feedback feedback;
    private final CommandInput input;
    private final Path propertiesPath;
    private Source tokenSource = Source.NON;
    private Properties properties;
    private boolean changed;

    public GDSTokenStorage(Feedback feedback, CommandInput input) {
        this.feedback = feedback.withBundle(GDSTokenStorage.class);
        this.input = input;
        this.propertiesPath = Path.of(System.getProperty("user.home"), ".gu", "config");
    }

    Path getPropertiesPath() {
        return this.propertiesPath;
    }

    public Source getConfSource() {
        return this.tokenSource;
    }

    private Properties load() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = this.load(this.getPropertiesPath());
        return this.properties;
    }

    private Properties load(Path propsPath) {
        Properties props = new Properties();
        if (Files.exists(propsPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(propsPath, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException | IllegalArgumentException ex) {
                this.feedback.error("ERR_CouldNotLoadToken", ex, propsPath, ex.getLocalizedMessage());
            }
        }
        return props;
    }

    public String getToken() {
        String token = this.getCmdToken();
        if (SystemUtils.nonBlankString(token)) {
            this.tokenSource = Source.CMD;
            return token;
        }
        token = this.getEnvToken();
        if (SystemUtils.nonBlankString(token)) {
            this.tokenSource = Source.ENV;
            return token;
        }
        token = this.getFileToken();
        if (SystemUtils.nonBlankString(token)) {
            this.tokenSource = Source.FIL;
            return token;
        }
        this.tokenSource = Source.NON;
        return null;
    }

    private String getCmdToken() {
        String userFile = this.getCmdFile();
        if (!SystemUtils.nonBlankString(userFile)) {
            return null;
        }
        return this.load(SystemUtils.fromUserString(userFile)).getProperty(GRAAL_EE_DOWNLOAD_TOKEN);
    }

    private String getCmdFile() {
        return this.input.optValue(";");
    }

    private String getEnvToken() {
        return this.input.getParameter(GRAAL_EE_DOWNLOAD_TOKEN, false);
    }

    private String getFileToken() {
        return this.load().getProperty(GRAAL_EE_DOWNLOAD_TOKEN);
    }

    public void setToken(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Download token cannot be null.");
        }
        String p = this.getFileToken();
        if (token.equals(p)) {
            return;
        }
        this.properties.setProperty(GRAAL_EE_DOWNLOAD_TOKEN, token);
        this.changed = true;
    }

    public void save() throws IOException {
        File file;
        Path propsPath = this.getPropertiesPath();
        if (!this.changed || this.properties == null || propsPath == null) {
            return;
        }
        Path parent = propsPath.getParent();
        if (parent == null) {
            return;
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        if (SystemUtils.isWindows()) {
            file = parent.toFile();
            file.setReadable(false, false);
            file.setExecutable(false, false);
            file.setWritable(false, false);
            file.setReadable(true);
            file.setExecutable(true);
            file.setWritable(true);
        } else {
            Files.setPosixFilePermissions(parent, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
        }
        try (OutputStream os = Files.newOutputStream(propsPath, new OpenOption[0]);){
            this.properties.store(os, null);
        }
        if (SystemUtils.isWindows()) {
            file = propsPath.toFile();
            file.setReadable(false, false);
            file.setExecutable(false, false);
            file.setWritable(false, false);
            file.setReadable(true);
            file.setWritable(true);
        } else {
            Files.setPosixFilePermissions(propsPath, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        }
        this.changed = false;
    }

    public static void printToken(Feedback feedback, CommandInput input) {
        new GDSTokenStorage(feedback, input).printToken();
    }

    public static void revokeToken(Feedback feedback, CommandInput input, String token) {
        new GDSTokenStorage(feedback, input).revokeToken(token);
    }

    public static void revokeAllTokens(Feedback feedback, CommandInput input, String email) {
        new GDSTokenStorage(feedback, input).revokeAllTokens(email);
    }

    public void revokeAllTokens(String email) {
        GDSRESTConnector connector = this.makeConnector();
        if (connector == null) {
            this.feedback.message("MSG_NoGDSAddress", new Object[0]);
            return;
        }
        String m = MailStorage.checkEmailAddress(email, this.feedback);
        if (m == null || m.isEmpty()) {
            this.feedback.message("MSG_NoEmail", new Object[0]);
            return;
        }
        connector.revokeTokens(m);
        this.feedback.message("MSG_AcceptRevoke", new Object[0]);
    }

    public void revokeToken(String token) {
        GDSRESTConnector connector = this.makeConnector();
        if (connector == null) {
            this.feedback.message("MSG_NoGDSAddress", new Object[0]);
            return;
        }
        String t = token;
        if (t == null || t.isEmpty()) {
            t = this.getFileToken();
            if (t == null || t.isEmpty()) {
                this.feedback.message("MSG_NoRevokableToken", new Object[0]);
                return;
            }
            this.removeFileToken();
        }
        connector.revokeToken(t);
        this.feedback.message("MSG_AcceptRevoke", new Object[0]);
    }

    GDSRESTConnector makeConnector() {
        Map<String, String> caps = this.input.getLocalRegistry().getGraalCapabilities();
        String releaseCatalog = caps.get("component_catalog");
        if (releaseCatalog == null || releaseCatalog.isEmpty()) {
            return null;
        }
        String[] catalogs = releaseCatalog.split("\\|");
        Object catalog = null;
        for (String c : catalogs) {
            if (!c.contains("rest://")) continue;
            catalog = "https" + c.substring(c.indexOf("rest://") + 4);
        }
        if (catalog == null || ((String)catalog).isEmpty()) {
            return null;
        }
        return new GDSRESTConnector((String)catalog, this.feedback, caps.get("gds_product_id"), this.input.getLocalRegistry().getGraalVersion());
    }

    public void removeFileToken() {
        this.load().remove(GRAAL_EE_DOWNLOAD_TOKEN);
        this.changed = true;
        try {
            this.save();
        }
        catch (IOException ex) {
            this.feedback.error("ERR_CouldNotRemoveToken", ex, new Object[0]);
        }
    }

    public void printToken() {
        String token = this.getToken();
        String msg = this.tokenSource == Source.NON ? "MSG_EmptyToken" : "MSG_PrintToken";
        String source = "";
        switch (this.tokenSource) {
            case ENV: {
                source = this.feedback.l10n("MSG_PrintTokenEnv", GRAAL_EE_DOWNLOAD_TOKEN);
                break;
            }
            case CMD: {
                source = this.feedback.l10n("MSG_PrintTokenCmdFile", this.getCmdFile());
                break;
            }
            case FIL: {
                source = this.feedback.l10n("MSG_PrintTokenFile", this.getPropertiesPath().toString());
                break;
            }
        }
        this.feedback.output(msg, token, source);
    }

    public static enum Source {
        NON,
        ENV,
        CMD,
        FIL;

    }
}

