/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.regex.Pattern;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentRegistry;

public class MailStorage {
    static final Path PROPERTIES_PATH = SystemUtils.fromCommonRelative("lib/installer/components/gds/gds.properties");
    static final String PROP_LAST_EMAIL = "last.email";
    private final ComponentRegistry localRegistry;
    private final Feedback feedback;
    private Properties properties;
    private Path propertiesPath;
    private Path storagePath;
    private boolean changed;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");

    public MailStorage(ComponentRegistry localRegistry, Feedback feedback) {
        this.localRegistry = localRegistry;
        this.feedback = feedback;
    }

    public void setStorage(Path storage) {
        this.storagePath = storage;
        this.propertiesPath = this.storagePath.resolve(PROPERTIES_PATH);
    }

    private Properties load() {
        this.localRegistry.getManagementStorage();
        if (this.properties != null) {
            return this.properties;
        }
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.properties = new Properties();
        } else {
            try (InputStream is = Files.newInputStream(this.propertiesPath, new OpenOption[0]);){
                Properties read = new Properties();
                read.load(is);
                this.properties = read;
            }
            catch (IOException ex) {
                this.feedback.error("ERR_CouldNotLoadGDS", ex, this.propertiesPath, ex.getLocalizedMessage());
                this.properties = new Properties();
            }
        }
        return this.properties;
    }

    public String getEmailAddress() {
        this.load();
        return this.properties.getProperty(PROP_LAST_EMAIL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEmailAddress(String mailAddress) {
        Properties props = this.load();
        if (mailAddress == null) {
            if (!props.containsKey(PROP_LAST_EMAIL)) return;
            props.remove(PROP_LAST_EMAIL);
            this.changed = true;
        } else {
            String p = this.getEmailAddress();
            if (mailAddress.equals(p)) {
                return;
            }
            props.setProperty(PROP_LAST_EMAIL, mailAddress);
        }
        this.changed = true;
    }

    public void save() throws IOException {
        if (!this.changed || this.properties == null || this.propertiesPath == null) {
            return;
        }
        Path parent = this.propertiesPath.getParent();
        if (parent == null) {
            return;
        }
        Files.createDirectories(this.propertiesPath.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(this.propertiesPath, new OpenOption[0]);){
            this.properties.store(os, null);
        }
    }

    public static String checkEmailAddress(String mail, Feedback fb) {
        if (mail == null) {
            return null;
        }
        String m = mail.trim();
        if ("".equals(m)) {
            return null;
        }
        if (!EMAIL_PATTERN.matcher(m).matches()) {
            throw fb.failure("ERR_EmailNotValid", null, m);
        }
        return mail;
    }
}

