/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.remote.FileDownloader;

public abstract class GraalChannelBase
implements SoftwareChannel,
ComponentCatalog.DownloadInterceptor {
    protected final ComponentRegistry localRegistry;
    protected final CommandInput input;
    protected final Feedback fb;
    private URL indexURL;
    private final Delayed delayedStorage = new Delayed();
    protected ComponentStorage storage;
    protected String edition;
    private boolean allowUpdates = false;

    public GraalChannelBase(CommandInput aInput, Feedback aFeedback, ComponentRegistry aRegistry) {
        if (aInput == null) {
            throw new IllegalArgumentException("CommandInput cannot be null.");
        }
        this.input = aInput;
        if (aFeedback == null) {
            throw new IllegalArgumentException("Feedback cannot be null.");
        }
        this.fb = aFeedback;
        if (aRegistry == null) {
            throw new IllegalArgumentException("ComponentRegistry cannot be null.");
        }
        this.localRegistry = aRegistry;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public boolean isAllowUpdates() {
        return this.allowUpdates;
    }

    public void setAllowUpdates(boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
    }

    public URL getIndexURL() {
        return this.indexURL;
    }

    public final void setIndexURL(URL releasesIndexURL) {
        this.indexURL = releasesIndexURL;
    }

    @Override
    public ComponentStorage getStorage() throws IOException {
        return this.delayedStorage;
    }

    protected ComponentStorage throwEmptyStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        Map<String, String> caps = this.localRegistry.getGraalCapabilities();
        String os = caps.get("os_name");
        String arch = caps.get("os_arch");
        this.storage = new NullStorage();
        throw new IncompatibleException(this.fb.l10n("OLDS_IncompatibleRelease", SystemUtils.normalizeOSName(os, arch), SystemUtils.normalizeArchitecture(os, arch), this.localRegistry.getJavaVersion()));
    }

    protected boolean acceptsVersion(Version graalVersion, Version vers) {
        int c = graalVersion.installVersion().compareTo(vers.installVersion());
        return this.isAllowUpdates() ? c <= 0 : c == 0;
    }

    protected abstract ComponentStorage loadStorage() throws IOException;

    @Override
    public FileDownloader processDownloader(ComponentInfo info, FileDownloader dn) {
        return this.configureDownloader(info, dn);
    }

    class Delayed
    implements ComponentStorage {
        Delayed() {
        }

        private ComponentStorage init() throws IOException {
            if (GraalChannelBase.this.storage == null) {
                GraalChannelBase.this.allowUpdates = GraalChannelBase.this.input.getRegistry().isAllowDistUpdate();
                GraalChannelBase.this.storage = GraalChannelBase.this.loadStorage();
            }
            return GraalChannelBase.this.storage;
        }

        @Override
        public Set<String> listComponentIDs() throws IOException {
            return this.init().listComponentIDs();
        }

        @Override
        public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
            return this.init().loadComponentFiles(ci);
        }

        @Override
        public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
            return this.init().loadComponentMetadata(id);
        }

        @Override
        public Map<String, String> loadGraalVersionInfo() {
            return Collections.emptyMap();
        }
    }

    static final class NullStorage
    implements ComponentStorage {
        NullStorage() {
        }

        @Override
        public Set<String> listComponentIDs() throws IOException {
            return Collections.emptySet();
        }

        @Override
        public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
            return null;
        }

        @Override
        public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
            return Collections.emptySet();
        }

        @Override
        public Map<String, String> loadGraalVersionInfo() {
            return Collections.emptyMap();
        }
    }
}

