/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.commands.Uninstaller;
import org.graalvm.component.installer.model.CatalogContents;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.DistributionType;

public class UninstallCommand
implements InstallerCommand {
    static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private final Map<String, ComponentInfo> toUninstall = new LinkedHashMap<String, ComponentInfo>();
    private List<ComponentInfo> uninstallSequence = new ArrayList<ComponentInfo>();
    private Feedback feedback;
    private CommandInput input;
    private boolean ignoreFailures;
    private ComponentRegistry registry;
    private boolean removeDependent;
    private boolean breakDependent;
    private Map<ComponentInfo, Collection<ComponentInfo>> brokenDependencies = new HashMap<ComponentInfo, Collection<ComponentInfo>>();

    @Override
    public Map<String, String> supportedOptions() {
        return OPTIONS;
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.input = commandInput;
        this.feedback = feedBack;
        this.registry = this.input.getLocalRegistry();
        this.setIgnoreFailures(this.input.optValue("f") != null);
        this.setBreakDependent(this.input.optValue("f") != null);
        this.setRemoveDependent(this.input.optValue("D") != null);
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean isRemoveDependent() {
        return this.removeDependent;
    }

    public void setRemoveDependent(boolean removeDependent) {
        this.removeDependent = removeDependent;
    }

    public boolean isBreakDependent() {
        return this.breakDependent;
    }

    public void setBreakDependent(boolean breakDependent) {
        this.breakDependent = breakDependent;
    }

    public Collection<ComponentInfo> getUninstallComponents() {
        return new ArrayList<ComponentInfo>(this.toUninstall.values());
    }

    public List<ComponentInfo> getUninstallSequence() {
        return Collections.unmodifiableList(this.uninstallSequence);
    }

    public Map<ComponentInfo, Collection<ComponentInfo>> getBrokenDependencies() {
        return Collections.unmodifiableMap(this.brokenDependencies);
    }

    void prepareUninstall() {
        String compId;
        while ((compId = this.input.nextParameter()) != null) {
            if (this.toUninstall.containsKey(compId)) continue;
            ComponentInfo info = this.input.getLocalRegistry().loadSingleComponent(compId.toLowerCase(), true);
            if (info == null) {
                throw this.feedback.failure("UNINSTALL_UnknownComponentId", null, compId);
            }
            if (info.getId().equals("org.graalvm")) {
                throw this.feedback.failure("UNINSTALL_CoreComponent", null, compId);
            }
            if (info.isNativeComponent()) {
                throw this.feedback.failure("UNINSTALL_NativeComponent", null, info.getId(), info.getName());
            }
            if (info.getDistributionType() != DistributionType.OPTIONAL) {
                throw this.feedback.failure("UNINSTALL_BundledComponent", null, info.getId(), info.getName());
            }
            this.toUninstall.put(compId, info);
        }
        if (this.input.hasOption("M")) {
            return;
        }
        for (ComponentInfo u : this.toUninstall.values()) {
            Set<ComponentInfo> br = this.registry.findDependentComponents(u, true);
            if (br.isEmpty()) continue;
            this.brokenDependencies.put(u, br);
        }
    }

    void checkBrokenDependencies() {
        P printer;
        boolean warning;
        if (this.brokenDependencies.isEmpty()) {
            return;
        }
        HashSet<ComponentInfo> uninstalled = new HashSet<ComponentInfo>(this.toUninstall.values());
        Stream<ComponentInfo> stm = this.brokenDependencies.values().stream().flatMap(col -> col.stream()).filter(c -> !uninstalled.contains(c));
        if (!stm.findFirst().isPresent()) {
            return;
        }
        ArrayList<ComponentInfo> sorted = new ArrayList<ComponentInfo>(this.brokenDependencies.keySet());
        boolean bl = warning = this.removeDependent || this.breakDependent;
        if (warning) {
            printer = this.feedback::output;
            this.feedback.output(this.removeDependent ? "UNINSTALL_BrokenDependenciesRemove" : "UNINSTALL_BrokenDependenciesWarn", new Object[0]);
        } else {
            printer = (a, b) -> this.feedback.error(a, null, b);
            this.feedback.error("UNINSTALL_BrokenDependencies", null, new Object[0]);
        }
        Comparator c2 = (a, b) -> a.getId().compareToIgnoreCase(b.getId());
        Collections.sort(sorted, c2);
        for (ComponentInfo i : sorted) {
            ArrayList<ComponentInfo> deps = new ArrayList<ComponentInfo>(this.brokenDependencies.get(i));
            deps.removeAll(uninstalled);
            if (deps.isEmpty()) continue;
            Collections.sort(sorted, c2);
            if (!warning) {
                printer.print("UNINSTALL_BreakDepSource", i.getName(), i.getId());
            }
            for (ComponentInfo d : deps) {
                printer.print("UNINSTALL_BreakDepTarget", d.getName(), d.getId());
            }
        }
        if (warning) {
            return;
        }
        throw this.feedback.failure("UNINSTALL_BreakDependenciesTerminate", null, new Object[0]);
    }

    void includeAndOrderComponents() {
        HashSet allBroken = new LinkedHashSet<ComponentInfo>();
        if (!this.input.hasOption("M") && !this.breakDependent) {
            for (Collection<ComponentInfo> collection : this.brokenDependencies.values()) {
                allBroken.addAll(collection);
            }
            for (ComponentInfo componentInfo : allBroken) {
                Set<ComponentInfo> br = this.registry.findDependentComponents(componentInfo, true);
                if (br.isEmpty()) continue;
                allBroken.addAll(br);
                this.brokenDependencies.put(componentInfo, br);
            }
            if (this.removeDependent) {
                HashSet<ComponentInfo> newBroken = new HashSet<ComponentInfo>();
                for (ComponentInfo i : allBroken) {
                    ComponentInfo full = this.registry.loadSingleComponent(i.getId(), true);
                    newBroken.add(full);
                    this.toUninstall.put(i.getId(), full);
                }
                allBroken = newBroken;
            }
        }
        ArrayList<ComponentInfo> leaves = new ArrayList<ComponentInfo>(this.toUninstall.values());
        leaves.removeAll(allBroken);
        ArrayList<ComponentInfo> arrayList = new ArrayList<ComponentInfo>(this.toUninstall.size());
        arrayList.addAll(leaves);
        int top = leaves.size();
        for (ComponentInfo ci : allBroken) {
            ComponentInfo c2;
            int i;
            HashSet<ComponentInfo> check = new HashSet<ComponentInfo>();
            CatalogContents.findDependencies(ci, true, Boolean.TRUE, check, (a, b, c, d) -> this.registry.findComponentMatch(a, b, true));
            for (i = arrayList.size(); i > top && !check.contains(c2 = (ComponentInfo)arrayList.get(i - 1)); --i) {
            }
            arrayList.add(i, ci);
        }
        Collections.reverse(arrayList);
        this.uninstallSequence = arrayList;
    }

    @Override
    public int execute() throws IOException {
        this.registry.verifyAdministratorAccess();
        if (this.input.optValue("h") != null) {
            this.feedback.output("UNINSTALL_Help", new Object[0]);
            return 0;
        }
        if (!this.input.hasParameter()) {
            this.feedback.output("UNINSTALL_ParametersMissing", new Object[0]);
            return 1;
        }
        this.prepareUninstall();
        this.checkBrokenDependencies();
        this.includeAndOrderComponents();
        for (ComponentInfo info : this.uninstallSequence) {
            try {
                this.uninstallSingleComponent(info);
            }
            catch (IOException | InstallerStopException ex) {
                if (this.ignoreFailures) {
                    this.feedback.error("UNINSTALL_IgnoreFailed", ex, info.getId(), ex.getLocalizedMessage());
                    continue;
                }
                this.feedback.error("UNINSTALL_ErrorDuringProcessing", ex, info.getId());
                throw ex;
            }
        }
        return 0;
    }

    void uninstallSingleComponent(ComponentInfo info) throws IOException {
        Uninstaller inst = new Uninstaller(this.feedback, this.input.getFileOperations(), info, this.input.getLocalRegistry());
        this.configureInstaller(inst);
        this.feedback.output("UNINSTALL_UninstallingComponent", info.getId(), info.getName(), info.getVersionString());
        this.doUninstallSingle(inst);
    }

    void doUninstallSingle(Uninstaller inst) throws IOException {
        inst.uninstall();
    }

    private void configureInstaller(Uninstaller inst) {
        inst.setInstallPath(this.input.getGraalHomePath());
        inst.setDryRun(this.input.optValue("0") != null);
        inst.setIgnoreFailedDeletions(this.input.optValue("x") != null);
        inst.setPreservePaths(new HashSet<String>(this.registry.getPreservedFiles(inst.getComponentInfo())));
    }

    static {
        OPTIONS.put("0", "");
        OPTIONS.put("f", "");
        OPTIONS.put("x", "");
        OPTIONS.put("D", "");
        OPTIONS.put("M", "");
        OPTIONS.put("dry-run", "0");
        OPTIONS.put("force", "f");
        OPTIONS.put("ignore", "x");
        OPTIONS.put("remove-deps", "D");
        OPTIONS.put("no-deps", "M");
    }

    static interface P {
        public void print(String var1, Object ... var2);
    }
}

