/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.Verifier;

public abstract class AbstractInstaller
implements Closeable {
    protected final Feedback feedback;
    protected final ComponentInfo componentInfo;
    protected final ComponentRegistry registry;
    protected final ComponentCollection catalog;
    protected final Archive archive;
    protected final FileOperations fileOps;
    private Map<String, String> permissions = Collections.emptyMap();
    private Map<String, String> symlinks = Collections.emptyMap();
    private Set<String> componentDirectories = Collections.emptySet();
    private final Set<String> trackedPaths = new HashSet<String>();
    private Path licenseRelativePath;
    private boolean replaceDiferentFiles;
    private boolean replaceComponents;
    private boolean dryRun;
    private boolean ignoreRequirements;
    private boolean failOnExisting = true;
    private Path installPath;
    private boolean allowUpgrades;

    public AbstractInstaller(Feedback fb, FileOperations fops, ComponentInfo info, ComponentRegistry reg, ComponentCollection cat, Archive a) {
        this.feedback = fb;
        this.componentInfo = info;
        this.registry = reg;
        this.archive = a;
        this.catalog = cat;
        this.fileOps = fops;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public boolean isComplete() {
        return this.archive != null;
    }

    public boolean isAllowUpgrades() {
        return this.allowUpgrades;
    }

    public void setAllowUpgrades(boolean allowUpgrades) {
        this.allowUpgrades = allowUpgrades;
    }

    public boolean isFailOnExisting() {
        return this.failOnExisting;
    }

    public void setFailOnExisting(boolean failOnExisting) {
        this.failOnExisting = failOnExisting;
    }

    public boolean isReplaceDiferentFiles() {
        return this.replaceDiferentFiles;
    }

    public void setReplaceDiferentFiles(boolean replaceDiferentFiles) {
        this.replaceDiferentFiles = replaceDiferentFiles;
    }

    public boolean isReplaceComponents() {
        return this.replaceComponents;
    }

    public void setReplaceComponents(boolean replaceComponents) {
        this.replaceComponents = replaceComponents;
    }

    public boolean isIgnoreRequirements() {
        return this.ignoreRequirements;
    }

    public void setIgnoreRequirements(boolean ignoreRequirements) {
        this.ignoreRequirements = ignoreRequirements;
    }

    public ComponentInfo getComponentInfo() {
        return this.componentInfo;
    }

    public Set<String> getTrackedPaths() {
        return this.trackedPaths;
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }

    public Map<String, String> getSymlinks() {
        return this.symlinks;
    }

    public void setSymlinks(Map<String, String> symlinks) {
        this.symlinks = symlinks;
    }

    public abstract void revertInstall();

    public Verifier createVerifier() {
        return new Verifier(this.feedback, this.registry, this.catalog).ignoreRequirements(this.ignoreRequirements).replaceComponents(this.replaceComponents).ignoreExisting(!this.failOnExisting);
    }

    public Verifier validateRequirements() {
        Verifier vrf = this.createVerifier();
        return vrf.setVersionMatch(this.registry.getGraalVersion().match(Version.Match.Type.COMPATIBLE)).validateRequirements(this.componentInfo);
    }

    public abstract boolean validateAll() throws IOException;

    public abstract void validateFiles() throws IOException;

    public abstract void validateSymlinks() throws IOException;

    public abstract void processPermissions() throws IOException;

    public abstract void createSymlinks() throws IOException;

    public Path getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(Path installPath) {
        this.installPath = installPath.normalize();
    }

    public Path getLicenseRelativePath() {
        return this.licenseRelativePath;
    }

    public void setLicenseRelativePath(Path licenseRelativePath) {
        this.licenseRelativePath = licenseRelativePath;
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.close();
        }
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Set<String> getComponentDirectories() {
        return this.componentDirectories;
    }

    public void setComponentDirectories(Set<String> componentDirectories) {
        this.componentDirectories = componentDirectories;
    }

    protected void addTrackedPath(String path) {
        this.trackedPaths.add(path);
    }
}

