/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.UnknownVersionException;

public final class Version
implements Comparable<Version> {
    public static final Version NO_VERSION = new Version("0.0.0.0", false);
    private static final String WILDCARD = "*";
    private final String versionString;
    private final String normalizedString;
    private final List<String> releaseParts;
    private final List<String> versionParts;
    private final boolean wildcard;
    private final boolean user;
    public static final String EXACT_VERSION = "=";
    public static final String GREATER_VERSION = "+";
    public static final String COMPATIBLE_VERSION = "~";

    Version(String versionString, boolean fromUser) throws IllegalArgumentException {
        List<String> vp;
        this.versionString = versionString;
        boolean wc = false;
        String normalized = fromUser ? versionString : SystemUtils.normalizeOldVersions(versionString);
        int releaseDash = normalized.indexOf(45);
        if (releaseDash == -1) {
            if (fromUser) {
                wc = true;
                this.releaseParts = Collections.singletonList(WILDCARD);
            } else {
                this.releaseParts = Collections.emptyList();
            }
            vp = Version.parseParts(normalized);
        } else {
            String vS = normalized.substring(0, releaseDash);
            String rS = normalized.substring(releaseDash + 1);
            vp = Version.parseParts(vS);
            List<String> rp = Version.parseParts(rS);
            if (fromUser && !rp.isEmpty()) {
                String first = rp.get(0);
                try {
                    Integer.parseInt(first);
                }
                catch (NumberFormatException ex) {
                    rp.add(0, WILDCARD);
                    wc = true;
                }
                rp.add(WILDCARD);
            }
            this.releaseParts = Collections.unmodifiableList(rp);
        }
        if (vp.size() < 2 || vp.size() > 4 || !Character.isDigit(vp.get(0).charAt(0)) || !Character.isDigit(vp.get(1).charAt(0))) {
            throw new IllegalArgumentException("A format Year.Release[.Update[.Patch]] is required. Got: " + versionString);
        }
        if (vp.size() < 4 && !Version.isOldStyleVersion(vp.get(0))) {
            vp = new ArrayList<String>(vp);
            while (vp.size() < 4) {
                vp.add("0");
            }
            this.normalizedString = Version.print(vp, this.releaseParts);
        } else {
            this.normalizedString = normalized;
        }
        this.versionParts = vp;
        this.wildcard = wc;
        this.user = fromUser;
    }

    static boolean isOldStyleVersion(String s) {
        try {
            return Integer.parseInt(s) < 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    static String print(List<String> vParts, List<String> rParts) {
        StringBuilder sb = new StringBuilder();
        for (String vp : vParts) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(vp);
        }
        if (!rParts.isEmpty()) {
            sb.append('-');
            boolean n = false;
            for (String rp : rParts) {
                if (n) {
                    sb.append('.');
                }
                sb.append(rp);
                n = true;
            }
        }
        return sb.toString();
    }

    Version(String orig, List<String> vParts, List<String> rParts, boolean wc, boolean fromUser) {
        this.versionParts = new ArrayList<String>(vParts);
        this.releaseParts = new ArrayList<String>(rParts);
        String string = this.versionString = orig != null ? orig : Version.print(vParts, rParts);
        if (vParts.size() < 4 && Version.isOldStyleVersion(vParts.get(0))) {
            while (this.versionParts.size() < 4) {
                this.versionParts.add("0");
            }
            this.normalizedString = Version.print(this.versionParts, this.releaseParts);
        } else {
            this.normalizedString = this.versionString;
        }
        this.wildcard = wc;
        this.user = fromUser;
    }

    public Version updatable() {
        ArrayList<String> vp = new ArrayList<String>(this.versionParts);
        vp.subList(3, vp.size()).clear();
        while (vp.size() < 3) {
            vp.add("0");
        }
        return new Version(null, vp, Collections.emptyList(), false, false);
    }

    public Version onlyVersion() {
        return new Version(null, this.versionParts, Collections.emptyList(), false, false);
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.versionString);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == NO_VERSION || obj == NO_VERSION) {
            return false;
        }
        Version other = (Version)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return this.normalizedString;
    }

    public String originalString() {
        return this.versionString;
    }

    private static List<String> parseParts(String s) throws IllegalArgumentException {
        ArrayList<String> parts = new ArrayList<String>();
        int l = s.length();
        boolean digit = false;
        int lastP = -1;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                if (lastP < 0) continue;
                parts.add(s.substring(lastP, i));
                lastP = -1;
                continue;
            }
            boolean nowDigit = Character.isDigit(c);
            if (nowDigit != digit && lastP >= 0) {
                parts.add(s.substring(lastP, i));
                lastP = i;
            } else if (lastP < 0) {
                lastP = i;
            }
            digit = nowDigit;
        }
        if (lastP >= 0) {
            parts.add(s.substring(lastP));
        }
        return parts;
    }

    @Override
    public int compareTo(Version o) {
        if (o == this) {
            return 0;
        }
        if (o == NO_VERSION) {
            return 1;
        }
        if (this == NO_VERSION) {
            return -1;
        }
        if (o == null) {
            return 1;
        }
        int c = Version.compareVersionParts(this.versionParts, o.versionParts, false);
        if (c != 0) {
            return c;
        }
        return Version.compareVersionParts(this.releaseParts, o.releaseParts, true);
    }

    private static int compareVersionParts(List<String> pA, List<String> pB, boolean release) {
        Iterator<String> iA = pA.iterator();
        Iterator<String> iB = pB.iterator();
        int res = 0;
        String sA = null;
        String sB = null;
        while (res == 0 && iA.hasNext() && iB.hasNext()) {
            sA = iA.next();
            sB = iB.next();
            res = Version.compareVersionPart(sA, sB);
        }
        if (res != 0 || !iA.hasNext() && !iB.hasNext()) {
            return res;
        }
        if (iA.hasNext()) {
            if (release) {
                if (WILDCARD.equals(iA.next()) && !iA.hasNext()) {
                    return 0;
                }
                if (WILDCARD.equals(sB)) {
                    return 0;
                }
            }
            return 1;
        }
        if (iB.hasNext()) {
            if (release) {
                if (WILDCARD.equals(iB.next()) && !iB.hasNext()) {
                    return 0;
                }
                if (WILDCARD.equals(sA)) {
                    return 0;
                }
                if (pB.size() == 1 && "0".equals(pB.get(0))) {
                    return 0;
                }
            }
            return -1;
        }
        throw new IllegalStateException("Should not happen");
    }

    public static int compareVersionPart(String a, String b) {
        int l;
        boolean dB;
        if (WILDCARD.equals(a) || WILDCARD.equals(b)) {
            return 0;
        }
        if (a == null) {
            if (b != null) {
                return -1;
            }
            return 0;
        }
        if (b == null) {
            return 1;
        }
        boolean dA = Character.isDigit(a.charAt(0));
        if (dA != (dB = Character.isDigit(a.charAt(0)))) {
            return dA ? 1 : -1;
        }
        if (dA && dB && (l = a.length() - b.length()) != 0) {
            return l;
        }
        return a.compareTo(b);
    }

    public boolean hasWildcard() {
        return this.wildcard;
    }

    public Version installVersion() {
        ArrayList<String> vps = new ArrayList<String>();
        vps.add(this.versionParts.get(0));
        vps.add(this.versionParts.get(1));
        if (this.versionParts.size() > 2) {
            vps.add(this.versionParts.get(2));
        } else {
            vps.add("0");
        }
        vps.add("0");
        return new Version(null, vps, this.releaseParts, this.wildcard, this.user);
    }

    public String displayString() {
        if (this.user) {
            return this.originalString();
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> vps = new ArrayList<String>(this.versionParts);
        if (vps.size() == 4 && "0".equals(vps.get(3))) {
            vps.remove(3);
        }
        for (String vp : vps) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(vp);
        }
        if (this.releaseParts.isEmpty()) {
            return sb.toString();
        }
        String firstRel = this.releaseParts.get(0);
        ArrayList<String> printedParts = new ArrayList<String>(this.releaseParts);
        try {
            Integer.parseInt(firstRel);
            printedParts.remove(0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (printedParts.isEmpty()) {
            return sb.toString();
        }
        boolean name = false;
        boolean next = false;
        int patchChar = -1;
        sb.append("-");
        for (String s : printedParts) {
            if (s.isEmpty() || WILDCARD.equals(s)) continue;
            if (Character.isDigit(s.charAt(0))) {
                if (next && !name) {
                    sb.append(".");
                }
                if (name && patchChar != -1) {
                    sb.setCharAt(patchChar, '.');
                }
                sb.append(s);
                name = false;
                patchChar = -1;
            } else {
                patchChar = -1;
                if (name) {
                    sb.append("_");
                } else if (next) {
                    patchChar = sb.length();
                    sb.append("-");
                }
                sb.append(s);
                name = true;
            }
            next = true;
        }
        return sb.toString();
    }

    public Match match(Match.Type type) {
        return new Match(this, type);
    }

    public static Version fromString(String versionString) {
        return versionString == null ? NO_VERSION : new Version(versionString, false);
    }

    public static Version fromUserString(String userVersion) {
        return userVersion == null ? NO_VERSION : new Version(userVersion, true);
    }

    public static String idAndVersion(String idSpec, Match[] matchOut) {
        int eqIndex = idSpec.indexOf(EXACT_VERSION);
        int moreIndex = idSpec.indexOf(GREATER_VERSION);
        int compatibleIndex = idSpec.indexOf(COMPATIBLE_VERSION);
        int i = -1;
        Match.Type type = null;
        if (eqIndex > 0) {
            type = Match.Type.EXACT;
            i = eqIndex;
        } else if (moreIndex > 0) {
            type = Match.Type.INSTALLABLE;
            i = moreIndex;
        } else if (compatibleIndex > 0) {
            type = Match.Type.COMPATIBLE;
            i = compatibleIndex;
        } else {
            matchOut[0] = NO_VERSION.match(Match.Type.MOSTRECENT);
            return idSpec;
        }
        matchOut[0] = Version.fromUserString(idSpec.substring(i + 1)).match(type);
        return idSpec.substring(0, i);
    }

    public static Match versionFilter(String spec) {
        if (spec == null || spec.isEmpty()) {
            return null;
        }
        int eqIndex = spec.indexOf(EXACT_VERSION);
        int moreIndex = spec.indexOf(GREATER_VERSION);
        int compatibleIndex = spec.indexOf(COMPATIBLE_VERSION);
        int i = -1;
        Match.Type type = null;
        if (eqIndex >= 0) {
            type = Match.Type.EXACT;
            i = eqIndex;
        } else if (moreIndex >= 0) {
            type = Match.Type.INSTALLABLE;
            i = moreIndex;
        } else if (compatibleIndex >= 0) {
            type = Match.Type.COMPATIBLE;
            i = compatibleIndex;
        } else {
            if (Character.isDigit(spec.charAt(0))) {
                return Version.fromString(spec).match(Match.Type.COMPATIBLE);
            }
            return null;
        }
        return Version.fromString(spec.substring(i + 1)).match(type);
    }

    public static final class Match
    implements Predicate<Version> {
        private final Type matchType;
        private final Version version;

        Match(Version version, Type matchType) {
            this.matchType = matchType;
            this.version = version;
        }

        @Override
        public boolean test(Version t) {
            if (t == null) {
                return this.matchType != Type.EXACT;
            }
            switch (this.matchType) {
                case EXACT: {
                    return this.version.equals(t);
                }
                case GREATER: {
                    return this.version.compareTo(t) <= 0;
                }
                case INSTALLABLE: {
                    return this.version.installVersion().compareTo(t.installVersion()) <= 0;
                }
                case MOSTRECENT: {
                    throw new IllegalArgumentException();
                }
                case COMPATIBLE: {
                    return this.version.installVersion().equals(t.installVersion());
                }
                case SATISFIES_COMPATIBLE: {
                    int a = this.version.installVersion().compareTo(t.installVersion());
                    if (a != 0) {
                        return false;
                    }
                    return this.version.onlyVersion().compareTo(t.onlyVersion()) >= 0;
                }
                case SATISFIES: {
                    int a = this.version.installVersion().compareTo(t.installVersion());
                    if (a < 0) {
                        return true;
                    }
                    return this.version.onlyVersion().compareTo(t.onlyVersion()) >= 0;
                }
            }
            return false;
        }

        public Version getVersion() {
            return this.version;
        }

        public Type getType() {
            return this.matchType;
        }

        public String toString() {
            return this.matchType.toString() + "[" + String.valueOf(this.version) + "]";
        }

        public Match resolveWildcards(Collection<Version> allVersions, Feedback fb) {
            if (!this.version.hasWildcard()) {
                return this;
            }
            ArrayList<Version> ordered = new ArrayList<Version>(allVersions);
            Collections.sort(ordered);
            Version candidate = null;
            switch (this.matchType) {
                case MOSTRECENT: {
                    throw new IllegalArgumentException();
                }
                case EXACT: {
                    for (Version v : ordered) {
                        if (v.compareTo(this.version) != 0) continue;
                        if (candidate != null) {
                            throw new IllegalArgumentException();
                        }
                        candidate = v;
                    }
                    if (candidate == null) {
                        return this;
                    }
                    return new Match(candidate, this.matchType);
                }
                case GREATER: 
                case INSTALLABLE: 
                case SATISFIES_COMPATIBLE: 
                case SATISFIES: {
                    for (Version v : ordered) {
                        if (v.compareTo(this.version) < 0) continue;
                        candidate = v;
                        break;
                    }
                    if (candidate == null) {
                        return this;
                    }
                    return new Match(candidate, this.matchType);
                }
                case COMPATIBLE: {
                    Version myInst = this.version.installVersion();
                    Version myBase = myInst.onlyVersion();
                    Version report = null;
                    for (Version v : ordered) {
                        Version inst = v.installVersion();
                        if (myInst.equals(inst)) {
                            candidate = v;
                        }
                        if (!myBase.equals(inst.onlyVersion())) continue;
                        report = v;
                    }
                    if (candidate == null) {
                        String msg = report == null ? fb.withBundle(Version.class).l10n("VERSION_UnknownVersion1", this.version.displayString(), null) : fb.withBundle(Version.class).l10n("VERSION_UnknownVersion2", this.version.displayString(), report.displayString());
                        throw new UnknownVersionException(msg, this.version, report);
                    }
                    return new Match(candidate, this.matchType);
                }
            }
            throw new IllegalStateException();
        }

        public static enum Type {
            EXACT,
            INSTALLABLE,
            MOSTRECENT,
            COMPATIBLE,
            GREATER,
            SATISFIES,
            SATISFIES_COMPATIBLE;

        }
    }
}

