/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.model.ComponentRegistry;

public class SystemUtils {
    public static final char DELIMITER_CHAR = '/';
    public static final String DELIMITER = "/";
    private static final String DOT = ".";
    private static final String DOTDOT = "..";
    private static final String SPLIT_DELIMITER = Pattern.quote("/");
    private static final Pattern OLD_VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+(\\.[0-9]+)?(\\.[0-9]+)?)(-([a-z]+)([0-9]+)?)?");
    static boolean licenseTracking = false;

    public static boolean nonBlankString(String string) {
        return string != null && !string.isBlank();
    }

    public static Path fromCommonString(String p) {
        String[] comps = p.split(SPLIT_DELIMITER);
        if (comps.length == 1) {
            return Paths.get(comps[0], new String[0]);
        }
        int l = comps.length - 1;
        String s = comps[0];
        System.arraycopy(comps, 1, comps, 0, l);
        comps[l] = "";
        return Paths.get(s, comps);
    }

    public static Path fromUserString(String p) {
        return Paths.get(p, new String[0]);
    }

    public static Path fileName(String s) {
        if (s.indexOf(47) >= 0 || '/' != File.separatorChar && s.indexOf(File.separatorChar) >= 0) {
            throw new IllegalArgumentException(s);
        }
        if (DOT.equals(s) || DOTDOT.equals(s)) {
            throw new IllegalArgumentException(s);
        }
        return Paths.get(s, new String[0]);
    }

    public static String toCommonPath(Path p) {
        StringBuilder sb = new StringBuilder();
        boolean next = false;
        for (Path comp : p) {
            if (next) {
                sb.append('/');
            }
            String compS = comp.toString();
            if (File.separatorChar != '/') {
                compS = compS.replace(File.separator, DELIMITER);
            }
            sb.append(compS);
            next = true;
        }
        return sb.toString();
    }

    public static boolean isWindows() {
        return OS.get().equals((Object)OS.WINDOWS);
    }

    public static boolean isLinux() {
        return OS.get().equals((Object)OS.LINUX);
    }

    public static boolean isMac() {
        return OS.get().equals((Object)OS.MAC);
    }

    public static Path fromCommonRelative(String p) {
        if (p == null) {
            return null;
        }
        return SystemUtils.fromArray(SystemUtils.checkRelativePath(null, p));
    }

    private static Path fromArray(String[] comps) {
        if (comps.length == 1) {
            return Paths.get(comps[0], new String[0]);
        }
        int l = comps.length - 1;
        String s = comps[0];
        System.arraycopy(comps, 1, comps, 0, l);
        comps[l] = "";
        return Paths.get(s, comps);
    }

    public static Path resolveRelative(Path baseDir, String p) {
        if (baseDir == null) {
            return null;
        }
        if (p == null) {
            return null;
        }
        String[] comps = SystemUtils.checkRelativePath(baseDir, p);
        return baseDir.resolve(SystemUtils.fromArray(comps));
    }

    public static Path fromCommonRelative(Path base, String p) {
        if (p == null) {
            return null;
        }
        if (base == null) {
            return SystemUtils.fromCommonRelative(p);
        }
        String[] comps = SystemUtils.checkRelativePath(base, p);
        return base.resolveSibling(SystemUtils.fromArray(comps));
    }

    public static void checkCommonRelative(Path base, String p) {
        if (p == null) {
            return;
        }
        SystemUtils.checkRelativePath(base, p);
    }

    private static String[] checkRelativePath(Path base, String p) {
        if (p.startsWith(DELIMITER)) {
            throw new IllegalArgumentException("Absolute path");
        }
        String[] comps = p.split(SPLIT_DELIMITER);
        int d = base == null ? 0 : base.normalize().getNameCount() - 1;
        int fromIndex = 0;
        int toIndex = 0;
        for (String s : comps) {
            if (s.isEmpty()) {
                ++fromIndex;
                continue;
            }
            if (DOTDOT.equals(s)) {
                if (--d < 0) {
                    throw new IllegalArgumentException("Relative path reaches above root");
                }
            } else {
                ++d;
            }
            if (toIndex < fromIndex) {
                comps[toIndex] = comps[fromIndex];
            }
            ++fromIndex;
            ++toIndex;
        }
        if (fromIndex == toIndex) {
            return comps;
        }
        String[] newcomps = new String[toIndex];
        System.arraycopy(comps, 0, newcomps, 0, toIndex);
        return newcomps;
    }

    public static String normalizeOldVersions(String v) {
        if (v == null) {
            return null;
        }
        Matcher m = OLD_VERSION_PATTERN.matcher(v);
        if (!m.matches()) {
            return v;
        }
        Object numbers = m.group(1);
        String rel = m.group(5);
        String relNo = m.group(6);
        if (((String)numbers).startsWith("0.")) {
            return v;
        }
        if (rel == null) {
            if (m.group(3) == null) {
                return (String)numbers + ".0";
            }
            return numbers;
        }
        if (m.group(3) == null) {
            numbers = (String)numbers + ".0";
        }
        return (String)numbers + "-0." + rel + (String)(relNo == null ? "" : DOT + relNo);
    }

    public static Path getGraalVMJDKRoot(ComponentRegistry reg) {
        if (OS.MAC.equals((Object)OS.fromName(reg.getGraalCapabilities().get("os_name")))) {
            return Paths.get("Contents", "Home");
        }
        return Paths.get("", new String[0]);
    }

    public static String findFileOwner(Path file) throws IOException {
        PosixFileAttributeView posix = file.getFileSystem().provider().getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
        if (posix != null) {
            return posix.getOwner().getName();
        }
        AclFileAttributeView acl = file.getFileSystem().provider().getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
        if (acl != null) {
            return acl.getOwner().getName();
        }
        return null;
    }

    public static boolean isLicenseTrackingEnabled() {
        return licenseTracking;
    }

    public static String parseURLParameters(String s, Map<String, String> params) {
        int q = s.indexOf(63);
        if (q == -1) {
            return s;
        }
        String queryString = s.substring(q + 1);
        for (String parSpec : queryString.split("&")) {
            String[] nameAndVal = parSpec.split("=");
            String n = URLDecoder.decode(nameAndVal[0], StandardCharsets.UTF_8);
            if (n.isEmpty()) continue;
            String v = nameAndVal.length > 1 ? URLDecoder.decode(nameAndVal[1], StandardCharsets.UTF_8) : "";
            params.put(n, v);
        }
        return s.substring(0, q);
    }

    public static int getJavaMajorVersion(CommandInput cmd) {
        String v;
        String string = v = cmd.getLocalRegistry() != null ? cmd.getLocalRegistry().getJavaVersion() : null;
        if (v == null) {
            cmd.getParameter("java.specification.version", true);
        }
        if (v != null) {
            return SystemUtils.interpretJavaMajorVersion(v);
        }
        return SystemUtils.getJavaMajorVersion();
    }

    public static String buildUrlStringWithParameters(String baseURL, Map<String, ? extends Collection<String>> params) {
        if (params == null || params.isEmpty()) {
            return baseURL;
        }
        StringBuilder url = new StringBuilder(baseURL);
        url.append('?');
        for (Map.Entry<String, ? extends Collection<String>> entry : params.entrySet()) {
            Collection<String> vals = entry.getValue();
            String key = entry.getKey();
            if (key == null || key.isBlank() || vals == null || vals.isEmpty()) continue;
            for (String val : vals) {
                url.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
                url.append('=');
                url.append(URLEncoder.encode(val, StandardCharsets.UTF_8));
                url.append('&');
            }
        }
        return url.substring(0, url.length() - 1);
    }

    public static int getJavaMajorVersion() {
        return SystemUtils.interpretJavaMajorVersion(System.getProperty("java.specification.version"));
    }

    public static int interpretJavaMajorVersion(String v) {
        try {
            return Integer.parseInt(v.startsWith("1.") ? v.substring(2) : v);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return 0;
        }
    }

    public static Path getRuntimeLibDir(Path graalPath, boolean archDir) {
        Path newLibPath;
        Path base = SystemUtils.getRuntimeBaseDir(graalPath);
        switch (OS.get()) {
            case LINUX: {
                Path temp = base.resolve(Paths.get("lib", new String[0]));
                if (!archDir || SystemUtils.getJavaMajorVersion() >= 10) {
                    newLibPath = temp;
                    break;
                }
                newLibPath = temp.resolve(Paths.get(OS.sysName(), new String[0]));
                break;
            }
            case MAC: {
                newLibPath = base.resolve(Paths.get("lib", new String[0]));
                break;
            }
            case WINDOWS: {
                newLibPath = base.resolve(Paths.get("bin", new String[0]));
                break;
            }
            default: {
                return null;
            }
        }
        return newLibPath;
    }

    public static Path getRuntimeBaseDir(Path jdkInstallDir) {
        int v = SystemUtils.getJavaMajorVersion();
        if (v >= 10) {
            return jdkInstallDir;
        }
        if (v > 0) {
            return jdkInstallDir.resolve("jre");
        }
        Path jre = jdkInstallDir.resolve("jre");
        if (Files.exists(jre, new LinkOption[0]) && Files.isDirectory(jre, new LinkOption[0])) {
            return jre;
        }
        return jdkInstallDir;
    }

    public static Path copySubtree(Path from, Path to) throws IOException {
        Files.walkFileTree(from, new CopyDirVisitor(from, to));
        return to;
    }

    public static byte[] toHashBytes(String hashS) {
        int s;
        boolean lenOK;
        boolean divided;
        String val = hashS.trim();
        if (val.length() < 4) {
            return null;
        }
        char c = val.charAt(2);
        boolean bl = divided = !(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f');
        if (divided) {
            lenOK = (val.length() + 1) % 3 == 0;
            s = (val.length() + 1) / 3;
        } else {
            lenOK = val.length() % 2 == 0;
            s = (val.length() + 1) / 2;
        }
        if (!lenOK) {
            return null;
        }
        byte[] digest = new byte[s];
        int dI = 0;
        int i = 0;
        while (i + 1 < val.length()) {
            int b;
            try {
                b = Integer.parseInt(val.substring(i, i + 2), 16);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            if (b < 0) {
                return null;
            }
            digest[dI++] = (byte)b;
            if (divided) {
                ++i;
            }
            i += 2;
        }
        return digest;
    }

    public static String fingerPrint(byte[] digest) {
        return SystemUtils.fingerPrint(digest, true);
    }

    public static String fingerPrint(byte[] digest, boolean delimiter) {
        if (digest == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(digest.length * 3);
        for (int i = 0; i < digest.length; ++i) {
            if (delimiter && i > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", digest[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String digestString(String s, boolean delimiters) {
        try {
            MessageDigest dg = MessageDigest.getInstance("SHA-256");
            dg.update(s.getBytes());
            byte[] digest = dg.digest();
            return SystemUtils.fingerPrint(digest, delimiters);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FailedOperationException(ex.getLocalizedMessage(), ex);
        }
    }

    public static String patternOsName(String os, String variant) {
        if (os == null) {
            return null;
        }
        String lc = os.toLowerCase(Locale.ENGLISH);
        Object suffix = "";
        if (variant != null && !variant.isEmpty()) {
            suffix = "_" + variant.toLowerCase(Locale.ENGLISH);
        }
        switch (lc) {
            case "darwin": 
            case "macos": {
                return String.format("(:?%s%s|%s%s)", "darwin", suffix, "macos", suffix);
            }
        }
        return lc + (String)suffix;
    }

    public static String patternOsArch(String arch) {
        String lc;
        if (arch == null) {
            return null;
        }
        switch (lc = arch.toLowerCase(Locale.ENGLISH)) {
            case "amd64": 
            case "x86_64": {
                return "(:?amd64|x86_64)";
            }
        }
        return lc;
    }

    public static String normalizeArchitecture(String os, String arch) {
        if (arch == null) {
            return null;
        }
        switch (arch.toLowerCase(Locale.ENGLISH)) {
            case "x86_64": {
                return "amd64";
            }
        }
        return arch.toLowerCase(Locale.ENGLISH);
    }

    public static String normalizeOSName(String os, String arch) {
        if (os == null) {
            return null;
        }
        switch (os.toLowerCase(Locale.ENGLISH)) {
            case "darwin": {
                return "macos";
            }
        }
        return os.toLowerCase(Locale.ENGLISH);
    }

    public static byte[] computeFileDigest(Path localFile, String digestAlgo) throws IOException {
        byte[] byArray;
        block10: {
            FileChannel s = FileChannel.open(localFile, StandardOpenOption.READ);
            try {
                int r;
                ByteBuffer bb = ByteBuffer.allocate(4096);
                MessageDigest dg = MessageDigest.getInstance("SHA-256");
                for (long size = Files.size(localFile); size > 0L; size -= (long)r) {
                    if ((long)bb.limit() > size) {
                        bb.limit((int)size);
                    }
                    if ((r = s.read(bb)) < 0) break;
                    bb.flip();
                    dg.update(bb);
                    bb.clear();
                }
                byArray = dg.digest();
                if (s == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IOException(ex);
                }
            }
            s.close();
        }
        return byArray;
    }

    public static boolean isRemotePath(String pathOrURL) {
        try {
            URL u = SystemUtils.toURL(pathOrURL);
            String proto = u.getProtocol();
            if ("file".equals(proto)) {
                throw new IllegalArgumentException("Absolute file:// URLs are not permitted.");
            }
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            SystemUtils.fromCommonRelative(pathOrURL);
            return false;
        }
    }

    public static URL toURL(String url) throws MalformedURLException {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            throw (MalformedURLException)new MalformedURLException().initCause(ex);
        }
    }

    public static URL toURL(String context, String spec) throws MalformedURLException {
        try {
            return new URI(context).resolve(spec).toURL();
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            throw (MalformedURLException)new MalformedURLException().initCause(ex);
        }
    }

    public static URL toURL(URL context, String spec) throws MalformedURLException {
        try {
            return context.toURI().resolve(spec).toURL();
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            throw (MalformedURLException)new MalformedURLException().initCause(ex);
        }
    }

    public static enum OS {
        WINDOWS("windows"),
        LINUX("linux"),
        MAC("macos"),
        UNKNOWN(null);

        private final String name;

        public String getName() {
            return this.name;
        }

        private OS(String name) {
            this.name = name;
        }

        public static String sysName() {
            return System.getProperty("os.name");
        }

        public static OS get() {
            return OS.fromName(OS.sysName());
        }

        public static OS fromName(String osName) {
            return osName == null ? UNKNOWN : OS.fromNameLower(osName.toLowerCase(Locale.ENGLISH));
        }

        private static OS fromNameLower(String osNameLower) {
            if (!osNameLower.isBlank()) {
                if (osNameLower.contains("windows")) {
                    return WINDOWS;
                }
                if (osNameLower.contains("linux")) {
                    return LINUX;
                }
                if (osNameLower.contains("mac") || osNameLower.contains("darwin")) {
                    return MAC;
                }
            }
            return UNKNOWN;
        }
    }

    public static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption;

        public CopyDirVisitor(Path fromPath, Path toPath, StandardCopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        public CopyDirVisitor(Path fromPath, Path toPath) {
            this(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }

    public static enum ARCH {
        AMD64("amd64"),
        AARCH64("aarch64"),
        UNKNOWN(null);

        private final String name;

        public String getName() {
            return this.name;
        }

        private ARCH(String name) {
            this.name = name;
        }

        public static String sysName() {
            return System.getProperty("os.arch");
        }

        public static ARCH get() {
            return ARCH.fromName(ARCH.sysName());
        }

        public static ARCH fromName(String archName) {
            return archName == null ? UNKNOWN : ARCH.fromNameLower(archName.toLowerCase(Locale.ENGLISH));
        }

        private static ARCH fromNameLower(String archNameLower) {
            if (!archNameLower.isBlank()) {
                if (archNameLower.contains("aarch64")) {
                    return AARCH64;
                }
                if (archNameLower.contains("amd64") || archNameLower.contains("x86_64")) {
                    return AMD64;
                }
            }
            return UNKNOWN;
        }
    }
}

