/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.RootCoverage;
import com.oracle.truffle.tools.coverage.SectionCoverage;
import com.oracle.truffle.tools.coverage.SourceCoverage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LineCoverage {
    private static final char STATEMENT_NOT = '-';
    private static final char STATEMENT_YES = '+';
    private static final char STATEMENT_PARTLY = 'p';
    private static final char STATEMENT_EMPTY = ' ';
    private final Map<Integer, LineState> lines;

    LineCoverage(SourceCoverage coverage, boolean strictLines) {
        this.lines = LineCoverage.makeLines(coverage, strictLines);
    }

    private static Map<Integer, LineState> makeLines(SourceCoverage coverage, boolean strictLines) {
        Source source = coverage.getSource();
        if (!source.hasCharacters()) {
            return Collections.emptyMap();
        }
        int lineCount = source.getLineCount();
        HashMap<Integer, List> lineContent = new HashMap<Integer, List>(lineCount);
        for (RootCoverage rootCoverage : coverage.getRoots()) {
            for (SectionCoverage section : rootCoverage.getSectionCoverage()) {
                SourceSection sectionSourceSection = section.getSourceSection();
                for (int i = sectionSourceSection.getStartLine(); i <= sectionSourceSection.getEndLine(); ++i) {
                    lineContent.computeIfAbsent(i, key -> new ArrayList()).add(section);
                }
            }
        }
        HashMap<Integer, LineState> lines = new HashMap<Integer, LineState>(lineCount);
        for (Map.Entry content : lineContent.entrySet()) {
            lines.put((Integer)content.getKey(), strictLines ? LineCoverage.strictState((List)content.getValue()) : LineCoverage.lenientState((List)content.getValue()));
        }
        return lines;
    }

    private static LineState lenientState(List<SectionCoverage> sections) {
        if (sections.stream().anyMatch(SectionCoverage::isCovered)) {
            return LineState.Covered;
        }
        return LineState.NotCovered;
    }

    private static LineState strictState(List<SectionCoverage> sections) {
        if (sections.stream().allMatch(SectionCoverage::isCovered)) {
            return LineState.Covered;
        }
        if (sections.stream().noneMatch(SectionCoverage::isCovered)) {
            return LineState.NotCovered;
        }
        if (LineCoverage.isIncidental(sections)) {
            return LineState.NotCovered;
        }
        return LineState.Partial;
    }

    private static boolean isIncidental(List<SectionCoverage> sections) {
        return sections.stream().anyMatch(e -> !e.isCovered() && LineCoverage.hasCoveredSuperSection(sections, e.getSourceSection()));
    }

    private static boolean hasCoveredSuperSection(List<SectionCoverage> entries, SourceSection incidentalCandidate) {
        return entries.stream().anyMatch(e -> {
            SourceSection sourceSection = e.getSourceSection();
            if (!e.isCovered() || sourceSection == incidentalCandidate) {
                return false;
            }
            return sourceSection.getCharIndex() <= incidentalCandidate.getCharIndex() && sourceSection.getCharEndIndex() >= incidentalCandidate.getCharEndIndex() && (sourceSection.getStartLine() < incidentalCandidate.getStartLine() || sourceSection.getEndLine() > incidentalCandidate.getEndLine());
        });
    }

    double getCoverage() {
        long loadedSize = this.lines.size();
        long coveredSize = this.lines.values().stream().filter(lineState -> lineState == LineState.Covered).count();
        return (double)coveredSize / (double)loadedSize;
    }

    char getStatementCoverageCharacter(int i) {
        if (!this.lines.containsKey(i)) {
            return ' ';
        }
        switch (this.lines.get(i)) {
            case Covered: {
                return '+';
            }
            case Partial: {
                return 'p';
            }
            case NotCovered: {
                return '-';
            }
        }
        throw new IllegalStateException();
    }

    static enum LineState {
        Covered,
        Partial,
        NotCovered;

    }
}

