/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.RootCoverage;
import com.oracle.truffle.tools.coverage.SectionCoverage;
import com.oracle.truffle.tools.coverage.SourceCoverage;
import java.io.PrintStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class LCOVPrinter {
    private static final String END_OF_RECORD = "end_of_record";
    private static final String TEST_NAME = "TN:";
    private static final String SOURCE_NAME = "SN:";
    private static final String SOURCE_FILE = "SF:";
    private static final String FUNCTION = "FN:";
    private static final String FUNCTION_DATA = "FNDA:";
    private static final String FUNCTIONS_FOUND = "FNF:";
    private static final String FUNCTIONS_COVERED = "FNH:";
    private static final String LINES_FOUND = "LF:";
    private static final String LINES_COVERED = "LH:";
    private static final String LINE_DATA = "DA:";
    private final PrintStream out;
    private final SourceCoverage[] coverage;
    private final boolean strictLines;

    LCOVPrinter(PrintStream out, SourceCoverage[] coverage, boolean strictLines) {
        this.out = out;
        this.coverage = coverage;
        this.strictLines = strictLines;
    }

    private static void addCoverageCounts(Map<Integer, Long> linesToCount, SectionCoverage[] sectionCoverage) {
        for (SectionCoverage section : sectionCoverage) {
            LCOVPrinter.addSectionCoverageCount(linesToCount, section);
        }
    }

    private static void addSectionCoverageCount(Map<Integer, Long> linesToCount, SectionCoverage section) {
        SourceSection sourceSection = section.getSourceSection();
        for (int i = sourceSection.getStartLine(); i <= sourceSection.getEndLine(); ++i) {
            linesToCount.compute(i, (key, old) -> {
                if (section.isCovered()) {
                    long count = section.getCount();
                    if (count == -1L) {
                        return 1L;
                    }
                    return old != null ? Math.max(old, count) : count;
                }
                return 0L;
            });
        }
    }

    private static void removeIncidentalCoverage(Map<Integer, Long> linesToCount, SectionCoverage[] sectionCoverage) {
        for (SectionCoverage section : sectionCoverage) {
            if (section.isCovered()) continue;
            SourceSection sourceSection = section.getSourceSection();
            for (int i = sourceSection.getStartLine(); i <= sourceSection.getEndLine(); ++i) {
                linesToCount.put(i, 0L);
            }
        }
    }

    private SortedMap<Integer, Long> linesToCount(SourceCoverage sourceCoverage) {
        TreeMap<Integer, Long> linesToCount = new TreeMap<Integer, Long>();
        for (RootCoverage root : sourceCoverage.getRoots()) {
            SectionCoverage[] sectionCoverage = root.getSectionCoverage();
            LCOVPrinter.addCoverageCounts(linesToCount, sectionCoverage);
        }
        if (this.strictLines) {
            for (RootCoverage root : sourceCoverage.getRoots()) {
                LCOVPrinter.removeIncidentalCoverage(linesToCount, root.getSectionCoverage());
            }
        }
        return linesToCount;
    }

    void print() {
        for (SourceCoverage sourceCoverage : this.coverage) {
            this.printSourceCoverage(sourceCoverage);
        }
    }

    private void printSourceCoverage(SourceCoverage sourceCoverage) {
        this.printTestName();
        this.printSourceName(sourceCoverage);
        this.printSourceFile(sourceCoverage);
        this.printRootData(sourceCoverage);
        this.printLineData(sourceCoverage);
        this.out.println(END_OF_RECORD);
    }

    private void printLineData(SourceCoverage sourceCoverage) {
        int consideredLines = 0;
        int coveredLines = 0;
        SortedMap<Integer, Long> linesToCount = this.linesToCount(sourceCoverage);
        for (Map.Entry<Integer, Long> entry : linesToCount.entrySet()) {
            ++consideredLines;
            long executionCount = entry.getValue();
            if (executionCount > 0L) {
                ++coveredLines;
            }
            int line = entry.getKey();
            this.out.println(LINE_DATA + line + "," + executionCount);
        }
        this.out.println(LINES_FOUND + consideredLines);
        this.out.println(LINES_COVERED + coveredLines);
    }

    private void printRootData(SourceCoverage sourceCoverage) {
        RootCoverage[] roots;
        for (RootCoverage root : roots = sourceCoverage.getRoots()) {
            this.printRoot(root);
        }
        int coveredRoots = 0;
        for (RootCoverage root : roots) {
            if (root.isCovered()) {
                ++coveredRoots;
            }
            this.printRootCoverage(root);
        }
        this.printRootCount(roots);
        this.printCoveredRootCount(coveredRoots);
    }

    private void printCoveredRootCount(int coveredRoots) {
        this.out.println(FUNCTIONS_COVERED + coveredRoots);
    }

    private void printRootCount(RootCoverage[] roots) {
        this.out.println(FUNCTIONS_FOUND + roots.length);
    }

    private void printRootCoverage(RootCoverage root) {
        long count = root.isCovered() && root.getCount() == -1L ? 1L : root.getCount();
        this.out.println(FUNCTION_DATA + count + "," + root.getName());
    }

    private void printRoot(RootCoverage root) {
        this.out.println(FUNCTION + root.getSourceSection().getStartLine() + "," + root.getName());
    }

    private void printSourceName(SourceCoverage sourceCoverage) {
        String name = sourceCoverage.getSource().getName();
        if (name != null) {
            this.out.println(SOURCE_NAME + name);
        }
    }

    private void printSourceFile(SourceCoverage sourceCoverage) {
        this.out.println(SOURCE_FILE + sourceCoverage.getSource().getPath());
    }

    private void printTestName() {
        this.out.println(TEST_NAME);
    }
}

