/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.tools.coverage.impl.CoverageInstrument;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=CoverageInstrument.class)
final class CoverageInstrumentOptionDescriptors
implements TruffleOptionDescriptors {
    CoverageInstrumentOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "coverage": {
                return OptionDescriptor.newBuilder(CoverageInstrument.ENABLED, (String)"coverage").deprecated(false).help("Enable Coverage (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.Count": {
                return OptionDescriptor.newBuilder(CoverageInstrument.Count, (String)"coverage.Count").deprecated(false).help("Keep count of each element's coverage (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.FilterFile": {
                return OptionDescriptor.newBuilder(CoverageInstrument.FILTER_FILE, (String)"coverage.FilterFile").deprecated(false).help("Wildcard filter for source file paths. (eg. *program*.sl)  (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.FilterLanguage": {
                return OptionDescriptor.newBuilder(CoverageInstrument.FILTER_LANGUAGE, (String)"coverage.FilterLanguage").deprecated(false).help("Only track languages with given ID. (eg. js) (default: no filter).").usageSyntax("<languageId>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.FilterMimeType": {
                return OptionDescriptor.newBuilder(CoverageInstrument.FILTER_MIME_TYPE, (String)"coverage.FilterMimeType").deprecated(false).help("Only track languages with mime-type. (default: no filter)").usageSyntax("<mimeType>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.FilterRootName": {
                return OptionDescriptor.newBuilder(CoverageInstrument.FILTER_ROOT, (String)"coverage.FilterRootName").deprecated(false).help("Wildcard filter for program roots. (eg. Math.*) (default: no filter)").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.Output": {
                return OptionDescriptor.newBuilder(CoverageInstrument.OUTPUT, (String)"coverage.Output").deprecated(false).help("Can be: human readable 'histogram' (per file coverage summary) or 'detailed' (per line coverage summary), machine readable 'json', tool compliant 'lcov' (default: histogram).").usageSyntax("histogram|detailed|json|lcov").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.OutputFile": {
                return OptionDescriptor.newBuilder(CoverageInstrument.OUTPUT_FILE, (String)"coverage.OutputFile").deprecated(false).help("Save output to the given file. Output is printed to standard output stream by default.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "coverage.StrictLines": {
                return OptionDescriptor.newBuilder(CoverageInstrument.StrictLines, (String)"coverage.StrictLines").deprecated(false).help("Consider a source code line covered only if covered in it's entirety (default: true)").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "coverage.TrackInternal": {
                return OptionDescriptor.newBuilder(CoverageInstrument.TRACK_INTERNAL, (String)"coverage.TrackInternal").deprecated(false).help("Track internal elements. (default: false)").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert (this.get(optionName) != null) : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(CoverageInstrument.ENABLED, (String)"coverage").deprecated(false).help("Enable Coverage (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.Count, (String)"coverage.Count").deprecated(false).help("Keep count of each element's coverage (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.FILTER_FILE, (String)"coverage.FilterFile").deprecated(false).help("Wildcard filter for source file paths. (eg. *program*.sl)  (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.FILTER_LANGUAGE, (String)"coverage.FilterLanguage").deprecated(false).help("Only track languages with given ID. (eg. js) (default: no filter).").usageSyntax("<languageId>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.FILTER_MIME_TYPE, (String)"coverage.FilterMimeType").deprecated(false).help("Only track languages with mime-type. (default: no filter)").usageSyntax("<mimeType>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.FILTER_ROOT, (String)"coverage.FilterRootName").deprecated(false).help("Wildcard filter for program roots. (eg. Math.*) (default: no filter)").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.OUTPUT, (String)"coverage.Output").deprecated(false).help("Can be: human readable 'histogram' (per file coverage summary) or 'detailed' (per line coverage summary), machine readable 'json', tool compliant 'lcov' (default: histogram).").usageSyntax("histogram|detailed|json|lcov").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.OUTPUT_FILE, (String)"coverage.OutputFile").deprecated(false).help("Save output to the given file. Output is printed to standard output stream by default.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(CoverageInstrument.StrictLines, (String)"coverage.StrictLines").deprecated(false).help("Consider a source code line covered only if covered in it's entirety (default: true)").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(CoverageInstrument.TRACK_INTERNAL, (String)"coverage.TrackInternal").deprecated(false).help("Track internal elements. (default: false)").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

