/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.AbstractCoverageNode;
import java.util.concurrent.atomic.AtomicLong;

public class CountingCoverageNode
extends AbstractCoverageNode {
    private final AtomicLong count = new AtomicLong(0L);

    CountingCoverageNode(SourceSection sourceSection, Node instrumentedNode, boolean isRoot, boolean isStatement) {
        super(sourceSection, instrumentedNode, isRoot, isStatement);
    }

    @Override
    boolean isCovered() {
        return this.count.get() != 0L;
    }

    @Override
    void reset() {
        this.count.set(0L);
    }

    protected void onEnter(VirtualFrame frame) {
        this.count.incrementAndGet();
    }

    long getCount() {
        return this.count.get();
    }
}

