/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.options.OptionKey;

public class HeapSnapshotVerifier {
    protected final BigBang bb;
    protected final ImageHeapScanner scanner;
    protected final ImageHeap imageHeap;
    private ObjectScanner.ReusableSet scannedObjects;
    private boolean heapPatched;
    private boolean analysisModified;
    private final int verbosity;
    private int iterations;
    private static final int INFO = 1;
    private static final int WARNING = 2;
    private static final int ALL = 3;

    public HeapSnapshotVerifier(BigBang bb, ImageHeap imageHeap, ImageHeapScanner scanner) {
        this.bb = bb;
        this.scanner = scanner;
        this.imageHeap = imageHeap;
        this.scannedObjects = new ObjectScanner.ReusableSet();
        this.verbosity = (Integer)Options.HeapVerifierVerbosity.getValue(bb.getOptions());
    }

    public boolean requireAnalysisIteration(CompletionExecutor executor) throws InterruptedException {
        this.info("Verifying the heap snapshot...");
        this.analysisModified = false;
        this.heapPatched = false;
        int reachableTypesBefore = this.bb.getUniverse().getReachableTypes();
        ++this.iterations;
        this.scannedObjects.reset();
        ObjectScanner objectScanner = new ObjectScanner(this.bb, executor, this.scannedObjects, new ScanningObserver());
        executor.start();
        this.scanTypes(objectScanner);
        objectScanner.scanBootImageHeapRoots();
        executor.complete();
        executor.shutdown();
        int verificationReachableTypes = this.bb.getUniverse().getReachableTypes() - reachableTypesBefore;
        if (this.heapPatched) {
            this.info("Heap verification patched the heap snapshot.");
        } else {
            this.info("Heap verification didn't find any heap snapshot modifications.");
        }
        if (verificationReachableTypes > 0) {
            this.info("Heap verification made " + verificationReachableTypes + " new types reachable.");
        } else {
            this.info("Heap verification didn't make any new types reachable.");
        }
        if (this.analysisModified) {
            this.info("Heap verification modified the analysis state. Executing an additional analysis iteration.");
        } else {
            this.info("Heap verification didn't modify the analysis state. Heap state stabilized after " + this.iterations + " iterations.");
            this.info("Exiting analysis.");
        }
        return this.analysisModified || verificationReachableTypes > 0;
    }

    protected void scanTypes(ObjectScanner objectScanner) {
    }

    public void cleanupAfterAnalysis() {
        this.scannedObjects = null;
    }

    private void onNoTaskForClassConstant(AnalysisType type, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printAll()) {
            this.warning(reason, "No snapshot task found for class constant %s %n", type.toJavaName());
        }
    }

    private void onTaskForClassConstantNotDone(JavaConstant object, AnalysisType type, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printAll()) {
            if (object != null) {
                this.warning(reason, "Snapshot not yet computed for class %s of object %s %n", type.toJavaName(), object);
            } else {
                this.warning(reason, "Snapshot not yet computed for class constant %n new value: %s %n", type.toJavaName());
            }
        }
    }

    private void onArrayElementMismatch(JavaConstant elementSnapshot, JavaConstant elementValue, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printWarning()) {
            this.analysisWarning(reason, "Value mismatch for array element %n snapshot: %s %n new value: %s %n", elementSnapshot, elementValue);
        }
    }

    private void onStaticFieldMismatch(AnalysisField field, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printWarning()) {
            this.analysisWarning(reason, "Value mismatch for static field %s %n snapshot: %s %n new value: %s %n", field, fieldSnapshot, fieldValue);
        }
    }

    private void onStaticFieldNotComputed(AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.error(reason, "Snapshot not yet computed for static field %s %n new value: %s %n", field, fieldValue);
    }

    private void onInstanceFieldMismatch(ImageHeapInstance receiver, AnalysisField field, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printWarning()) {
            this.analysisWarning(reason, "Value mismatch for instance field %s of %s %n snapshot: %s %n new value: %s %n", field, receiver, fieldSnapshot, fieldValue);
        }
    }

    private void onInstanceFieldNotComputed(ImageHeapInstance receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printWarning()) {
            this.analysisWarning(reason, "Snapshot not yet computed for instance field %s of %s %n new value: %s %n", field, receiver, fieldValue);
        }
    }

    private boolean printInfo() {
        return this.verbosity >= 1;
    }

    private boolean printWarning() {
        return this.verbosity >= 2;
    }

    private boolean printAll() {
        return this.verbosity >= 3;
    }

    private void info(String info) {
        if (this.printInfo()) {
            System.out.println("INFO: " + info);
        }
    }

    private void warning(ObjectScanner.ScanReason reason, String format, Object ... args) {
        System.out.println("WARNING: " + this.message(reason, format, "Object was reached by", args));
    }

    private void analysisWarning(ObjectScanner.ScanReason reason, String format, Object ... args) {
        System.out.println("WARNING: " + this.message(reason, format, "This leads to an analysis state change when", args));
    }

    private RuntimeException error(ObjectScanner.ScanReason reason, String format, Object ... args) {
        throw AnalysisError.shouldNotReachHere(this.message(reason, format, args));
    }

    private String message(ObjectScanner.ScanReason reason, String format, Object ... args) {
        return this.message(reason, format, "", args);
    }

    private String message(ObjectScanner.ScanReason reason, String format, String backtraceHeader, Object ... args) {
        Object message = this.format(format, args);
        StringBuilder objectBacktrace = new StringBuilder();
        ObjectScanner.buildObjectBacktrace(this.bb, reason, objectBacktrace, backtraceHeader);
        message = (String)message + String.valueOf(objectBacktrace);
        return message;
    }

    private String format(String msg, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof JavaConstant) {
                    args[i] = ObjectScanner.asString(this.bb, (JavaConstant)args[i]);
                    continue;
                }
                if (!(args[i] instanceof AnalysisField)) continue;
                args[i] = ((AnalysisField)args[i]).format("%H.%n");
            }
        }
        return String.format(msg, args);
    }

    static class Options {
        public static final OptionKey<Integer> HeapVerifierVerbosity = new OptionKey((Object)0);

        Options() {
        }
    }

    private final class ScanningObserver
    implements ObjectScanningObserver {
        private ScanningObserver() {
        }

        @Override
        public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            boolean result = HeapSnapshotVerifier.this.scanner.getScanningObserver().forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
            if (result) {
                HeapSnapshotVerifier.this.analysisModified = true;
            }
            return result;
        }

        @Override
        public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
            boolean result = HeapSnapshotVerifier.this.scanner.getScanningObserver().forNullFieldValue(receiver, field, reason);
            if (result) {
                HeapSnapshotVerifier.this.analysisModified = true;
            }
            return result;
        }

        @Override
        public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            if (field.isStatic()) {
                TypeData typeData = field.getDeclaringClass().getOrComputeData();
                Object fieldValueTask = typeData.getFieldValue(field);
                if (fieldValueTask instanceof JavaConstant) {
                    JavaConstant fieldSnapshot = (JavaConstant)fieldValueTask;
                    this.verifyStaticFieldValue(typeData, field, this.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant), fieldValue, reason);
                } else if (fieldValueTask instanceof AnalysisFuture) {
                    AnalysisFuture future = (AnalysisFuture)fieldValueTask;
                    if (future.isDone()) {
                        JavaConstant fieldSnapshot = (JavaConstant)future.guardedGet();
                        this.verifyStaticFieldValue(typeData, field, this.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant), fieldValue, reason);
                    } else {
                        HeapSnapshotVerifier.this.onStaticFieldNotComputed(field, fieldValue, reason);
                    }
                }
            } else {
                ImageHeapInstance receiverObject = (ImageHeapInstance)this.getReceiverObject(receiver, reason);
                Object fieldValueTask = receiverObject.getFieldValue(field);
                if (fieldValueTask instanceof JavaConstant) {
                    JavaConstant fieldSnapshot = (JavaConstant)fieldValueTask;
                    this.verifyInstanceFieldValue(field, receiverObject, this.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant), fieldValue, reason);
                } else if (fieldValueTask instanceof AnalysisFuture) {
                    AnalysisFuture future = (AnalysisFuture)fieldValueTask;
                    if (future.isDone()) {
                        JavaConstant fieldSnapshot = (JavaConstant)future.guardedGet();
                        this.verifyInstanceFieldValue(field, receiverObject, this.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant), fieldValue, reason);
                    } else {
                        Consumer<ObjectScanner.ScanReason> onAnalysisModified = deepReason -> HeapSnapshotVerifier.this.onInstanceFieldNotComputed(receiverObject, field, fieldValue, (ObjectScanner.ScanReason)deepReason);
                        HeapSnapshotVerifier.this.scanner.patchInstanceField(receiverObject, field, fieldValue, reason, onAnalysisModified).ensureDone();
                        HeapSnapshotVerifier.this.heapPatched = true;
                    }
                }
            }
            return false;
        }

        private void verifyStaticFieldValue(TypeData typeData, AnalysisField field, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(fieldSnapshot, fieldValue)) {
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = deepReason -> HeapSnapshotVerifier.this.onStaticFieldMismatch(field, fieldSnapshot, fieldValue, (ObjectScanner.ScanReason)deepReason);
                HeapSnapshotVerifier.this.scanner.patchStaticField(typeData, field, fieldValue, reason, onAnalysisModified).ensureDone();
                HeapSnapshotVerifier.this.heapPatched = true;
            }
        }

        private void verifyInstanceFieldValue(AnalysisField field, ImageHeapInstance receiverObject, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(fieldSnapshot, fieldValue)) {
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = deepReason -> HeapSnapshotVerifier.this.onInstanceFieldMismatch(receiverObject, field, fieldSnapshot, fieldValue, (ObjectScanner.ScanReason)deepReason);
                HeapSnapshotVerifier.this.scanner.patchInstanceField(receiverObject, field, fieldValue, reason, onAnalysisModified).ensureDone();
                HeapSnapshotVerifier.this.heapPatched = true;
            }
        }

        @Override
        public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason) {
            boolean result = HeapSnapshotVerifier.this.scanner.getScanningObserver().forNullArrayElement(array, arrayType, elementIndex, reason);
            if (result) {
                HeapSnapshotVerifier.this.analysisModified = true;
            }
            return result;
        }

        @Override
        public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, AnalysisType elementType, int index, ObjectScanner.ScanReason reason) {
            ImageHeapArray arrayObject = (ImageHeapArray)this.getReceiverObject(array, reason);
            JavaConstant elementSnapshot = arrayObject.getElement(index);
            if (!Objects.equals(this.maybeUnwrapSnapshot(elementSnapshot, elementValue instanceof ImageHeapConstant), elementValue)) {
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = deepReason -> HeapSnapshotVerifier.this.onArrayElementMismatch(elementSnapshot, elementValue, (ObjectScanner.ScanReason)deepReason);
                arrayObject.setElement(index, HeapSnapshotVerifier.this.scanner.onArrayElementReachable(arrayObject, arrayType, elementValue, index, reason, onAnalysisModified));
                HeapSnapshotVerifier.this.heapPatched = true;
            }
            return false;
        }

        private ImageHeapConstant getReceiverObject(JavaConstant constant, ObjectScanner.ScanReason reason) {
            Object task = HeapSnapshotVerifier.this.imageHeap.getTask(constant);
            if (task == null) {
                throw HeapSnapshotVerifier.this.error(reason, "Task is null for constant %s.", constant);
            }
            if (task instanceof ImageHeapConstant) {
                return (ImageHeapConstant)task;
            }
            assert (task instanceof AnalysisFuture);
            AnalysisFuture future = (AnalysisFuture)task;
            if (future.isDone()) {
                return (ImageHeapConstant)future.guardedGet();
            }
            throw HeapSnapshotVerifier.this.error(reason, "Task not yet executed for constant %s.", constant);
        }

        @Override
        public void forEmbeddedRoot(JavaConstant root, ObjectScanner.ScanReason reason) {
            Object rootTask = HeapSnapshotVerifier.this.imageHeap.getTask(root);
            if (rootTask == null) {
                throw HeapSnapshotVerifier.this.error(reason, "No snapshot task found for embedded root %s %n", root);
            }
            if (rootTask instanceof ImageHeapConstant) {
                ImageHeapConstant snapshot = (ImageHeapConstant)rootTask;
                this.verifyEmbeddedRoot(this.maybeUnwrapSnapshot(snapshot, root instanceof ImageHeapConstant), root, reason);
            } else {
                AnalysisFuture future = (AnalysisFuture)rootTask;
                if (future.isDone()) {
                    ImageHeapConstant snapshot = (ImageHeapConstant)future.guardedGet();
                    this.verifyEmbeddedRoot(this.maybeUnwrapSnapshot(snapshot, root instanceof ImageHeapConstant), root, reason);
                } else {
                    throw HeapSnapshotVerifier.this.error(reason, "Snapshot not yet computed for embedded root %n new value: %s %n", root);
                }
            }
        }

        private JavaConstant maybeUnwrapSnapshot(JavaConstant snapshot, boolean asImageHeapObject) {
            if (snapshot instanceof ImageHeapConstant) {
                return asImageHeapObject ? snapshot : ((ImageHeapConstant)snapshot).getHostedObject();
            }
            return snapshot;
        }

        private void verifyEmbeddedRoot(JavaConstant rootSnapshot, JavaConstant root, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(rootSnapshot, root)) {
                throw HeapSnapshotVerifier.this.error(reason, "Value mismatch for embedded root %n snapshot: %s %n new value: %s %n", rootSnapshot, root);
            }
        }

        @Override
        public void forScannedConstant(JavaConstant value, ObjectScanner.ScanReason reason) {
            if (HeapSnapshotVerifier.this.bb.getMetaAccess().isInstanceOf(value, Class.class)) {
                AnalysisType type = (AnalysisType)HeapSnapshotVerifier.this.bb.getConstantReflectionProvider().asJavaType((Constant)value);
                this.ensureTypeScanned(value, type, reason);
            } else {
                AnalysisType type = HeapSnapshotVerifier.this.bb.getMetaAccess().lookupJavaType(value);
                this.ensureTypeScanned(value, HeapSnapshotVerifier.this.bb.getConstantReflectionProvider().asJavaClass((ResolvedJavaType)type), type, reason);
            }
        }

        private void ensureTypeScanned(JavaConstant typeConstant, AnalysisType type, ObjectScanner.ScanReason reason) {
            this.ensureTypeScanned(null, typeConstant, type, reason);
        }

        private void ensureTypeScanned(JavaConstant value, JavaConstant typeConstant, AnalysisType type, ObjectScanner.ScanReason reason) {
            AnalysisError.guarantee(type.isReachable(), "The heap snapshot verifier discovered a type not marked as reachable: %s", type);
            Object task = HeapSnapshotVerifier.this.imageHeap.getTask(typeConstant);
            if (task == null) {
                HeapSnapshotVerifier.this.onNoTaskForClassConstant(type, reason);
                HeapSnapshotVerifier.this.scanner.toImageHeapObject(typeConstant, reason, null);
                HeapSnapshotVerifier.this.heapPatched = true;
            } else if (task instanceof ImageHeapConstant) {
                JavaConstant snapshot = ((ImageHeapConstant)task).getHostedObject();
                this.verifyTypeConstant(snapshot, typeConstant, reason);
            } else {
                assert (task instanceof AnalysisFuture);
                AnalysisFuture future = (AnalysisFuture)task;
                if (future.isDone()) {
                    JavaConstant snapshot = ((ImageHeapConstant)future.guardedGet()).getHostedObject();
                    this.verifyTypeConstant(snapshot, typeConstant, reason);
                } else {
                    HeapSnapshotVerifier.this.onTaskForClassConstantNotDone(value, type, reason);
                    future.ensureDone();
                }
            }
        }

        private void verifyTypeConstant(JavaConstant snapshot, JavaConstant typeConstant, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(snapshot, typeConstant)) {
                throw HeapSnapshotVerifier.this.error(reason, "Value mismatch for class constant snapshot: %s %n new value: %s %n", snapshot, typeConstant);
            }
        }
    }
}

