/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLoggers {
    private static final Map<Path, SharedFileHandler> fileHandlers = new HashMap<Path, SharedFileHandler>();
    private static final String GRAAL_COMPILER_LOG_ID = "graal";
    private static final Set<String> INTERNAL_IDS;

    private PolyglotLoggers() {
    }

    static Set<String> getInternalIds() {
        return INTERNAL_IDS;
    }

    static PolyglotContextImpl getCurrentOuterContext() {
        return EngineAccessor.EngineImpl.getOuterContext(PolyglotFastThreadLocals.getContext(null));
    }

    static boolean hasSameStream(AbstractPolyglotImpl.LogHandler h1, AbstractPolyglotImpl.LogHandler h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 instanceof StreamLogHandler && h2 instanceof StreamLogHandler) {
            return ((StreamLogHandler)h1).stream == ((StreamLogHandler)h2).stream;
        }
        return false;
    }

    static AbstractPolyglotImpl.LogHandler asLogHandler(AbstractPolyglotImpl polyglot, Object logHandlerOrStream) {
        if (logHandlerOrStream instanceof Handler) {
            return new JavaLogHandler(polyglot, (Handler)logHandlerOrStream);
        }
        if (logHandlerOrStream instanceof OutputStream) {
            return PolyglotLoggers.createStreamHandler(polyglot, (OutputStream)logHandlerOrStream, true, true);
        }
        throw new IllegalArgumentException("Unexpected logHandlerOrStream parameter: " + String.valueOf(logHandlerOrStream));
    }

    static AbstractPolyglotImpl.LogHandler createDefaultHandler(AbstractPolyglotImpl polyglot, OutputStream out, SandboxPolicy sandboxPolicy) {
        return new StreamLogHandler(polyglot, out, false, true, true, (SandboxPolicy)(sandboxPolicy.isStricterOrEqual(SandboxPolicy.UNTRUSTED) ? sandboxPolicy : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AbstractPolyglotImpl.LogHandler getFileHandler(AbstractPolyglotImpl polyglot, String path) {
        Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath().normalize();
        Map<Path, SharedFileHandler> map = fileHandlers;
        synchronized (map) {
            SharedFileHandler handler = fileHandlers.get(absolutePath);
            if (handler == null) {
                try {
                    handler = new SharedFileHandler(polyglot, absolutePath);
                    fileHandlers.put(absolutePath, handler);
                }
                catch (IOException ioe) {
                    throw PolyglotEngineException.illegalArgument("Cannot open log file " + path + " for writing, IO error: " + (ioe.getMessage() != null ? ioe.getMessage() : null));
                }
            }
            return handler.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Path> getActiveFileHandlers() {
        Map<Path, SharedFileHandler> map = fileHandlers;
        synchronized (map) {
            return new HashSet<Path>(fileHandlers.keySet());
        }
    }

    static AbstractPolyglotImpl.LogHandler createStreamHandler(AbstractPolyglotImpl polyglot, OutputStream out, boolean closeStream, boolean flushOnPublish) {
        return new StreamLogHandler(polyglot, out, closeStream, flushOnPublish, false, null);
    }

    static LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, String formatKind) {
        return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown, ImmutableLogRecord.FormatKind.valueOf(formatKind));
    }

    static String getFormatKind(LogRecord logRecord) {
        return (logRecord instanceof ImmutableLogRecord ? ((ImmutableLogRecord)logRecord).getFormatKind() : ImmutableLogRecord.FormatKind.DEFAULT).name();
    }

    static {
        HashSet s = new HashSet();
        Collections.addAll(s, "engine", GRAAL_COMPILER_LOG_ID);
        INTERNAL_IDS = Collections.unmodifiableSet(s);
    }

    private static class StreamLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private static final String REDIRECT_FORMAT = "[To redirect Truffle log output to a file use one of the following options:%n* '--log.file=<path>' if the option is passed using a guest language launcher.%n* '-Dpolyglot.log.file=<path>' if the option is passed using the host Java launcher.%n* Configure logging using the polyglot embedding API.]%n";
        private static final String DISABLED_FORMAT = "[engine] Logging to context error output stream is not enabled for the sandbox policy %s. To resolve this issue, install a custom logging handler using Builder.logHandler(Handler) or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%n";
        private final OutputStream stream;
        private final OutputStreamWriter writer;
        private final Formatter formatter;
        private final boolean closeStream;
        private final boolean flushOnPublish;
        private final boolean isDefault;
        private final SandboxPolicy disabledForActiveSandboxPolicy;
        private ErrorManager errorManager;
        private boolean notificationPrinted;

        StreamLogHandler(AbstractPolyglotImpl polyglot, OutputStream stream, boolean closeStream, boolean flushOnPublish, boolean isDefault, SandboxPolicy disabledForActiveSandboxPolicy) {
            super(polyglot);
            Objects.requireNonNull(stream, "Stream must be non null");
            this.stream = stream;
            this.writer = new OutputStreamWriter(stream);
            this.formatter = FormatterImpl.INSTANCE;
            this.closeStream = closeStream;
            this.flushOnPublish = flushOnPublish;
            this.isDefault = isDefault;
            this.disabledForActiveSandboxPolicy = disabledForActiveSandboxPolicy;
        }

        public synchronized void publish(LogRecord logRecord) {
            try {
                String msg;
                if (this.disabledForActiveSandboxPolicy != null) {
                    assert (this.isDefault) : "Only default handler can be disabled";
                    if (!this.notificationPrinted) {
                        this.writer.write(String.format(DISABLED_FORMAT, this.disabledForActiveSandboxPolicy));
                        this.writer.flush();
                        this.notificationPrinted = true;
                    }
                    return;
                }
                try {
                    msg = this.formatter.format(logRecord);
                }
                catch (Exception ex) {
                    this.reportHandlerError(5, ex);
                    return;
                }
                try {
                    if (this.isDefault && !this.notificationPrinted) {
                        this.writer.write(String.format(REDIRECT_FORMAT, new Object[0]));
                        this.notificationPrinted = true;
                    }
                    this.writer.write(msg);
                    if (this.flushOnPublish) {
                        this.writer.flush();
                    }
                }
                catch (Exception ex) {
                    this.reportHandlerError(1, ex);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public synchronized void flush() {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.reportHandlerError(2, ex);
            }
        }

        public synchronized void close() {
            try {
                this.writer.flush();
                if (this.closeStream) {
                    this.writer.close();
                }
            }
            catch (Exception ex) {
                this.reportHandlerError(3, ex);
            }
        }

        private void reportHandlerError(int errorKind, Exception exception) {
            assert (Thread.holdsLock((Object)this));
            if (this.errorManager == null) {
                this.errorManager = new ErrorManager();
            }
            this.errorManager.error("", exception, errorKind);
        }

        private static final class FormatterImpl
        extends Formatter {
            private static final String FORMAT_FULL = "[%1$s] %2$s: %3$s%4$s%n";
            private static final String FORMAT_NO_LEVEL = "[%1$s] %2$s%3$s%n";
            static final Formatter INSTANCE = new FormatterImpl();

            private FormatterImpl() {
            }

            @Override
            public String format(LogRecord record) {
                String loggerName = FormatterImpl.formatLoggerName(record.getLoggerName());
                String message = this.formatMessage(record);
                String stackTrace = "";
                Throwable exception = record.getThrown();
                if (exception != null) {
                    StringWriter str = new StringWriter();
                    try (PrintWriter out = new PrintWriter(str);){
                        out.println();
                        exception.printStackTrace(out);
                    }
                    stackTrace = str.toString();
                }
                ImmutableLogRecord.FormatKind formatKind = ((ImmutableLogRecord)record).getFormatKind();
                return switch (formatKind) {
                    case ImmutableLogRecord.FormatKind.DEFAULT -> String.format(FORMAT_FULL, loggerName, record.getLevel().getName(), message, stackTrace);
                    case ImmutableLogRecord.FormatKind.NO_LEVEL -> String.format(FORMAT_NO_LEVEL, loggerName, message, stackTrace);
                    case ImmutableLogRecord.FormatKind.RAW -> message;
                    default -> throw new IllegalArgumentException("Unsupported FormatKind " + String.valueOf((Object)formatKind));
                };
            }

            private static String formatLoggerName(String loggerName) {
                String name;
                String id;
                int index = loggerName.indexOf(46);
                if (index < 0) {
                    id = loggerName;
                    name = "";
                } else {
                    id = loggerName.substring(0, index);
                    name = loggerName.substring(index + 1);
                }
                if (name.isEmpty()) {
                    return id;
                }
                StringBuilder sb = new StringBuilder(id);
                sb.append("::");
                sb.append(FormatterImpl.possibleSimpleName(name));
                return sb.toString();
            }

            private static String possibleSimpleName(String loggerName) {
                int index = -1;
                int i = 0;
                while (i >= 0) {
                    if (i + 1 < loggerName.length() && Character.isUpperCase(loggerName.charAt(i + 1))) {
                        index = i + 1;
                        break;
                    }
                    i = loggerName.indexOf(46, i + 1);
                }
                return index < 0 ? loggerName : loggerName.substring(index);
            }
        }
    }

    private static final class JavaLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private final Handler handler;

        JavaLogHandler(AbstractPolyglotImpl polyglot, Handler handler) {
            super(polyglot);
            this.handler = Objects.requireNonNull(handler, "Handler must be non null");
        }

        public void publish(LogRecord logRecord) {
            try {
                this.handler.publish(logRecord);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void flush() {
            this.handler.flush();
        }

        public void close() {
            this.handler.close();
        }
    }

    private static final class SharedFileHandler
    extends StreamLogHandler {
        private final Path path;
        private int refCount;

        SharedFileHandler(AbstractPolyglotImpl polyglot, Path path) throws IOException {
            super(polyglot, new FileOutputStream(path.toFile(), true), true, true, false, null);
            this.path = path;
        }

        SharedFileHandler retain() {
            assert (Thread.holdsLock(fileHandlers));
            ++this.refCount;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map<Path, SharedFileHandler> map = fileHandlers;
            synchronized (map) {
                --this.refCount;
                if (this.refCount == 0) {
                    fileHandlers.remove(this.path);
                    super.close();
                }
            }
        }
    }

    private static final class ImmutableLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 1L;
        private final FormatKind formatKind;

        ImmutableLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, FormatKind formatKind) {
            super(level, message);
            super.setLoggerName(loggerName);
            if (className != null) {
                super.setSourceClassName(className);
            }
            if (methodName != null) {
                super.setSourceMethodName(methodName);
            }
            Object[] copy = parameters;
            if (parameters != null && parameters.length > 0) {
                copy = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    copy[i] = ImmutableLogRecord.safeValue(parameters[i]);
                }
            }
            super.setParameters(copy);
            super.setThrown(thrown);
            this.formatKind = formatKind;
        }

        @Override
        public void setLevel(Level level) {
            throw new UnsupportedOperationException("Setting Level is not supported.");
        }

        @Override
        public void setLoggerName(String name) {
            throw new UnsupportedOperationException("Setting Logger Name is not supported.");
        }

        @Override
        public void setMessage(String message) {
            throw new UnsupportedOperationException("Setting Messag is not supported.");
        }

        @Override
        public void setMillis(long millis) {
            throw new UnsupportedOperationException("Setting Millis is not supported.");
        }

        @Override
        public void setParameters(Object[] parameters) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setResourceBundle(ResourceBundle bundle) {
            throw new UnsupportedOperationException("Setting Resource Bundle is not supported.");
        }

        @Override
        public void setResourceBundleName(String name) {
            throw new UnsupportedOperationException("Setting Resource Bundle Name is not supported.");
        }

        @Override
        public void setSequenceNumber(long seq) {
            throw new UnsupportedOperationException("Setting Sequence Number is not supported.");
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            throw new UnsupportedOperationException("Setting Source Method Name is not supported.");
        }

        @Override
        public void setThreadID(int threadID) {
            throw new UnsupportedOperationException("Setting Thread ID is not supported.");
        }

        @Override
        public void setThrown(Throwable thrown) {
            throw new UnsupportedOperationException("Setting Throwable is not supported.");
        }

        FormatKind getFormatKind() {
            return this.formatKind;
        }

        private static Object safeValue(Object param) {
            if (param == null || EngineAccessor.EngineImpl.isPrimitive(param)) {
                return param;
            }
            try {
                return InteropLibrary.getFactory().getUncached().asString(InteropLibrary.getFactory().getUncached().toDisplayString(param));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        static enum FormatKind {
            RAW,
            NO_LEVEL,
            DEFAULT;

        }
    }

    static final class EngineLoggerProvider
    implements Function<String, TruffleLogger> {
        private volatile Object loggers;
        private final AbstractPolyglotImpl.LogHandler logHandler;
        private final Map<String, Level> logLevels;

        EngineLoggerProvider(AbstractPolyglotImpl.LogHandler logHandler, Map<String, Level> logLevels) {
            this.logHandler = logHandler;
            this.logLevels = logLevels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TruffleLogger apply(String loggerId) {
            Object loggersCache = this.loggers;
            if (loggersCache == null) {
                EngineLoggerProvider engineLoggerProvider = this;
                synchronized (engineLoggerProvider) {
                    loggersCache = this.loggers;
                    if (loggersCache == null) {
                        LoggerCache spi = LoggerCache.newEngineLoggerCache(this.logHandler, this.logLevels, false, Collections.singleton(PolyglotLoggers.GRAAL_COMPILER_LOG_ID), Level.INFO);
                        this.loggers = loggersCache = EngineAccessor.LANGUAGE.createEngineLoggers(spi);
                    }
                }
            }
            return EngineAccessor.LANGUAGE.getLogger(loggerId, null, loggersCache);
        }
    }

    private static final class ContextLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private final WeakReference<PolyglotContextImpl> contextRef;

        ContextLogHandler(PolyglotContextImpl context) {
            super((AbstractPolyglotImpl)context.getImpl());
            this.contextRef = new WeakReference<PolyglotContextImpl>(context);
        }

        public void publish(LogRecord record) {
            this.findDelegate().publish(record);
        }

        public void flush() {
            this.findDelegate().flush();
        }

        public void close() throws SecurityException {
            this.findDelegate().close();
        }

        private AbstractPolyglotImpl.LogHandler findDelegate() {
            PolyglotContextImpl context = (PolyglotContextImpl)this.contextRef.get();
            if (context == null) {
                throw ContextLogHandler.invalidSharing();
            }
            return context.config.logHandler;
        }

        static AssertionError invalidSharing() {
            throw new AssertionError((Object)"Invalid sharing of bound TruffleLogger in AST nodes detected.");
        }
    }

    private static final class PolyglotLogHandler
    extends AbstractPolyglotImpl.LogHandler {
        private static final AbstractPolyglotImpl.LogHandler INSTANCE = new PolyglotLogHandler(PolyglotImpl.getInstance());
        private final AbstractPolyglotImpl.LogHandler fallBackHandler;

        PolyglotLogHandler(AbstractPolyglotImpl polyglot) {
            super(polyglot);
            this.fallBackHandler = null;
        }

        PolyglotLogHandler(AbstractPolyglotImpl polyglot, AbstractPolyglotImpl.LogHandler fallbackHandler) {
            super(polyglot);
            this.fallBackHandler = fallbackHandler;
        }

        public void publish(LogRecord record) {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler == null) {
                handler = this.fallBackHandler;
            }
            if (handler != null) {
                handler.publish(record);
            }
        }

        public void flush() {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.flush();
            }
        }

        public void close() throws SecurityException {
            AbstractPolyglotImpl.LogHandler handler = PolyglotLogHandler.findDelegate();
            if (handler != null) {
                handler.close();
            }
        }

        private static AbstractPolyglotImpl.LogHandler findDelegate() {
            PolyglotContextImpl currentContext = PolyglotLoggers.getCurrentOuterContext();
            return currentContext != null ? currentContext.config.logHandler : null;
        }
    }

    static final class LoggerCache {
        static final LoggerCache DEFAULT = new LoggerCache(PolyglotLogHandler.INSTANCE, true, null, Collections.emptySet(), new Level[0]);
        private final AbstractPolyglotImpl.LogHandler handler;
        private final boolean useCurrentContext;
        private final Map<String, Level> ownerLogLevels;
        private final Set<String> rawLoggerIds;
        private final Set<Level> implicitLevels;
        private volatile WeakReference<PolyglotImpl.VMObject> ownerRef;

        private LoggerCache(AbstractPolyglotImpl.LogHandler handler, boolean useCurrentContext, Map<String, Level> ownerLogLevels, Set<String> rawLoggerIds, Level ... implicitLevels) {
            Objects.requireNonNull(handler);
            this.handler = handler;
            this.useCurrentContext = useCurrentContext;
            this.ownerLogLevels = ownerLogLevels;
            this.rawLoggerIds = rawLoggerIds;
            if (implicitLevels.length == 0) {
                this.implicitLevels = Collections.emptySet();
            } else {
                this.implicitLevels = new HashSet<Level>();
                Collections.addAll(this.implicitLevels, implicitLevels);
            }
        }

        void setOwner(PolyglotImpl.VMObject owner) {
            if (this.ownerRef != null) {
                throw new IllegalStateException("owner can only be set once");
            }
            this.ownerRef = new WeakReference<PolyglotImpl.VMObject>(owner);
        }

        static LoggerCache newEngineLoggerCache(PolyglotEngineImpl engine) {
            return LoggerCache.newEngineLoggerCache(new PolyglotLogHandler(engine.getImpl(), engine.logHandler), engine.logLevels, true, Collections.emptySet(), new Level[0]);
        }

        static LoggerCache newEngineLoggerCache(AbstractPolyglotImpl.LogHandler handler, Map<String, Level> logLevels, boolean useCurrentContext, Set<String> rawLoggerIds, Level ... implicitLevels) {
            return new LoggerCache(handler, useCurrentContext, logLevels, rawLoggerIds, implicitLevels);
        }

        static LoggerCache newContextLoggerCache(PolyglotContextImpl context) {
            Objects.requireNonNull(context);
            LoggerCache cache = new LoggerCache(new ContextLogHandler(context), false, context.config.logLevels, Collections.emptySet(), new Level[0]);
            cache.setOwner(context);
            return cache;
        }

        public PolyglotImpl.VMObject getOwner() {
            return this.ownerRef == null ? null : (PolyglotImpl.VMObject)this.ownerRef.get();
        }

        public AbstractPolyglotImpl.LogHandler getLogHandler() {
            return this.handler;
        }

        public Map<String, Level> getLogLevels() {
            PolyglotContextImpl context;
            if (this.useCurrentContext && (context = PolyglotLoggers.getCurrentOuterContext()) != null) {
                return context.config.logLevels;
            }
            if (this.ownerLogLevels != null) {
                if (this.ownerRef != null && this.ownerRef.get() == null) {
                    throw ContextLogHandler.invalidSharing();
                }
                return this.ownerLogLevels;
            }
            return null;
        }

        public LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            ImmutableLogRecord.FormatKind formaterKind = this.rawLoggerIds.contains(loggerName) ? ImmutableLogRecord.FormatKind.RAW : (this.implicitLevels.contains(level) ? ImmutableLogRecord.FormatKind.NO_LEVEL : ImmutableLogRecord.FormatKind.DEFAULT);
            return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown, formaterKind);
        }
    }
}

