/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.ClassLoadingProcessor;
import com.oracle.svm.configure.trace.JniProcessor;
import com.oracle.svm.configure.trace.ReflectionProcessor;
import com.oracle.svm.configure.trace.SerializationProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.util.json.JSONParser;

public class TraceProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private final JniProcessor jniProcessor;
    private final ReflectionProcessor reflectionProcessor;
    private final SerializationProcessor serializationProcessor;
    private final ClassLoadingProcessor classLoadingProcessor;

    public TraceProcessor(AccessAdvisor accessAdvisor) {
        this.advisor = accessAdvisor;
        this.jniProcessor = new JniProcessor(this.advisor);
        this.reflectionProcessor = new ReflectionProcessor(this.advisor);
        this.serializationProcessor = new SerializationProcessor(this.advisor);
        this.classLoadingProcessor = new ClassLoadingProcessor();
    }

    public void process(Reader reader, ConfigurationSet configurationSet) throws IOException {
        this.setInLivePhase(false);
        JSONParser parser = new JSONParser(reader);
        List trace = (List)parser.parse();
        this.processTrace(trace, configurationSet);
    }

    private void processTrace(List<EconomicMap<String, ?>> trace, ConfigurationSet configurationSet) {
        for (EconomicMap<String, ?> entry : trace) {
            this.processEntry(entry, configurationSet);
        }
    }

    @Override
    public void processEntry(EconomicMap<String, ?> entry, ConfigurationSet configurationSet) {
        try {
            String tracer;
            switch (tracer = (String)entry.get((Object)"tracer")) {
                case "meta": {
                    String event = (String)entry.get((Object)"event");
                    if (event.equals("phase_change")) {
                        this.setInLivePhase(entry.get((Object)"phase").equals("live"));
                        break;
                    }
                    if (event.equals("initialization")) break;
                    TraceProcessor.logWarning("Unknown meta event, ignoring: " + event);
                    break;
                }
                case "jni": {
                    this.jniProcessor.processEntry(entry, configurationSet);
                    break;
                }
                case "reflect": {
                    this.reflectionProcessor.processEntry(entry, configurationSet);
                    break;
                }
                case "serialization": {
                    this.serializationProcessor.processEntry(entry, configurationSet);
                    break;
                }
                case "classloading": {
                    this.classLoadingProcessor.processEntry(entry, configurationSet);
                    break;
                }
                default: {
                    TraceProcessor.logWarning("Unknown tracer, ignoring: " + tracer);
                }
            }
        }
        catch (Exception e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            TraceProcessor.logWarning("Error processing trace entry " + entry.toString() + ": " + String.valueOf(stackTrace));
        }
    }

    @Override
    void setInLivePhase(boolean live) {
        this.advisor.setInLivePhase(live);
        this.jniProcessor.setInLivePhase(live);
        this.reflectionProcessor.setInLivePhase(live);
        super.setInLivePhase(live);
    }
}

