/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import java.lang.module.ModuleDescriptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ModuleFilterTools {
    public static HierarchyFilterNode generateFromModules(String[] moduleNames, ConfigurationFilter.Inclusion rootInclusion, ConfigurationFilter.Inclusion exportedInclusion, ConfigurationFilter.Inclusion unexportedInclusion, boolean reduce) {
        HashSet<String> includedModuleNameSet = new HashSet<String>();
        Collections.addAll(includedModuleNameSet, moduleNames);
        for (Module module : ModuleLayer.boot().modules()) {
            if (!includedModuleNameSet.contains(module.getName())) continue;
            ModuleFilterTools.checkDependencies(module, includedModuleNameSet);
        }
        HierarchyFilterNode rootNode = HierarchyFilterNode.createRoot();
        rootNode.addOrGetChildren("**", rootInclusion);
        for (Module module : ModuleLayer.boot().modules()) {
            for (String qualifiedPkg : module.getPackages()) {
                ConfigurationFilter.Inclusion pkgInclusion = module.isExported(qualifiedPkg) ? exportedInclusion : unexportedInclusion;
                rootNode.addOrGetChildren(qualifiedPkg + ".*", pkgInclusion);
            }
        }
        if (reduce) {
            rootNode.reduceExhaustiveTree();
        }
        return rootNode;
    }

    private static void checkDependencies(Module module, Set<String> includedModuleNames) {
        for (ModuleDescriptor.Requires require : module.getDescriptor().requires()) {
            if (includedModuleNames.contains(require.name())) continue;
            System.err.println("Warning: dependency missing from input set of modules: " + module.getName() + " -> " + require.name());
            ModuleFilterTools.checkDependencies(module.getLayer().findModule(require.name()).get(), includedModuleNames);
        }
    }
}

