/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;

public final class TextDocumentSurrogateMap {
    private final TruffleInstrument.Env env;
    private final Map<URI, TextDocumentSurrogate> uri2TextDocumentSurrogate = new LRUCacheMap<URI, TextDocumentSurrogate>();

    public TextDocumentSurrogateMap(TruffleInstrument.Env env) {
        this.env = env;
    }

    public TextDocumentSurrogate get(URI uri) {
        return this.uri2TextDocumentSurrogate.get(uri);
    }

    public void put(URI uri, TextDocumentSurrogate surrogate) {
        this.uri2TextDocumentSurrogate.put(uri, surrogate);
    }

    public TextDocumentSurrogate getOrCreateSurrogate(URI uri, LanguageInfo languageInfo) {
        return this.uri2TextDocumentSurrogate.computeIfAbsent(uri, anUri -> new TextDocumentSurrogate(this.env.getTruffleFile(null, anUri), languageInfo));
    }

    public TextDocumentSurrogate getOrCreateSurrogate(URI uri, Supplier<LanguageInfo> languageInfoSupplier) {
        return this.uri2TextDocumentSurrogate.computeIfAbsent(uri, anUri -> {
            LanguageInfo languageInfo = (LanguageInfo)languageInfoSupplier.get();
            return new TextDocumentSurrogate(this.env.getTruffleFile(null, anUri), languageInfo);
        });
    }

    public Collection<TextDocumentSurrogate> getSurrogates() {
        return this.uri2TextDocumentSurrogate.values();
    }

    public boolean containsSurrogate(URI uri) {
        return this.uri2TextDocumentSurrogate.containsKey(uri);
    }

    public void remove(URI uri) {
        this.uri2TextDocumentSurrogate.remove(uri);
    }

    public boolean isSourceNewestInSurrogate(Source source) {
        TextDocumentSurrogate surrogate = this.get(source.getURI());
        if (surrogate != null) {
            return source.equals((Object)surrogate.getSource());
        }
        return false;
    }

    private static class LRUCacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 2428506935618594078L;
        private static final int MAX_SIZE = 2048;

        LRUCacheMap() {
            super(32, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 2048;
        }
    }
}

