/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SaveOptions;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncKind;

public class TextDocumentSyncOptions
extends JSONBase {
    TextDocumentSyncOptions(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getOpenClose() {
        return this.jsonData.has("openClose") ? Boolean.valueOf(this.jsonData.getBoolean("openClose")) : null;
    }

    public TextDocumentSyncOptions setOpenClose(Boolean openClose) {
        this.jsonData.putOpt("openClose", openClose);
        return this;
    }

    public TextDocumentSyncKind getChange() {
        return TextDocumentSyncKind.get(this.jsonData.has("change") ? Integer.valueOf(this.jsonData.getInt("change")) : null);
    }

    public TextDocumentSyncOptions setChange(TextDocumentSyncKind change) {
        this.jsonData.putOpt("change", change != null ? Integer.valueOf(change.getIntValue()) : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getWillSave() {
        return this.jsonData.has("willSave") ? Boolean.valueOf(this.jsonData.getBoolean("willSave")) : null;
    }

    public TextDocumentSyncOptions setWillSave(Boolean willSave) {
        this.jsonData.putOpt("willSave", willSave);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getWillSaveWaitUntil() {
        return this.jsonData.has("willSaveWaitUntil") ? Boolean.valueOf(this.jsonData.getBoolean("willSaveWaitUntil")) : null;
    }

    public TextDocumentSyncOptions setWillSaveWaitUntil(Boolean willSaveWaitUntil) {
        this.jsonData.putOpt("willSaveWaitUntil", willSaveWaitUntil);
        return this;
    }

    public SaveOptions getSave() {
        return this.jsonData.has("save") ? new SaveOptions(this.jsonData.optJSONObject("save")) : null;
    }

    public TextDocumentSyncOptions setSave(SaveOptions save) {
        this.jsonData.putOpt("save", save != null ? save.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDocumentSyncOptions other = (TextDocumentSyncOptions)obj;
        if (!Objects.equals(this.getOpenClose(), other.getOpenClose())) {
            return false;
        }
        if (this.getChange() != other.getChange()) {
            return false;
        }
        if (!Objects.equals(this.getWillSave(), other.getWillSave())) {
            return false;
        }
        if (!Objects.equals(this.getWillSaveWaitUntil(), other.getWillSaveWaitUntil())) {
            return false;
        }
        return Objects.equals(this.getSave(), other.getSave());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getOpenClose() != null) {
            hash = 89 * hash + Boolean.hashCode(this.getOpenClose());
        }
        if (this.getChange() != null) {
            hash = 89 * hash + Objects.hashCode((Object)this.getChange());
        }
        if (this.getWillSave() != null) {
            hash = 89 * hash + Boolean.hashCode(this.getWillSave());
        }
        if (this.getWillSaveWaitUntil() != null) {
            hash = 89 * hash + Boolean.hashCode(this.getWillSaveWaitUntil());
        }
        if (this.getSave() != null) {
            hash = 89 * hash + Objects.hashCode(this.getSave());
        }
        return hash;
    }

    public static TextDocumentSyncOptions create() {
        JSONObject json = new JSONObject();
        return new TextDocumentSyncOptions(json);
    }
}

