/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupKind;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class SignatureHelpClientCapabilities
extends JSONBase {
    SignatureHelpClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDynamicRegistration() {
        return this.jsonData.has("dynamicRegistration") ? Boolean.valueOf(this.jsonData.getBoolean("dynamicRegistration")) : null;
    }

    public SignatureHelpClientCapabilities setDynamicRegistration(Boolean dynamicRegistration) {
        this.jsonData.putOpt("dynamicRegistration", dynamicRegistration);
        return this;
    }

    public SignatureInformationCapabilities getSignatureInformation() {
        return this.jsonData.has("signatureInformation") ? new SignatureInformationCapabilities(this.jsonData.optJSONObject("signatureInformation")) : null;
    }

    public SignatureHelpClientCapabilities setSignatureInformation(SignatureInformationCapabilities signatureInformation) {
        this.jsonData.putOpt("signatureInformation", signatureInformation != null ? signatureInformation.jsonData : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getContextSupport() {
        return this.jsonData.has("contextSupport") ? Boolean.valueOf(this.jsonData.getBoolean("contextSupport")) : null;
    }

    public SignatureHelpClientCapabilities setContextSupport(Boolean contextSupport) {
        this.jsonData.putOpt("contextSupport", contextSupport);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureHelpClientCapabilities other = (SignatureHelpClientCapabilities)obj;
        if (!Objects.equals(this.getDynamicRegistration(), other.getDynamicRegistration())) {
            return false;
        }
        if (!Objects.equals(this.getSignatureInformation(), other.getSignatureInformation())) {
            return false;
        }
        return Objects.equals(this.getContextSupport(), other.getContextSupport());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDynamicRegistration() != null) {
            hash = 23 * hash + Boolean.hashCode(this.getDynamicRegistration());
        }
        if (this.getSignatureInformation() != null) {
            hash = 23 * hash + Objects.hashCode(this.getSignatureInformation());
        }
        if (this.getContextSupport() != null) {
            hash = 23 * hash + Boolean.hashCode(this.getContextSupport());
        }
        return hash;
    }

    public static SignatureHelpClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new SignatureHelpClientCapabilities(json);
    }

    public static class SignatureInformationCapabilities
    extends JSONBase {
        SignatureInformationCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public List<MarkupKind> getDocumentationFormat() {
            JSONArray json = this.jsonData.optJSONArray("documentationFormat");
            if (json == null) {
                return null;
            }
            ArrayList<MarkupKind> list = new ArrayList<MarkupKind>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(MarkupKind.get(json.getString(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public SignatureInformationCapabilities setDocumentationFormat(List<MarkupKind> documentationFormat) {
            if (documentationFormat != null) {
                JSONArray json = new JSONArray();
                for (MarkupKind markupKind : documentationFormat) {
                    json.put(markupKind.getStringValue());
                }
                this.jsonData.put("documentationFormat", json);
            }
            return this;
        }

        public ParameterInformationCapabilities getParameterInformation() {
            return this.jsonData.has("parameterInformation") ? new ParameterInformationCapabilities(this.jsonData.optJSONObject("parameterInformation")) : null;
        }

        public SignatureInformationCapabilities setParameterInformation(ParameterInformationCapabilities parameterInformation) {
            this.jsonData.putOpt("parameterInformation", parameterInformation != null ? parameterInformation.jsonData : null);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SignatureInformationCapabilities other = (SignatureInformationCapabilities)obj;
            if (!Objects.equals(this.getDocumentationFormat(), other.getDocumentationFormat())) {
                return false;
            }
            return Objects.equals(this.getParameterInformation(), other.getParameterInformation());
        }

        public int hashCode() {
            int hash = 5;
            if (this.getDocumentationFormat() != null) {
                hash = 67 * hash + Objects.hashCode(this.getDocumentationFormat());
            }
            if (this.getParameterInformation() != null) {
                hash = 67 * hash + Objects.hashCode(this.getParameterInformation());
            }
            return hash;
        }

        public static class ParameterInformationCapabilities
        extends JSONBase {
            ParameterInformationCapabilities(JSONObject jsonData) {
                super(jsonData);
            }

            @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
            public Boolean getLabelOffsetSupport() {
                return this.jsonData.has("labelOffsetSupport") ? Boolean.valueOf(this.jsonData.getBoolean("labelOffsetSupport")) : null;
            }

            public ParameterInformationCapabilities setLabelOffsetSupport(Boolean labelOffsetSupport) {
                this.jsonData.putOpt("labelOffsetSupport", labelOffsetSupport);
                return this;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParameterInformationCapabilities other = (ParameterInformationCapabilities)obj;
                return Objects.equals(this.getLabelOffsetSupport(), other.getLabelOffsetSupport());
            }

            public int hashCode() {
                int hash = 5;
                if (this.getLabelOffsetSupport() != null) {
                    hash = 37 * hash + Boolean.hashCode(this.getLabelOffsetSupport());
                }
                return hash;
            }
        }
    }
}

