/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CodeActionOptions;
import org.graalvm.tools.lsp.server.types.CodeLensOptions;
import org.graalvm.tools.lsp.server.types.CompletionOptions;
import org.graalvm.tools.lsp.server.types.DeclarationOptions;
import org.graalvm.tools.lsp.server.types.DeclarationRegistrationOptions;
import org.graalvm.tools.lsp.server.types.DefinitionOptions;
import org.graalvm.tools.lsp.server.types.DocumentColorOptions;
import org.graalvm.tools.lsp.server.types.DocumentColorRegistrationOptions;
import org.graalvm.tools.lsp.server.types.DocumentFormattingOptions;
import org.graalvm.tools.lsp.server.types.DocumentHighlightOptions;
import org.graalvm.tools.lsp.server.types.DocumentLinkOptions;
import org.graalvm.tools.lsp.server.types.DocumentOnTypeFormattingOptions;
import org.graalvm.tools.lsp.server.types.DocumentRangeFormattingOptions;
import org.graalvm.tools.lsp.server.types.DocumentSymbolOptions;
import org.graalvm.tools.lsp.server.types.ExecuteCommandOptions;
import org.graalvm.tools.lsp.server.types.FoldingRangeOptions;
import org.graalvm.tools.lsp.server.types.FoldingRangeRegistrationOptions;
import org.graalvm.tools.lsp.server.types.HoverOptions;
import org.graalvm.tools.lsp.server.types.ImplementationOptions;
import org.graalvm.tools.lsp.server.types.ImplementationRegistrationOptions;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.ReferenceOptions;
import org.graalvm.tools.lsp.server.types.RenameOptions;
import org.graalvm.tools.lsp.server.types.SelectionRangeOptions;
import org.graalvm.tools.lsp.server.types.SelectionRangeRegistrationOptions;
import org.graalvm.tools.lsp.server.types.SignatureHelpOptions;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncKind;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncOptions;
import org.graalvm.tools.lsp.server.types.TypeDefinitionOptions;
import org.graalvm.tools.lsp.server.types.TypeDefinitionRegistrationOptions;
import org.graalvm.tools.lsp.server.types.WorkspaceSymbolOptions;

public class ServerCapabilities
extends JSONBase {
    ServerCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getTextDocumentSync() {
        Object obj = this.jsonData.opt("textDocumentSync");
        if (obj instanceof JSONObject) {
            return new TextDocumentSyncOptions((JSONObject)obj);
        }
        TextDocumentSyncKind textDocumentSyncKind = obj instanceof Integer ? TextDocumentSyncKind.get((Integer)obj) : null;
        return textDocumentSyncKind != null ? textDocumentSyncKind : obj;
    }

    public ServerCapabilities setTextDocumentSync(Object textDocumentSync) {
        if (textDocumentSync instanceof TextDocumentSyncOptions) {
            this.jsonData.put("textDocumentSync", ((TextDocumentSyncOptions)textDocumentSync).jsonData);
        } else if (textDocumentSync instanceof TextDocumentSyncKind) {
            this.jsonData.put("textDocumentSync", ((TextDocumentSyncKind)((Object)textDocumentSync)).getIntValue());
        } else {
            this.jsonData.put("textDocumentSync", textDocumentSync);
        }
        return this;
    }

    public CompletionOptions getCompletionProvider() {
        return this.jsonData.has("completionProvider") ? new CompletionOptions(this.jsonData.optJSONObject("completionProvider")) : null;
    }

    public ServerCapabilities setCompletionProvider(CompletionOptions completionProvider) {
        this.jsonData.putOpt("completionProvider", completionProvider != null ? completionProvider.jsonData : null);
        return this;
    }

    public Object getHoverProvider() {
        Object obj = this.jsonData.opt("hoverProvider");
        if (obj instanceof JSONObject) {
            return new HoverOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setHoverProvider(Object hoverProvider) {
        if (hoverProvider instanceof HoverOptions) {
            this.jsonData.put("hoverProvider", ((HoverOptions)hoverProvider).jsonData);
        } else {
            this.jsonData.put("hoverProvider", hoverProvider);
        }
        return this;
    }

    public SignatureHelpOptions getSignatureHelpProvider() {
        return this.jsonData.has("signatureHelpProvider") ? new SignatureHelpOptions(this.jsonData.optJSONObject("signatureHelpProvider")) : null;
    }

    public ServerCapabilities setSignatureHelpProvider(SignatureHelpOptions signatureHelpProvider) {
        this.jsonData.putOpt("signatureHelpProvider", signatureHelpProvider != null ? signatureHelpProvider.jsonData : null);
        return this;
    }

    public Object getDeclarationProvider() {
        Object obj = this.jsonData.opt("declarationProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("documentSelector") ? new DeclarationRegistrationOptions((JSONObject)obj) : new DeclarationOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDeclarationProvider(Object declarationProvider) {
        if (declarationProvider instanceof DeclarationRegistrationOptions) {
            this.jsonData.put("declarationProvider", ((DeclarationRegistrationOptions)declarationProvider).jsonData);
        } else if (declarationProvider instanceof DeclarationOptions) {
            this.jsonData.put("declarationProvider", ((DeclarationOptions)declarationProvider).jsonData);
        } else {
            this.jsonData.putOpt("declarationProvider", declarationProvider);
        }
        return this;
    }

    public Object getDefinitionProvider() {
        Object obj = this.jsonData.opt("definitionProvider");
        if (obj instanceof JSONObject) {
            return new DefinitionOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDefinitionProvider(Object definitionProvider) {
        if (definitionProvider instanceof DefinitionOptions) {
            this.jsonData.put("definitionProvider", ((DefinitionOptions)definitionProvider).jsonData);
        } else {
            this.jsonData.put("definitionProvider", definitionProvider);
        }
        return this;
    }

    public Object getTypeDefinitionProvider() {
        Object obj = this.jsonData.opt("typeDefinitionProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("documentSelector") ? new TypeDefinitionRegistrationOptions((JSONObject)obj) : new TypeDefinitionOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setTypeDefinitionProvider(Object typeDefinitionProvider) {
        if (typeDefinitionProvider instanceof TypeDefinitionRegistrationOptions) {
            this.jsonData.put("typeDefinitionProvider", ((TypeDefinitionRegistrationOptions)typeDefinitionProvider).jsonData);
        } else if (typeDefinitionProvider instanceof TypeDefinitionOptions) {
            this.jsonData.put("typeDefinitionProvider", ((TypeDefinitionOptions)typeDefinitionProvider).jsonData);
        } else {
            this.jsonData.putOpt("typeDefinitionProvider", typeDefinitionProvider);
        }
        return this;
    }

    public Object getImplementationProvider() {
        Object obj = this.jsonData.opt("implementationProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("implementationProvider") ? new ImplementationRegistrationOptions((JSONObject)obj) : new ImplementationOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setImplementationProvider(Object implementationProvider) {
        if (implementationProvider instanceof ImplementationRegistrationOptions) {
            this.jsonData.put("implementationProvider", ((ImplementationRegistrationOptions)implementationProvider).jsonData);
        } else if (implementationProvider instanceof ImplementationOptions) {
            this.jsonData.put("implementationProvider", ((ImplementationOptions)implementationProvider).jsonData);
        } else {
            this.jsonData.putOpt("implementationProvider", implementationProvider);
        }
        return this;
    }

    public Object getReferencesProvider() {
        Object obj = this.jsonData.opt("referencesProvider");
        if (obj instanceof JSONObject) {
            return new ReferenceOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setReferencesProvider(Object referencesProvider) {
        if (referencesProvider instanceof ReferenceOptions) {
            this.jsonData.put("referencesProvider", ((ReferenceOptions)referencesProvider).jsonData);
        } else {
            this.jsonData.put("referencesProvider", referencesProvider);
        }
        return this;
    }

    public Object getDocumentHighlightProvider() {
        Object obj = this.jsonData.opt("documentHighlightProvider");
        if (obj instanceof JSONObject) {
            return new DocumentHighlightOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDocumentHighlightProvider(Object documentHighlightProvider) {
        if (documentHighlightProvider instanceof DocumentHighlightOptions) {
            this.jsonData.put("documentHighlightProvider", ((DocumentHighlightOptions)documentHighlightProvider).jsonData);
        } else {
            this.jsonData.put("documentHighlightProvider", documentHighlightProvider);
        }
        return this;
    }

    public Object getDocumentSymbolProvider() {
        Object obj = this.jsonData.opt("documentSymbolProvider");
        if (obj instanceof JSONObject) {
            return new DocumentSymbolOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDocumentSymbolProvider(Object documentSymbolProvider) {
        if (documentSymbolProvider instanceof DocumentSymbolOptions) {
            this.jsonData.put("documentSymbolProvider", ((DocumentSymbolOptions)documentSymbolProvider).jsonData);
        } else {
            this.jsonData.put("documentSymbolProvider", documentSymbolProvider);
        }
        return this;
    }

    public Object getCodeActionProvider() {
        Object obj = this.jsonData.opt("codeActionProvider");
        if (obj instanceof JSONObject) {
            return new CodeActionOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setCodeActionProvider(Object codeActionProvider) {
        if (codeActionProvider instanceof CodeActionOptions) {
            this.jsonData.put("codeActionProvider", ((CodeActionOptions)codeActionProvider).jsonData);
        } else {
            this.jsonData.put("codeActionProvider", codeActionProvider);
        }
        return this;
    }

    public CodeLensOptions getCodeLensProvider() {
        return this.jsonData.has("codeLensProvider") ? new CodeLensOptions(this.jsonData.optJSONObject("codeLensProvider")) : null;
    }

    public ServerCapabilities setCodeLensProvider(CodeLensOptions codeLensProvider) {
        this.jsonData.putOpt("codeLensProvider", codeLensProvider != null ? codeLensProvider.jsonData : null);
        return this;
    }

    public DocumentLinkOptions getDocumentLinkProvider() {
        return this.jsonData.has("documentLinkProvider") ? new DocumentLinkOptions(this.jsonData.optJSONObject("documentLinkProvider")) : null;
    }

    public ServerCapabilities setDocumentLinkProvider(DocumentLinkOptions documentLinkProvider) {
        this.jsonData.putOpt("documentLinkProvider", documentLinkProvider != null ? documentLinkProvider.jsonData : null);
        return this;
    }

    public Object getColorProvider() {
        Object obj = this.jsonData.opt("colorProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("documentSelector") ? new DocumentColorRegistrationOptions((JSONObject)obj) : new DocumentColorOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setColorProvider(Object colorProvider) {
        if (colorProvider instanceof DocumentColorRegistrationOptions) {
            this.jsonData.put("colorProvider", ((DocumentColorRegistrationOptions)colorProvider).jsonData);
        } else if (colorProvider instanceof DocumentColorOptions) {
            this.jsonData.put("colorProvider", ((DocumentColorOptions)colorProvider).jsonData);
        } else {
            this.jsonData.putOpt("colorProvider", colorProvider);
        }
        return this;
    }

    public Object getWorkspaceSymbolProvider() {
        Object obj = this.jsonData.opt("workspaceSymbolProvider");
        if (obj instanceof JSONObject) {
            return new WorkspaceSymbolOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setWorkspaceSymbolProvider(Object workspaceSymbolProvider) {
        if (workspaceSymbolProvider instanceof WorkspaceSymbolOptions) {
            this.jsonData.put("workspaceSymbolProvider", ((WorkspaceSymbolOptions)workspaceSymbolProvider).jsonData);
        } else {
            this.jsonData.put("workspaceSymbolProvider", workspaceSymbolProvider);
        }
        return this;
    }

    public Object getDocumentFormattingProvider() {
        Object obj = this.jsonData.opt("documentFormattingProvider");
        if (obj instanceof JSONObject) {
            return new DocumentFormattingOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDocumentFormattingProvider(Object documentFormattingProvider) {
        if (documentFormattingProvider instanceof DocumentFormattingOptions) {
            this.jsonData.put("documentFormattingProvider", ((DocumentFormattingOptions)documentFormattingProvider).jsonData);
        } else {
            this.jsonData.put("documentFormattingProvider", documentFormattingProvider);
        }
        return this;
    }

    public Object getDocumentRangeFormattingProvider() {
        Object obj = this.jsonData.opt("documentRangeFormattingProvider");
        if (obj instanceof JSONObject) {
            return new DocumentRangeFormattingOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setDocumentRangeFormattingProvider(Object documentRangeFormattingProvider) {
        if (documentRangeFormattingProvider instanceof DocumentRangeFormattingOptions) {
            this.jsonData.put("documentRangeFormattingProvider", ((DocumentRangeFormattingOptions)documentRangeFormattingProvider).jsonData);
        } else {
            this.jsonData.put("documentRangeFormattingProvider", documentRangeFormattingProvider);
        }
        return this;
    }

    public DocumentOnTypeFormattingOptions getDocumentOnTypeFormattingProvider() {
        return this.jsonData.has("documentOnTypeFormattingProvider") ? new DocumentOnTypeFormattingOptions(this.jsonData.optJSONObject("documentOnTypeFormattingProvider")) : null;
    }

    public ServerCapabilities setDocumentOnTypeFormattingProvider(DocumentOnTypeFormattingOptions documentOnTypeFormattingProvider) {
        this.jsonData.putOpt("documentOnTypeFormattingProvider", documentOnTypeFormattingProvider != null ? documentOnTypeFormattingProvider.jsonData : null);
        return this;
    }

    public Object getRenameProvider() {
        Object obj = this.jsonData.opt("renameProvider");
        if (obj instanceof JSONObject) {
            return new RenameOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setRenameProvider(Object renameProvider) {
        if (renameProvider instanceof RenameOptions) {
            this.jsonData.put("renameProvider", ((RenameOptions)renameProvider).jsonData);
        } else {
            this.jsonData.put("renameProvider", renameProvider);
        }
        return this;
    }

    public Object getFoldingRangeProvider() {
        Object obj = this.jsonData.opt("foldingRangeProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("documentSelector") ? new FoldingRangeRegistrationOptions((JSONObject)obj) : new FoldingRangeOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setFoldingRangeProvider(Object foldingRangeProvider) {
        if (foldingRangeProvider instanceof FoldingRangeRegistrationOptions) {
            this.jsonData.put("foldingRangeProvider", ((FoldingRangeRegistrationOptions)foldingRangeProvider).jsonData);
        } else if (foldingRangeProvider instanceof FoldingRangeOptions) {
            this.jsonData.put("foldingRangeProvider", ((FoldingRangeOptions)foldingRangeProvider).jsonData);
        } else {
            this.jsonData.putOpt("foldingRangeProvider", foldingRangeProvider);
        }
        return this;
    }

    public Object getSelectionRangeProvider() {
        Object obj = this.jsonData.opt("selectionRangeProvider");
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).has("documentSelector") ? new SelectionRangeRegistrationOptions((JSONObject)obj) : new SelectionRangeOptions((JSONObject)obj);
        }
        return obj;
    }

    public ServerCapabilities setSelectionRangeProvider(Object selectionRangeProvider) {
        if (selectionRangeProvider instanceof SelectionRangeRegistrationOptions) {
            this.jsonData.put("selectionRangeProvider", ((SelectionRangeRegistrationOptions)selectionRangeProvider).jsonData);
        } else if (selectionRangeProvider instanceof SelectionRangeOptions) {
            this.jsonData.put("selectionRangeProvider", ((SelectionRangeOptions)selectionRangeProvider).jsonData);
        } else {
            this.jsonData.putOpt("selectionRangeProvider", selectionRangeProvider);
        }
        return this;
    }

    public ExecuteCommandOptions getExecuteCommandProvider() {
        return this.jsonData.has("executeCommandProvider") ? new ExecuteCommandOptions(this.jsonData.optJSONObject("executeCommandProvider")) : null;
    }

    public ServerCapabilities setExecuteCommandProvider(ExecuteCommandOptions executeCommandProvider) {
        this.jsonData.putOpt("executeCommandProvider", executeCommandProvider != null ? executeCommandProvider.jsonData : null);
        return this;
    }

    public Object getExperimental() {
        return this.jsonData.opt("experimental");
    }

    public ServerCapabilities setExperimental(Object experimental) {
        this.jsonData.putOpt("experimental", experimental);
        return this;
    }

    public WorkspaceCapabilities getWorkspace() {
        return this.jsonData.has("workspace") ? new WorkspaceCapabilities(this.jsonData.optJSONObject("workspace")) : null;
    }

    public ServerCapabilities setWorkspace(WorkspaceCapabilities workspace) {
        this.jsonData.putOpt("workspace", workspace != null ? workspace.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerCapabilities other = (ServerCapabilities)obj;
        if (!Objects.equals(this.getTextDocumentSync(), other.getTextDocumentSync())) {
            return false;
        }
        if (!Objects.equals(this.getCompletionProvider(), other.getCompletionProvider())) {
            return false;
        }
        if (!Objects.equals(this.getHoverProvider(), other.getHoverProvider())) {
            return false;
        }
        if (!Objects.equals(this.getSignatureHelpProvider(), other.getSignatureHelpProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDeclarationProvider(), other.getDeclarationProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDefinitionProvider(), other.getDefinitionProvider())) {
            return false;
        }
        if (!Objects.equals(this.getTypeDefinitionProvider(), other.getTypeDefinitionProvider())) {
            return false;
        }
        if (!Objects.equals(this.getImplementationProvider(), other.getImplementationProvider())) {
            return false;
        }
        if (!Objects.equals(this.getReferencesProvider(), other.getReferencesProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentHighlightProvider(), other.getDocumentHighlightProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentSymbolProvider(), other.getDocumentSymbolProvider())) {
            return false;
        }
        if (!Objects.equals(this.getCodeActionProvider(), other.getCodeActionProvider())) {
            return false;
        }
        if (!Objects.equals(this.getCodeLensProvider(), other.getCodeLensProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentLinkProvider(), other.getDocumentLinkProvider())) {
            return false;
        }
        if (!Objects.equals(this.getColorProvider(), other.getColorProvider())) {
            return false;
        }
        if (!Objects.equals(this.getWorkspaceSymbolProvider(), other.getWorkspaceSymbolProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentFormattingProvider(), other.getDocumentFormattingProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentRangeFormattingProvider(), other.getDocumentRangeFormattingProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentOnTypeFormattingProvider(), other.getDocumentOnTypeFormattingProvider())) {
            return false;
        }
        if (!Objects.equals(this.getRenameProvider(), other.getRenameProvider())) {
            return false;
        }
        if (!Objects.equals(this.getFoldingRangeProvider(), other.getFoldingRangeProvider())) {
            return false;
        }
        if (!Objects.equals(this.getSelectionRangeProvider(), other.getSelectionRangeProvider())) {
            return false;
        }
        if (!Objects.equals(this.getExecuteCommandProvider(), other.getExecuteCommandProvider())) {
            return false;
        }
        if (!Objects.equals(this.getExperimental(), other.getExperimental())) {
            return false;
        }
        return Objects.equals(this.getWorkspace(), other.getWorkspace());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getTextDocumentSync() != null) {
            hash = 83 * hash + Objects.hashCode(this.getTextDocumentSync());
        }
        if (this.getCompletionProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getCompletionProvider());
        }
        if (this.getHoverProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getHoverProvider());
        }
        if (this.getSignatureHelpProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getSignatureHelpProvider());
        }
        if (this.getDeclarationProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDeclarationProvider());
        }
        if (this.getDefinitionProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDefinitionProvider());
        }
        if (this.getTypeDefinitionProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getTypeDefinitionProvider());
        }
        if (this.getImplementationProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getImplementationProvider());
        }
        if (this.getReferencesProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getReferencesProvider());
        }
        if (this.getDocumentHighlightProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentHighlightProvider());
        }
        if (this.getDocumentSymbolProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentSymbolProvider());
        }
        if (this.getCodeActionProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getCodeActionProvider());
        }
        if (this.getCodeLensProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getCodeLensProvider());
        }
        if (this.getDocumentLinkProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentLinkProvider());
        }
        if (this.getColorProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getColorProvider());
        }
        if (this.getWorkspaceSymbolProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getWorkspaceSymbolProvider());
        }
        if (this.getDocumentFormattingProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentFormattingProvider());
        }
        if (this.getDocumentRangeFormattingProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentRangeFormattingProvider());
        }
        if (this.getDocumentOnTypeFormattingProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentOnTypeFormattingProvider());
        }
        if (this.getRenameProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getRenameProvider());
        }
        if (this.getFoldingRangeProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getFoldingRangeProvider());
        }
        if (this.getSelectionRangeProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getSelectionRangeProvider());
        }
        if (this.getExecuteCommandProvider() != null) {
            hash = 83 * hash + Objects.hashCode(this.getExecuteCommandProvider());
        }
        if (this.getExperimental() != null) {
            hash = 83 * hash + Objects.hashCode(this.getExperimental());
        }
        if (this.getWorkspace() != null) {
            hash = 83 * hash + Objects.hashCode(this.getWorkspace());
        }
        return hash;
    }

    public static ServerCapabilities create() {
        JSONObject json = new JSONObject();
        return new ServerCapabilities(json);
    }

    public static class WorkspaceCapabilities
    extends JSONBase {
        WorkspaceCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public WorkspaceFoldersCapabilities getWorkspaceFolders() {
            return this.jsonData.has("workspaceFolders") ? new WorkspaceFoldersCapabilities(this.jsonData.optJSONObject("workspaceFolders")) : null;
        }

        public WorkspaceCapabilities setWorkspaceFolders(WorkspaceFoldersCapabilities workspaceFolders) {
            this.jsonData.putOpt("workspaceFolders", workspaceFolders != null ? workspaceFolders.jsonData : null);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkspaceCapabilities other = (WorkspaceCapabilities)obj;
            return Objects.equals(this.getWorkspaceFolders(), other.getWorkspaceFolders());
        }

        public int hashCode() {
            int hash = 7;
            if (this.getWorkspaceFolders() != null) {
                hash = 53 * hash + Objects.hashCode(this.getWorkspaceFolders());
            }
            return hash;
        }

        public static class WorkspaceFoldersCapabilities
        extends JSONBase {
            WorkspaceFoldersCapabilities(JSONObject jsonData) {
                super(jsonData);
            }

            @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
            public Boolean getSupported() {
                return this.jsonData.has("supported") ? Boolean.valueOf(this.jsonData.getBoolean("supported")) : null;
            }

            public WorkspaceFoldersCapabilities setSupported(Boolean supported) {
                this.jsonData.putOpt("supported", supported);
                return this;
            }

            public Object getChangeNotifications() {
                return this.jsonData.opt("changeNotifications");
            }

            public WorkspaceFoldersCapabilities setChangeNotifications(Object changeNotifications) {
                this.jsonData.putOpt("changeNotifications", changeNotifications);
                return this;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                WorkspaceFoldersCapabilities other = (WorkspaceFoldersCapabilities)obj;
                if (!Objects.equals(this.getSupported(), other.getSupported())) {
                    return false;
                }
                return Objects.equals(this.getChangeNotifications(), other.getChangeNotifications());
            }

            public int hashCode() {
                int hash = 5;
                if (this.getSupported() != null) {
                    hash = 43 * hash + Boolean.hashCode(this.getSupported());
                }
                if (this.getChangeNotifications() != null) {
                    hash = 43 * hash + Objects.hashCode(this.getChangeNotifications());
                }
                return hash;
            }
        }
    }
}

