/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;

public class SelectionRangeParams
extends WorkDoneProgressParams {
    SelectionRangeParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public SelectionRangeParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public List<Position> getPositions() {
        JSONArray json = this.jsonData.getJSONArray("positions");
        ArrayList<Position> list = new ArrayList<Position>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Position(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SelectionRangeParams setPositions(List<Position> positions) {
        JSONArray json = new JSONArray();
        for (Position position : positions) {
            json.put(position.jsonData);
        }
        this.jsonData.put("positions", json);
        return this;
    }

    public Object getPartialResultToken() {
        return this.jsonData.opt("partialResultToken");
    }

    public SelectionRangeParams setPartialResultToken(Object partialResultToken) {
        this.jsonData.putOpt("partialResultToken", partialResultToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionRangeParams other = (SelectionRangeParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getPositions(), other.getPositions())) {
            return false;
        }
        if (!Objects.equals(this.getPartialResultToken(), other.getPartialResultToken())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + Objects.hashCode(this.getTextDocument());
        hash = 73 * hash + Objects.hashCode(this.getPositions());
        if (this.getPartialResultToken() != null) {
            hash = 73 * hash + Objects.hashCode(this.getPartialResultToken());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 73 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static SelectionRangeParams create(TextDocumentIdentifier textDocument, List<Position> positions) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        JSONArray positionsJsonArr = new JSONArray();
        for (Position position : positions) {
            positionsJsonArr.put(position.jsonData);
        }
        json.put("positions", positionsJsonArr);
        return new SelectionRangeParams(json);
    }
}

