/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.ReferenceContext;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;

public class ReferenceParams
extends TextDocumentPositionParams {
    ReferenceParams(JSONObject jsonData) {
        super(jsonData);
    }

    public ReferenceContext getContext() {
        return new ReferenceContext(this.jsonData.getJSONObject("context"));
    }

    public ReferenceParams setContext(ReferenceContext context) {
        this.jsonData.put("context", context.jsonData);
        return this;
    }

    public Object getWorkDoneToken() {
        return this.jsonData.opt("workDoneToken");
    }

    public ReferenceParams setWorkDoneToken(Object workDoneToken) {
        this.jsonData.putOpt("workDoneToken", workDoneToken);
        return this;
    }

    public Object getPartialResultToken() {
        return this.jsonData.opt("partialResultToken");
    }

    public ReferenceParams setPartialResultToken(Object partialResultToken) {
        this.jsonData.putOpt("partialResultToken", partialResultToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceParams other = (ReferenceParams)obj;
        if (!Objects.equals(this.getContext(), other.getContext())) {
            return false;
        }
        if (!Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken())) {
            return false;
        }
        if (!Objects.equals(this.getPartialResultToken(), other.getPartialResultToken())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getPosition(), other.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.getContext());
        if (this.getWorkDoneToken() != null) {
            hash = 37 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        if (this.getPartialResultToken() != null) {
            hash = 37 * hash + Objects.hashCode(this.getPartialResultToken());
        }
        hash = 37 * hash + Objects.hashCode(this.getTextDocument());
        hash = 37 * hash + Objects.hashCode(this.getPosition());
        return hash;
    }

    public static ReferenceParams create(ReferenceContext context, TextDocumentIdentifier textDocument, Position position) {
        JSONObject json = new JSONObject();
        json.put("context", context.jsonData);
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        return new ReferenceParams(json);
    }
}

